/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.JoinStreak;

import java.util.UUID;
import me.thegabro.playtimemanager.GUIs.JoinStreak.RewardsInfoGui;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.server.PluginDisableEvent;

public class InventoryListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof RewardsInfoGui) {
            Player player;
            RewardsInfoGui gui;
            e.setCancelled(true);
            HumanEntity humanEntity = e.getWhoClicked();
            if (humanEntity instanceof Player && (gui = RewardsInfoGui.activeGuis.get((player = (Player)humanEntity).getUniqueId())) != null) {
                gui.onGUIClick(player, e.getRawSlot(), e.getCurrentItem(), e.getAction(), e);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity;
        if (event.getInventory().getHolder() instanceof RewardsInfoGui && (humanEntity = event.getPlayer()) instanceof Player) {
            Player player = (Player)humanEntity;
            RewardsInfoGui.activeGuis.remove(player.getUniqueId());
            PlayTimeManager.getInstance().getSessionManager().endSession(player.getUniqueId());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        RewardsInfoGui.activeGuis.remove(playerId);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent e) {
        if (e.getInventory().getHolder() instanceof RewardsInfoGui) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent e) {
        Player player = e.getPlayer();
        if (RewardsInfoGui.activeGuis.containsKey(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSwap(PlayerSwapHandItemsEvent e) {
        Player player = e.getPlayer();
        if (RewardsInfoGui.activeGuis.containsKey(player.getUniqueId())) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPluginDisable(PluginDisableEvent e) {
        if (e.getPlugin().equals((Object)PlayTimeManager.getInstance())) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof RewardsInfoGui)) continue;
                player.closeInventory();
            }
            RewardsInfoGui.activeGuis.clear();
        }
    }
}

