/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.JoinStreak;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.thegabro.playtimemanager.GUIs.JoinStreak.JoinStreakRewardSettingsGui;
import me.thegabro.playtimemanager.JoinStreaks.JoinStreakReward;
import me.thegabro.playtimemanager.JoinStreaks.ManagingClasses.JoinStreaksManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllJoinStreakRewardsGui
implements InventoryHolder,
Listener {
    private final Inventory inv;
    private final ArrayList<Integer> protectedSlots = new ArrayList();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final JoinStreaksManager rewardsManager = JoinStreaksManager.getInstance();
    private int currentPage = 0;
    private List<JoinStreakReward> sortedRewards = new ArrayList<JoinStreakReward>();
    private final int REWARDS_PER_PAGE = 28;
    private final int NEXT_BUTTON_SLOT = 50;
    private final int PREV_BUTTON_SLOT = 48;
    private final int PAGE_INDICATOR_SLOT = 49;
    private final int TOGGLE_SCHEDULE = 5;
    private final int CREATE_REWARD = 4;
    private final int INFO = 3;

    public AllJoinStreakRewardsGui() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"Join Streak Rewards"));
    }

    public void openInventory(Player p) {
        this.currentPage = 0;
        this.initializeItems();
        p.openInventory(this.inv);
    }

    public void openInventory(Player p, int page) {
        this.currentPage = page;
        this.initializeItems();
        p.openInventory(this.inv);
    }

    public void initializeItems() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        Map<String, Object> nextSchedule = this.rewardsManager.getNextSchedule();
        int leftIndex = 9;
        int rightIndex = 17;
        Set<JoinStreakReward> rewardsSet = this.rewardsManager.getRewardRegistry().getRewards();
        this.sortedRewards = rewardsSet.stream().sorted(Comparator.comparing(r -> r.getMinRequiredJoins() == -1 ? Integer.MAX_VALUE : r.getMinRequiredJoins()).thenComparing(r -> r.getMaxRequiredJoins() == -1 ? Integer.MAX_VALUE : r.getMaxRequiredJoins())).toList();
        this.protectedSlots.clear();
        this.inv.clear();
        for (int i = 0; i < 54; ++i) {
            if (i > 9 && i < 45 && i != leftIndex && i != rightIndex) continue;
            this.inv.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors("&f[&6P.T.M.&f]&7"), new Component[0]));
            this.protectedSlots.add(i);
            if (i == leftIndex) {
                leftIndex += 9;
            }
            if (i != rightIndex) continue;
            rightIndex += 9;
        }
        this.inv.setItem(3, this.createGuiItem(Material.COMPASS, Utils.parseColors("&e&lSystem Information"), Utils.parseColors("&7Next join streak check: &e" + (String)(nextSchedule.get("nextReset") != null ? formatter.format(((Date)nextSchedule.get("nextReset")).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()) + " &7(in &e" + String.valueOf(nextSchedule.get("timeRemaining")) + "&7)" : "-")), Utils.parseColors(""), Utils.parseColors("&7Reward cycle will reset after player"), Utils.parseColors("&7reaches reward with ID: &e#" + String.valueOf(this.rewardsManager.getRewardRegistry().getLastRewardByJoins() != null ? Integer.valueOf(this.rewardsManager.getRewardRegistry().getLastRewardByJoins().getId()) : "-")), Utils.parseColors("&7which requires &e" + String.valueOf(this.rewardsManager.getRewardRegistry().getLastRewardByJoins() != null ? Integer.valueOf(this.rewardsManager.getRewardRegistry().getLastRewardByJoins().getMaxRequiredJoins()) : "-") + " &7consecutive joins to complete")));
        this.protectedSlots.add(4);
        this.inv.setItem(4, this.createGuiItem(Material.EMERALD, Utils.parseColors("&a&lCreate New Reward"), Utils.parseColors("&7Click to create a new join streak reward")));
        this.protectedSlots.add(4);
        boolean isActive = this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation");
        boolean hasRewards = !this.rewardsManager.getRewardRegistry().getRewards().isEmpty();
        this.inv.setItem(5, this.createGuiItem(isActive && hasRewards ? Material.GREEN_CONCRETE : Material.RED_CONCRETE, Utils.parseColors(isActive && hasRewards ? "&e&lRewards status: &2&lON" : "&e&lRewards status: &4&lOFF"), new Component[]{Utils.parseColors("&7Click to toggle the schedule"), Utils.parseColors("&7When set to &cOFF&7, the plugin will stop"), Utils.parseColors("&7granting rewards but will continue"), Utils.parseColors("&7tracking players' join streaks."), hasRewards ? Component.text((String)"") : Utils.parseColors("&c&lNo rewards available!")}));
        this.protectedSlots.add(5);
        int totalPages = (int)Math.ceil((double)this.sortedRewards.size() / 28.0);
        if (totalPages > 1) {
            this.inv.setItem(49, this.createGuiItem(Material.PAPER, Utils.parseColors("&e&lPage " + (this.currentPage + 1) + " of " + totalPages), new Component[0]));
            this.protectedSlots.add(49);
            if (this.currentPage < totalPages - 1) {
                this.inv.setItem(50, this.createGuiItem(Material.ARROW, Utils.parseColors("&a&lNext Page \u2192"), Utils.parseColors("&7Click to view the next page")));
            } else {
                this.inv.setItem(50, this.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lNo More Pages"), new Component[0]));
            }
            this.protectedSlots.add(50);
            if (this.currentPage > 0) {
                this.inv.setItem(48, this.createGuiItem(Material.ARROW, Utils.parseColors("&a&l\u2190 Previous Page"), Utils.parseColors("&7Click to view the previous page")));
            } else {
                this.inv.setItem(48, this.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lFirst Page"), new Component[0]));
            }
            this.protectedSlots.add(48);
        }
        if (!this.sortedRewards.isEmpty()) {
            int startIndex = this.currentPage * 28;
            int endIndex = Math.min(startIndex + 28, this.sortedRewards.size());
            List<JoinStreakReward> currentPageRewards = this.sortedRewards.subList(startIndex, endIndex);
            int slot = 10;
            for (JoinStreakReward reward : currentPageRewards) {
                while (this.protectedSlots.contains(slot)) {
                    ++slot;
                }
                if (slot < 45) {
                    this.inv.setItem(slot, this.createGuiItem(Material.valueOf((String)reward.getItemIcon()), Utils.parseColors("&e&l#ID&r&e " + reward.getId()), Utils.parseColors("&7Required Joins: &e" + (reward.getMinRequiredJoins() == -1 ? "-" : reward.getRequiredJoinsDisplay())), Utils.parseColors("&e" + reward.getPermissions().size() + "&7 " + (reward.getPermissions().size() != 1 ? "permissions loaded" : "permission loaded")), Utils.parseColors("&e" + reward.getCommands().size() + "&7 " + (reward.getCommands().size() != 1 ? "commands loaded" : "command loaded")), Utils.parseColors("&aMiddle click to clone this reward"), Utils.parseColors(""), Utils.parseColors("&c&oShift-Right Click to delete")));
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.BARRIER, Utils.parseColors("&l&cNo join streak rewards have been created!"), new Component[0]));
        }
    }

    private ItemStack createGuiItem(Material material, @Nullable Component name, Component ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (name != null) {
            meta.displayName(name.decoration(TextDecoration.ITALIC, false));
        }
        ArrayList<Component> metalore = new ArrayList<Component>();
        if (lore != null) {
            for (Component loreLine : lore) {
                metalore.add(loreLine.decoration(TextDecoration.ITALIC, false));
            }
        }
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryClickEvent event) {
        String displayName;
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        if (slot == 5 && (clickedItem.getType() == Material.GREEN_CONCRETE || clickedItem.getType() == Material.RED_CONCRETE)) {
            boolean hasRewards;
            boolean bl = hasRewards = !this.rewardsManager.getRewardRegistry().getRewards().isEmpty();
            if (!hasRewards) {
                whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &cCannot enable rewards: No rewards have been created!"));
                return;
            }
            boolean toggleSuccess = this.rewardsManager.toggleJoinStreakCheckSchedule((CommandSender)whoClicked);
            if (toggleSuccess) {
                this.initializeItems();
                whoClicked.updateInventory();
            }
            return;
        }
        if (slot == 4 && clickedItem.getType() == Material.EMERALD) {
            whoClicked.closeInventory();
            this.rewardsManager.getRewardRegistry().addReward(new JoinStreakReward(this.plugin, this.rewardsManager.getRewardRegistry().getNextRewardId(), -1));
            this.openInventory(whoClicked);
            return;
        }
        if (slot == 50 && clickedItem.getType() == Material.ARROW) {
            this.openInventory(whoClicked, this.currentPage + 1);
            return;
        }
        if (slot == 48 && clickedItem.getType() == Material.ARROW) {
            this.openInventory(whoClicked, this.currentPage - 1);
            return;
        }
        if (clickedItem.getItemMeta() != null && clickedItem.getItemMeta().displayName() != null && ((displayName = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName())).startsWith("#ID ") || displayName.contains("#ID "))) {
            String idPart = displayName.substring(displayName.indexOf("#ID ") + 4).trim();
            try {
                int id = Integer.parseInt(idPart);
                JoinStreakReward reward = this.rewardsManager.getRewardRegistry().getReward(id);
                if (reward == null) {
                    return;
                }
                if (event.getClick().isCreativeAction()) {
                    whoClicked.closeInventory();
                    whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &7Cloning reward &e" + id + "&7..."));
                    int newId = this.rewardsManager.getRewardRegistry().getNextRewardId();
                    JoinStreakReward clonedReward = this.cloneReward(newId, reward);
                    this.rewardsManager.getRewardRegistry().addReward(clonedReward);
                    whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &aSuccessfully &7cloned reward &e" + id + " &7to new reward &e" + newId));
                    this.openInventory(whoClicked);
                    return;
                }
                if (event.isShiftClick() && event.isRightClick()) {
                    whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &7Deleting reward &e" + id + "&7..."));
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayTimeManager.getInstance(), () -> {
                        reward.kill();
                        Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getInstance(), () -> {
                            whoClicked.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &aSuccessfully &7deleted reward &e" + id));
                            this.openInventory(whoClicked);
                        });
                    });
                } else if (!event.getClick().isCreativeAction()) {
                    whoClicked.closeInventory();
                    JoinStreakRewardSettingsGui settingsGui = new JoinStreakRewardSettingsGui(reward, this);
                    settingsGui.openInventory(whoClicked);
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                return;
            }
        }
    }

    private JoinStreakReward cloneReward(int newId, JoinStreakReward reward) {
        JoinStreakReward clonedReward = new JoinStreakReward(this.plugin, newId, reward.getMinRequiredJoins());
        clonedReward.setRequiredJoinsRange(reward.getMinRequiredJoins(), reward.getMaxRequiredJoins());
        clonedReward.setItemIcon(reward.getItemIcon());
        clonedReward.setRewardDescription(reward.getRewardDescription());
        clonedReward.setRewardMessage(reward.getRewardMessage());
        clonedReward.setDescription(reward.getDescription());
        clonedReward.setRewardSound(reward.getRewardSound());
        for (String command : reward.getCommands()) {
            clonedReward.addCommand(command);
        }
        for (String permission : reward.getPermissions()) {
            clonedReward.addPermission(permission);
        }
        return clonedReward;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof AllJoinStreakRewardsGui) {
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                AllJoinStreakRewardsGui gui = (AllJoinStreakRewardsGui)e.getInventory().getHolder();
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e);
            } else if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity;
        if (event.getInventory().getHolder() instanceof AllJoinStreakRewardsGui && (humanEntity = event.getPlayer()) instanceof Player) {
            Player player = (Player)humanEntity;
            if (!this.plugin.getConfiguration().getBoolean("rewards-check-schedule-activation").booleanValue()) {
                event.getPlayer().sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &c&l\u26a0 WARNING &c&l\u26a0"));
                event.getPlayer().sendMessage(Utils.parseColors("&7The join streak rewards schedule is currently &4&lDISABLED&6!"));
                event.getPlayer().sendMessage(Utils.parseColors("&7Player join streaks will still be tracked, but &c&nno reward will be granted&r&7."));
            }
        }
    }
}

