/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs.Goals;

import java.util.ArrayList;
import java.util.List;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.GUIs.ConfirmationGui;
import me.thegabro.playtimemanager.GUIs.Goals.GoalSettingsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GoalRewardsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 54;
    private static final int ITEMS_PER_PAGE = 45;
    private Inventory inventory;
    private Goal goal;
    private GoalSettingsGui parentGui;
    private int currentPage;
    private final ChatEventManager chatEventManager = ChatEventManager.getInstance();

    public GoalRewardsGui() {
    }

    public GoalRewardsGui(Goal goal, GoalSettingsGui parentGui) {
        this.goal = goal;
        this.parentGui = parentGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Utils.parseColors("&6Rewards Editor"));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    private void initializeItems() {
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        this.updateRewardsPage();
        this.addControlButtons();
    }

    private ItemStack createBackgroundItem() {
        return this.parentGui.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Utils.parseColors("&f"), new Component[0]);
    }

    private void updateRewardsPage() {
        ArrayList<String> permissions = this.goal.getRewardPermissions();
        ArrayList<String> commands = this.goal.getRewardCommands();
        ArrayList<String> combined = new ArrayList<String>();
        combined.addAll(permissions);
        combined.addAll(commands);
        for (int i = 0; i < 45; ++i) {
            boolean isPermission;
            int index = this.currentPage * 45 + i;
            if (index >= combined.size()) {
                this.inventory.setItem(i, this.createBackgroundItem());
                continue;
            }
            String item = (String)combined.get(index);
            boolean bl = isPermission = index < permissions.size();
            Material icon = isPermission ? (item.startsWith("group.") ? Material.BOOK : Material.NAME_TAG) : Material.COMMAND_BLOCK;
            ArrayList<Component> lore = new ArrayList<Component>(List.of(Utils.parseColors("&7Click to edit"), Utils.parseColors("&cShift-Right Click to remove")));
            if (isPermission && item.startsWith("group.")) {
                boolean groupExists;
                String groupName = item.substring(6);
                boolean bl2 = groupExists = PlayTimeManager.getInstance().isPermissionsManagerConfigured() && PlayTimeManager.getInstance().getLuckPermsApi() != null && LuckPermsManager.getInstance(PlayTimeManager.getInstance()).groupExists(groupName);
                if (!groupExists) {
                    lore.addAll(List.of(Utils.parseColors(""), Utils.parseColors("&c\u26a0 Group '" + groupName + "' does not exist!"), Utils.parseColors("&cPlease create this group in LuckPerms"), Utils.parseColors("&cor remove this permission.")));
                }
            }
            this.inventory.setItem(i, this.parentGui.createGuiItem(icon, Utils.parseColors((isPermission ? "&e" : "&b") + item), (Component[])lore.toArray(Component[]::new)));
        }
    }

    private void addControlButtons() {
        int totalItems;
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.parentGui.createGuiItem(Material.ARROW, Utils.parseColors("&ePrevious Page"), new Component[0]));
        }
        if ((this.currentPage + 1) * 45 < (totalItems = this.goal.getRewardPermissions().size() + this.goal.getRewardCommands().size())) {
            this.inventory.setItem(53, this.parentGui.createGuiItem(Material.ARROW, Utils.parseColors("&eNext Page"), new Component[0]));
        }
        this.inventory.setItem(47, this.parentGui.createGuiItem(Material.NAME_TAG, Utils.parseColors("&e&lAdd Permission"), Utils.parseColors("&7Click to add a new permission")));
        this.inventory.setItem(48, this.parentGui.createGuiItem(Material.COMMAND_BLOCK, Utils.parseColors("&b&lAdd Command"), Utils.parseColors("&7Click to add a new command")));
        this.inventory.setItem(50, this.parentGui.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Utils.parseColors("&6&lBack"), new Component[0]));
        this.inventory.setItem(51, this.parentGui.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete All"), Utils.parseColors("&7Removes all permissions and commands")));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (inventoryHolder instanceof GoalRewardsGui) {
            GoalRewardsGui gui = (GoalRewardsGui)inventoryHolder;
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction(), e);
            } else if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                e.setCancelled(true);
            }
        }
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, InventoryAction action, InventoryClickEvent event) {
        if (clickedItem == null || clickedItem.getType() == Material.AIR || clickedItem.getType() == Material.BLACK_STAINED_GLASS_PANE) {
            return;
        }
        event.setCancelled(true);
        switch (slot) {
            case 45: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.updateRewardsPage();
                break;
            }
            case 53: {
                int totalItems = this.goal.getRewardPermissions().size() + this.goal.getRewardCommands().size();
                if ((this.currentPage + 1) * 45 >= totalItems) break;
                ++this.currentPage;
                this.updateRewardsPage();
                break;
            }
            case 47: {
                whoClicked.closeInventory();
                this.openAddPermissionDialog(whoClicked);
                break;
            }
            case 48: {
                whoClicked.closeInventory();
                this.openAddCommandDialog(whoClicked);
                break;
            }
            case 50: {
                whoClicked.closeInventory();
                this.parentGui.openInventory(whoClicked);
                break;
            }
            case 51: {
                this.handleDeleteAll(whoClicked);
                break;
            }
            default: {
                boolean isPermission;
                if (slot >= 45 || clickedItem.getItemMeta() == null) break;
                String display = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName());
                int index = this.currentPage * 45 + slot;
                boolean bl = isPermission = index < this.goal.getRewardPermissions().size();
                if (event.isShiftClick() && event.isRightClick()) {
                    if (isPermission) {
                        this.goal.removePermission(display);
                    } else {
                        this.goal.removeCommand(display);
                    }
                    this.updateRewardsPage();
                    break;
                }
                if (event.getClick().isCreativeAction()) break;
                whoClicked.closeInventory();
                if (isPermission) {
                    this.openEditPermissionDialog(whoClicked, display);
                    break;
                }
                this.openEditCommandDialog(whoClicked, display);
            }
        }
    }

    private void openAddPermissionDialog(Player player) {
        Component header = Utils.parseColors("&e&l\u2795 Add Permission");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a new permission node:\n&7\u2022 Standard permission or 'group.groupname'\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    this.goal.addPermission((String)message);
                    player.sendMessage(Utils.parseColors("&aPermission added: &f" + message));
                }
            } else {
                player.sendMessage(Utils.parseColors("&cPermission addition cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openEditPermissionDialog(Player player, String oldPermission) {
        Component header = Utils.parseColors("&6&l\u270e Edit Permission");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fCurrent Permission: &7" + oldPermission + "\n&7Enter a new permission node:\n&7\u2022 Type the new permission\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startChatInput(player, (p, message) -> {
            if (!message.equalsIgnoreCase("cancel")) {
                if (!message.isEmpty()) {
                    this.goal.removePermission(oldPermission);
                    this.goal.addPermission((String)message);
                }
                player.sendMessage(Utils.parseColors("&aPermission updated from &f" + oldPermission + " &ato &f" + message));
            } else {
                player.sendMessage(Utils.parseColors("&cPermission edit cancelled"));
            }
            this.openInventory(player);
        });
    }

    private void openAddCommandDialog(Player player) {
        Component header = Utils.parseColors("&b&l\u2795 Add Command");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fEnter a new command for this goal:\n&7\u2022 Commands must be valid and use '/' as a prefix\n&7\u2022 Available placeholders: PLAYER_NAME\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startCommandInput(player, (p, input) -> {
            if (input.equalsIgnoreCase("cancel")) {
                p.sendMessage(Utils.parseColors("&7Command addition cancelled"));
                this.openInventory((Player)p);
                return;
            }
            this.goal.addCommand((String)input);
            p.sendMessage(Utils.parseColors("&7Command &b" + input + " &7added. It will be executed when a player reaches the goal &e" + this.goal.getName()));
            this.openInventory((Player)p);
        });
    }

    private void openEditCommandDialog(Player player, String oldCommand) {
        Component header = Utils.parseColors("&6&l\u270e Edit Command");
        Component divider = Utils.parseColors("&8\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac\u25ac");
        Component instructions = Utils.parseColors("&fCurrent Command: &7" + oldCommand + "\n&7Enter a new command:\n&7\u2022 Commands must be valid and use '/' as a prefix\n&7\u2022 Available placeholders: PLAYER_NAME\n&7\u2022 Type &c&ocancel&r&7 to exit\n&7If chat input &cdoesn't work&7 please take a look at the wiki\n&7For more info regarding the issue and workarounds.");
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(header)).append((Component)Component.newline())).append(divider)).append((Component)Component.newline())).append((Component)Component.newline())).append(instructions)).append((Component)Component.newline())).append(divider);
        player.closeInventory();
        player.sendMessage(fullMessage);
        this.chatEventManager.startCommandInput(player, (p, input) -> {
            if (input.equalsIgnoreCase("cancel")) {
                p.sendMessage(Utils.parseColors("&cCommand edit cancelled"));
                this.openInventory((Player)p);
                return;
            }
            this.goal.removeCommand(oldCommand);
            this.goal.addCommand((String)input);
            p.sendMessage(Utils.parseColors("&aCommand edited successfully!"));
            this.openInventory((Player)p);
        });
        Component preText = Component.text((String)"You can ").color(TextColor.color((int)170, (int)170, (int)170));
        Component clickableText = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[click here]").color(TextColor.color((int)255, (int)170, (int)0))).decoration(TextDecoration.BOLD, true)).clickEvent(ClickEvent.suggestCommand((String)oldCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to autocomplete command")));
        Component clickableMessage = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"\n"))).append(preText)).append(clickableText)).append(Component.text((String)" to autocomplete the old command").color(TextColor.color((int)170, (int)170, (int)170)));
        player.sendMessage(clickableMessage);
    }

    private void handleDeleteAll(Player whoClicked) {
        ItemStack warning = this.parentGui.createGuiItem(Material.BARRIER, Utils.parseColors("&c&lDelete All Rewards"), Utils.parseColors("&7This will remove all permissions and commands from this goal"));
        new ConfirmationGui(warning, confirmed -> {
            if (confirmed.booleanValue()) {
                for (String perm : new ArrayList<String>(this.goal.getRewardPermissions())) {
                    this.goal.removePermission(perm);
                }
                for (String cmd : new ArrayList<String>(this.goal.getRewardCommands())) {
                    this.goal.removeCommand(cmd);
                }
            }
            this.initializeItems();
            whoClicked.updateInventory();
        }).openInventory(whoClicked);
    }

    private static final class Slots {
        static final int PREV_PAGE = 45;
        static final int NEXT_PAGE = 53;
        static final int ADD_PERMISSION = 47;
        static final int ADD_COMMAND = 48;
        static final int BACK = 50;
        static final int DELETE_ALL = 51;

        private Slots() {
        }
    }
}

