/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport.PlaceHolders;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormat;
import me.thegabro.playtimemanager.Customizations.PlaytimeFormats.PlaytimeFormatsConfiguration;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPerms.LuckPermsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlayTimePlaceHolders
extends PlaceholderExpansion {
    private static final String[] TIME_UNITS = new String[]{"s", "m", "h", "d", "y"};
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private final PlaytimeFormatsConfiguration playtimeFormatsConfiguration = PlaytimeFormatsConfiguration.getInstance();
    private LuckPermsManager luckPermsManager = null;
    private DateTimeFormatter formatter;
    private PlaytimeFormat playtimeFormat;

    private String processParams(String params) {
        int lastUnderscoreIndex = params.lastIndexOf("_");
        if (lastUnderscoreIndex == -1) {
            int colonIndex = params.indexOf(":");
            if (colonIndex != -1) {
                String formatName = params.substring(colonIndex + 1);
                this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat(formatName);
                if (this.playtimeFormat == null) {
                    this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat("default");
                }
                return params.substring(0, colonIndex);
            }
            this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat("default");
            return params;
        }
        int colonIndex = params.indexOf(":", lastUnderscoreIndex);
        if (colonIndex == -1) {
            this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat("default");
            return params;
        }
        String formatName = params.substring(colonIndex + 1);
        this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat(formatName);
        if (this.playtimeFormat == null) {
            this.playtimeFormat = this.playtimeFormatsConfiguration.getFormat("default");
        }
        return params.substring(0, colonIndex);
    }

    public PlayTimePlaceHolders() {
        if (this.plugin.isPermissionsManagerConfigured()) {
            try {
                this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    @NotNull
    public String getIdentifier() {
        return "PTM";
    }

    @NotNull
    public String getAuthor() {
        return "TheGabro";
    }

    @NotNull
    public String getVersion() {
        return "3.3.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        String prefix;
        if (params == null) {
            return null;
        }
        if ((params = this.processParams(params)).equalsIgnoreCase("rank")) {
            try {
                int position = this.dbUsersManager.getTopPlayers().indexOf(this.onlineUsersManager.getOnlineUser(player.getName())) + 1;
                return position != -1 ? String.valueOf(position) : this.plugin.getConfiguration().getString("placeholders.not-in-leaderboard-message");
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if (params.equalsIgnoreCase("firstjoin")) {
            try {
                OnlineUser user = this.onlineUsersManager.getOnlineUser(player.getName());
                if (user == null) {
                    return this.getErrorMessage("user not found");
                }
                LocalDateTime firstJoin = user.getFirstJoin();
                if (firstJoin == null) {
                    return this.getErrorMessage("first join data missing");
                }
                this.formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
                return firstJoin.format(this.formatter);
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get first join date");
            }
        }
        if (params.equalsIgnoreCase("joinstreak")) {
            try {
                return String.valueOf(this.onlineUsersManager.getOnlineUser(player.getName()).getAbsoluteJoinStreak());
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get join streak");
            }
        }
        if (params.equalsIgnoreCase("playtime")) {
            try {
                return Utils.ticksToFormattedPlaytime(this.onlineUsersManager.getOnlineUser(player.getName()).getPlaytime(), this.playtimeFormat);
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get playtime");
            }
        }
        for (String unit : TIME_UNITS) {
            if (!params.equalsIgnoreCase("playtime_" + unit)) continue;
            try {
                return String.valueOf(Utils.ticksToTimeUnit(this.onlineUsersManager.getOnlineUser(player.getName()).getPlaytime(), unit));
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get playtime");
            }
        }
        String paramLower = params.toLowerCase();
        if (paramLower.startsWith("rank_")) {
            return this.handleRank(params.substring(5));
        }
        if (paramLower.startsWith("firstjoin_")) {
            return this.handleFirstJoin(params.substring(10));
        }
        if (paramLower.startsWith("joinstreak_")) {
            return this.handleJoinStreak(params.substring(11));
        }
        if (paramLower.startsWith("lp_prefix_top_")) {
            return this.handleLPPrefixTop(params.substring(14));
        }
        for (String unit : TIME_UNITS) {
            prefix = "lastseen_elapsed_top_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handleLastSeenElapsedTop(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("lastseen_elapsed_top_")) {
            return this.handleLastSeenElapsedTop(params.substring(21));
        }
        for (String unit : TIME_UNITS) {
            prefix = "lastseen_elapsed_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handleLastSeenElapsed(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("lastseen_elapsed_")) {
            return this.handleLastSeenElapsed(params.substring(17));
        }
        if (paramLower.startsWith("nickname_top_")) {
            return this.handleNicknameTop(params.substring(13));
        }
        for (String unit : TIME_UNITS) {
            prefix = "playtime_top_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handlePlayTimeTop(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("playtime_top_")) {
            return this.handlePlayTimeTop(params.substring(13));
        }
        for (String unit : TIME_UNITS) {
            prefix = "playtime_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handlePlayTime(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("playtime_")) {
            return this.handlePlayTime(params.substring(9));
        }
        if (paramLower.startsWith("lastseen_top_")) {
            return this.handleLastSeenTop(params.substring(13));
        }
        if (paramLower.startsWith("lastseen_")) {
            return this.handleLastSeen(params.substring(9));
        }
        return null;
    }

    private String handleLPPrefixTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (!this.plugin.isPermissionsManagerConfigured()) {
            return this.getErrorMessage("luckperms not loaded");
        }
        try {
            return this.luckPermsManager.getPrefixAsync(user.getUuid()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return this.getErrorMessage("luckperms retrieve unsuccessful");
        }
    }

    private String handleLastSeenElapsedTop(String posStr, String unit) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return String.valueOf(Utils.ticksToTimeUnit(duration.getSeconds() * 20L, unit));
    }

    private String handleLastSeenElapsedTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return Utils.ticksToFormattedPlaytime(duration.getSeconds() * 20L);
    }

    private String handleLastSeenElapsed(String nickname, String unit) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return String.valueOf(Utils.ticksToTimeUnit(duration.getSeconds() * 20L, unit));
    }

    private String handleLastSeenElapsed(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return Utils.ticksToFormattedPlaytime(duration.getSeconds() * 20L);
    }

    private String handleNicknameTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? user.getNickname() : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTimeTop(String posStr, String unit) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? String.valueOf(Utils.ticksToTimeUnit(user.getPlaytime(), unit)) : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTimeTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? Utils.ticksToFormattedPlaytime(user.getPlaytime(), this.playtimeFormat) : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTime(String nickname, String unit) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        return user != null ? String.valueOf(Utils.ticksToTimeUnit(user.getPlaytime(), unit)) : this.getErrorMessage("wrong nickname?");
    }

    private String handlePlayTime(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        return user != null ? Utils.ticksToFormattedPlaytime(user.getPlaytime(), this.playtimeFormat) : this.getErrorMessage("wrong nickname?");
    }

    private String handleLastSeenTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        return user.getLastSeen().format(formatter);
    }

    private String handleLastSeen(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
        return user.getLastSeen().format(formatter);
    }

    private String handleJoinStreak(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        return user != null ? String.valueOf(user.getAbsoluteJoinStreak()) : this.getErrorMessage("wrong nickname?");
    }

    private String handleFirstJoin(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        LocalDateTime firstJoin = user.getFirstJoin();
        if (firstJoin == null) {
            return this.getErrorMessage("first join data missing");
        }
        try {
            this.formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getString("datetime-format"));
            return firstJoin.format(this.formatter);
        }
        catch (Exception e) {
            return this.getErrorMessage("date formatting error");
        }
    }

    private String handleRank(String nickname) {
        try {
            int position = this.dbUsersManager.getTopPlayers().indexOf(this.onlineUsersManager.getOnlineUser(nickname));
            return position != -1 ? String.valueOf(position + 1) : this.plugin.getConfiguration().getString("placeholders.not-in-leaderboard-message");
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private String getErrorMessage(String error) {
        return this.plugin.getConfiguration().getBoolean("placeholders.enable-errors") != false ? "Error: " + error : this.plugin.getConfiguration().getString("placeholders.default-message");
    }

    private boolean isStringInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

