/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Customizations;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommandsConfiguration {
    private static CommandsConfiguration instance;
    private PlayTimeManager plugin;
    private FileConfiguration config;
    private File file;
    private final Map<String, Object> configCache = new ConcurrentHashMap<String, Object>();
    private static final String CONFIG_FILENAME = "commands-config.yml";
    private static final String CONFIG_PATH = "Customizations/Commands/";

    private CommandsConfiguration() {
    }

    public static synchronized CommandsConfiguration getInstance() {
        if (instance == null) {
            instance = new CommandsConfiguration();
        }
        return instance;
    }

    public void initialize(PlayTimeManager plugin) {
        if (this.plugin == null) {
            this.plugin = plugin;
            this.create();
            this.reload();
        }
    }

    private void create() {
        if (this.file == null) {
            this.reloadFile();
        }
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource("Customizations/Commands/commands-config.yml", false);
        }
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exc) {
            this.plugin.getLogger().severe(String.valueOf(exc));
        }
    }

    private void reloadFile() {
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin not initialized. Call initialize() first.");
        }
        this.file = new File(this.plugin.getDataFolder(), "Customizations/Commands/commands-config.yml");
    }

    private void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void loadCache() {
        if (this.config == null) {
            this.plugin.getLogger().warning("Config is null, cannot load cache");
            return;
        }
        this.configCache.clear();
        for (String key : this.config.getKeys(true)) {
            Object value = this.config.get(key);
            this.configCache.put(key, value);
        }
    }

    public void reload() {
        this.reloadFile();
        this.reloadConfig();
        this.loadCache();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public Object get(String path) {
        if (this.configCache.containsKey(path)) {
            return this.configCache.get(path);
        }
        Object value = this.config.get(path);
        if (value != null) {
            this.configCache.put(path, value);
        }
        return value;
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
        this.configCache.put(path, value);
        this.save();
    }

    public Map<String, Object> createConfigBackup() {
        HashMap<String, Object> backup = new HashMap<String, Object>();
        if (!this.configCache.isEmpty()) {
            backup.putAll(this.configCache);
        } else {
            Set keys = this.config.getKeys(true);
            for (String key : keys) {
                Object value = this.config.get(key);
                if (value == null) continue;
                backup.put(key, value);
            }
        }
        return backup;
    }

    public void restoreFromBackup(Map<String, Object> backup) {
        if (backup == null || backup.isEmpty()) {
            this.plugin.getLogger().warning("Backup is null or empty, nothing to restore");
            return;
        }
        for (Map.Entry<String, Object> entry : backup.entrySet()) {
            String key = entry.getKey();
            Object backupValue = entry.getValue();
            if (!this.config.contains(key) || backupValue instanceof MemorySection) continue;
            Object currentValue = this.config.get(key);
            if (backupValue == null || backupValue.equals(currentValue) || backupValue instanceof String && ((String)backupValue).trim().isEmpty()) continue;
            this.config.set(key, backupValue);
            this.configCache.put(key, backupValue);
        }
    }

    public void updateConfig() {
        try {
            Map<Object, Object> backup = new HashMap();
            if (this.config != null) {
                backup = this.createConfigBackup();
            }
            if (this.file != null && this.file.exists()) {
                this.file.delete();
            }
            this.plugin.saveResource("Customizations/Commands/commands-config.yml", true);
            this.configCache.clear();
            this.reloadFile();
            this.reloadConfig();
            if (!backup.isEmpty()) {
                this.restoreFromBackup(backup);
            }
            this.save();
            this.loadCache();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getString(String path) {
        Object value = this.get(path);
        return value != null ? value.toString() : null;
    }

    public Integer getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    public Boolean getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return null;
    }

    public Double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }

    public void clearCache() {
        this.configCache.clear();
    }
}

