/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutionException;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlaytimePercentage
implements CommandExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("playtime.percentage")) {
            if (args.length > 0) {
                long timeToTicks = Utils.formattedPlaytimeToTicks(args[0]);
                if (timeToTicks == -1L) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Time is not specified correctly!"));
                    return false;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        this.onlineUsersManager.updateAllOnlineUsersPlaytime().get();
                        DecimalFormat df = new DecimalFormat("#.##");
                        df.setRoundingMode(RoundingMode.HALF_UP);
                        Object[] result = this.plugin.getDatabase().getPercentageOfPlayers(timeToTicks);
                        String formattedNumber = df.format(result[0]);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " The players with playtime greater than or equal to &6" + args[0] + " &7are &6" + String.valueOf(result[1]) + " &7and represent &6" + formattedNumber + "% &7of the &6" + String.valueOf(result[2]) + " &7players stored")));
                    }
                    catch (InterruptedException | ExecutionException e) {
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Error while processing command: " + e.getMessage())));
                        this.plugin.getLogger().severe("Error in PlaytimePercentage command: " + e.getMessage());
                    }
                });
                return true;
            }
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Missing arguments"));
        } else {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have the permission to execute this command"));
        }
        return false;
    }
}

