/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands.PlayTimeCommandManager;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeAddTime;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeRemoveTime;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeReset;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeStats;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlaytimeCommand;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PlayTimeCommandManager
implements CommandExecutor,
TabCompleter {
    private final List<String> subCommands = new ArrayList<String>();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final List<String> resetOptions = new ArrayList<String>();

    public PlayTimeCommandManager() {
        this.subCommands.add("add");
        this.subCommands.add("remove");
        this.subCommands.add("reset");
        this.subCommands.add("stats");
        this.resetOptions.add("playtime");
        this.resetOptions.add("server_playtime");
        this.resetOptions.add("last_seen");
        this.resetOptions.add("first_join");
        this.resetOptions.add("joinstreak");
        this.resetOptions.add("joinstreak_rewards");
        this.resetOptions.add("goals");
        this.resetOptions.add("everything");
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("playtime")) {
            return false;
        }
        if (!(sender instanceof Player) || sender.hasPermission("playtime")) {
            if (args.length == 1) {
                if (!sender.hasPermission("playtime.others")) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
                    return false;
                }
                if (this.dbUsersManager.getUserFromNickname(args[0]) == null) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " The player &e" + args[0] + "&7 has never joined the server!"));
                    return false;
                }
                new PlaytimeCommand(sender, args);
                return true;
            }
            if (args.length == 0) {
                new PlaytimeCommand(sender, args);
                return true;
            }
            if (args.length > 1) {
                boolean isWildcardReset;
                String targetPlayerName = args[0];
                String subCommand = args[1];
                if (!this.subCommands.contains(subCommand)) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Unknown subcommand: " + subCommand));
                    return false;
                }
                boolean bl = isWildcardReset = subCommand.equals("reset") && targetPlayerName.equals("*");
                if (isWildcardReset && !sender.hasPermission("playtime.others.modify.all")) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to use wildcards with the reset command"));
                    return false;
                }
                if (!isWildcardReset && this.dbUsersManager.getUserFromNickname(targetPlayerName) == null) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " The player &e" + targetPlayerName + "&7 has never joined the server!"));
                    return false;
                }
                switch (subCommand) {
                    case "stats": {
                        if (!sender.hasPermission("playtime.others.stats")) {
                            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
                            return false;
                        }
                        new PlayTimeStats(sender, args);
                        return true;
                    }
                    case "add": {
                        if (!sender.hasPermission("playtime.others.modify")) {
                            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
                            return false;
                        }
                        new PlayTimeAddTime(sender, args);
                        return true;
                    }
                    case "remove": {
                        if (!sender.hasPermission("playtime.others.modify")) {
                            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
                            return false;
                        }
                        new PlayTimeRemoveTime(sender, args);
                        return true;
                    }
                    case "reset": {
                        if (!sender.hasPermission("playtime.others.modify")) {
                            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
                            return false;
                        }
                        new PlayTimeReset(sender, args);
                        return true;
                    }
                }
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " Unknown subcommand: " + subCommand));
                return false;
            }
        } else {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have permission to execute this command"));
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        ArrayList<String> availableCommands = new ArrayList<String>();
        if (args.length == 1) {
            if (!sender.hasPermission("playtime.others")) return new ArrayList<String>();
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            if (sender.hasPermission("playtime.others.modify.all")) {
                playerNames.add("*");
            }
            StringUtil.copyPartialMatches((String)args[0], playerNames, completions);
            return completions;
        } else if (args.length == 2) {
            if (sender.hasPermission("playtime.others.stats")) {
                availableCommands.add("stats");
            }
            if (sender.hasPermission("playtime.others.modify")) {
                availableCommands.add("add");
                availableCommands.add("remove");
                availableCommands.add("reset");
            }
            StringUtil.copyPartialMatches((String)args[1], availableCommands, completions);
            return completions;
        } else {
            if (args.length != 3 || !args[1].equalsIgnoreCase("reset") || !sender.hasPermission("playtime.others.modify")) return completions;
            StringUtil.copyPartialMatches((String)args[2], this.resetOptions, completions);
        }
        return completions;
    }
}

