/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.thegabro.playtimemanager.GUIs.JoinStreak.RewardsInfoGui;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClaimRewards
implements CommandExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private static final Map<UUID, Long> lastGuiOpenTime = new HashMap<UUID, Long>();
    private static final long GUI_OPEN_COOLDOWN = 1000L;

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        long lastTime;
        if (!sender.hasPermission("playtime.joinstreak.claim")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " You don't have the permission to execute this command"));
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (lastGuiOpenTime.containsKey(playerId) && currentTime - (lastTime = lastGuiOpenTime.get(playerId).longValue()) < 1000L) {
            player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getString("prefix") + " &cPlease wait before using this command again."));
            return true;
        }
        lastGuiOpenTime.put(playerId, currentTime);
        String sessionToken = UUID.randomUUID().toString();
        this.plugin.getSessionManager().createSession(player.getUniqueId(), sessionToken);
        RewardsInfoGui rewardsGui = new RewardsInfoGui(player, this.dbUsersManager.getUserFromNickname(player.getName()), sessionToken);
        rewardsGui.openInventory();
        return true;
    }
}

