/*
 * Decompiled with CFR 0.152.
 */
package org.fliff.skworldguard.skript;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

public class EffSetFlag
extends Effect {
    private Expression<String> flagName;
    private Expression<String> regionId;
    private Expression<String> flagValue;

    protected void execute(Event event) {
        String flagNameStr = (String)this.flagName.getSingle(event);
        String regionIdStr = (String)this.regionId.getSingle(event);
        String flagValueStr = (String)this.flagValue.getSingle(event);
        if (flagNameStr != null && regionIdStr != null && flagValueStr != null) {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager regionManager = container.get(BukkitAdapter.adapt((World)((World)Bukkit.getWorlds().get(0))));
            if (regionManager != null) {
                ProtectedRegion region = regionManager.getRegion(regionIdStr);
                if (region != null) {
                    Flag flag = Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)flagNameStr);
                    if (flag != null) {
                        if (flag instanceof StateFlag) {
                            StateFlag stateFlag = (StateFlag)flag;
                            StateFlag.State state = StateFlag.State.valueOf((String)flagValueStr.toUpperCase());
                            region.setFlag((Flag)stateFlag, (Object)state);
                            Bukkit.getLogger().info("Flag " + flagNameStr + " wurde in der Region " + regionIdStr + " auf " + flagValueStr + " gesetzt.");
                        } else {
                            Bukkit.getLogger().warning("Flag " + flagNameStr + " kann nicht als StateFlag interpretiert werden.");
                        }
                    } else {
                        Bukkit.getLogger().warning("Flag " + flagNameStr + " konnte nicht gefunden werden.");
                    }
                } else {
                    Bukkit.getLogger().warning("Region " + regionIdStr + " konnte nicht gefunden werden.");
                }
            } else {
                Bukkit.getLogger().warning("RegionManager konnte nicht abgerufen werden.");
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "set flag of region";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.flagName = expressions[0];
        this.regionId = expressions[1];
        this.flagValue = expressions[2];
        return true;
    }
}

