/*
 * Decompiled with CFR 0.152.
 */
package org.fliff.skworldguard.skript;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.managers.storage.StorageException;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class EffAddOwner
extends Effect {
    private Expression<String> regionId;
    private Expression<String> owner;

    protected void execute(Event event) {
        String id = (String)this.regionId.getSingle(event);
        String ownerName = (String)this.owner.getSingle(event);
        if (id != null && ownerName != null) {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager regionManager = container.get(BukkitAdapter.adapt((World)((World)Bukkit.getWorlds().get(0))));
            if (regionManager != null) {
                ProtectedRegion region = regionManager.getRegion(id);
                if (region != null) {
                    Player bukkitPlayer = Bukkit.getPlayer((String)ownerName);
                    if (bukkitPlayer != null) {
                        UUID playerUUID = bukkitPlayer.getUniqueId();
                        DefaultDomain owners = region.getOwners();
                        owners.addPlayer(playerUUID);
                        try {
                            regionManager.saveChanges();
                        }
                        catch (StorageException e) {
                            throw new RuntimeException(e);
                        }
                        Bukkit.getLogger().info("Spieler " + ownerName + " (UUID: " + String.valueOf(playerUUID) + ") wurde als Owner zur Region " + id + " hinzugef\u00fcgt.");
                    } else {
                        Bukkit.getLogger().warning("Spieler " + ownerName + " konnte nicht gefunden werden.");
                    }
                } else {
                    Bukkit.getLogger().warning("Region " + id + " konnte nicht gefunden werden.");
                }
            } else {
                Bukkit.getLogger().warning("RegionManager konnte nicht abgerufen werden.");
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "add owner to region";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.regionId = expressions[1];
        this.owner = expressions[0];
        return true;
    }
}

