/*
 * Decompiled with CFR 0.152.
 */
package org.fliff.skworldguard.manager;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class CustomRegionManager {
    private final WorldGuardPlugin worldGuard = WorldGuardPlugin.inst();

    public void createRegion(Player player, String regionId, Location loc1, Location loc2) {
        RegionManager regionManager = this.getRegionManager(player);
        if (regionManager == null) {
            player.sendMessage("Could not get region manager.");
            return;
        }
        BlockVector3 min = BlockVector3.at((double)loc1.getX(), (double)loc1.getY(), (double)loc1.getZ());
        BlockVector3 max = BlockVector3.at((double)loc2.getX(), (double)loc2.getY(), (double)loc2.getZ());
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(regionId, min, max);
        regionManager.addRegion((ProtectedRegion)region);
        player.sendMessage("Region " + regionId + " created.");
    }

    public void addMember(Player player, String regionId, String memberName) {
        RegionManager regionManager = this.getRegionManager(player);
        if (regionManager == null) {
            player.sendMessage("Could not get region manager.");
            return;
        }
        ProtectedRegion region = regionManager.getRegion(regionId);
        if (region == null) {
            player.sendMessage("Region not found.");
            return;
        }
        region.getMembers().addPlayer(memberName);
        player.sendMessage("Added " + memberName + " to region " + regionId + ".");
    }

    public void removeMember(Player player, String regionId, String memberName) {
        RegionManager regionManager = this.getRegionManager(player);
        if (regionManager == null) {
            player.sendMessage("Could not get region manager.");
            return;
        }
        ProtectedRegion region = regionManager.getRegion(regionId);
        if (region == null) {
            player.sendMessage("Region not found.");
            return;
        }
        region.getMembers().removePlayer(memberName);
        player.sendMessage("Removed " + memberName + " from region " + regionId + ".");
    }

    private RegionManager getRegionManager(Player player) {
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        return container.get(BukkitAdapter.adapt((World)player.getWorld()));
    }
}

