/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities.nbt;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class NBTReader {
    public static void getLocation(String name, NBTCallback<Location> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
            try {
                Location location = NBTReader.getLocation(player);
                if (location == null) {
                    callback.onFail(CustomMessages.getComponent("Error.noOfflineLocation", new TagResolver[]{Placeholder.unparsed((String)"player", (String)name)}));
                    return;
                }
                callback.onSuccess(location);
            }
            catch (IOException e) {
                callback.onFail(CustomMessages.getComponent("Error.failedOfflineTeleport", new TagResolver[]{Placeholder.unparsed((String)"player", (String)name)}));
                e.printStackTrace();
            }
        });
    }

    private static Location getLocation(OfflinePlayer player) throws IOException {
        UUID uuid = player.getUniqueId();
        File dataFile = NBTReader.getPlayerFile(uuid);
        if (dataFile == null) {
            return null;
        }
        CompoundBinaryTag tag = BinaryTagIO.unlimitedReader().read(dataFile.toPath(), BinaryTagIO.Compression.GZIP);
        ListBinaryTag posTag = tag.getList("Pos");
        ListBinaryTag rotTag = tag.getList("Rotation");
        long worldUUIDMost = tag.getLong("WorldUUIDMost");
        long worldUUIDLeast = tag.getLong("WorldUUIDLeast");
        World world = Bukkit.getWorld((UUID)new UUID(worldUUIDMost, worldUUIDLeast));
        return new Location(world, posTag.getDouble(0), posTag.getDouble(1), posTag.getDouble(2), rotTag.getFloat(0), rotTag.getFloat(1));
    }

    private static File getPlayerFile(UUID uuid) {
        for (World world : Bukkit.getWorlds()) {
            File[] children;
            File worldFolder = world.getWorldFolder();
            if (!worldFolder.isDirectory() || (children = worldFolder.listFiles()) == null) continue;
            for (File file : children) {
                if (!file.isDirectory() || !file.getName().equals("playerdata")) continue;
                return NBTReader.getPlayerFile(file, uuid);
            }
        }
        return null;
    }

    private static File getPlayerFile(File playerDataFolder, UUID uuid) {
        File[] files = playerDataFolder.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (!file.getName().equals(uuid.toString() + ".dat")) continue;
            return file;
        }
        return null;
    }

    public static void setLocation(String name, Location newLoc, NBTCallback<Boolean> callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
            try {
                NBTReader.setLocation(player, newLoc);
                callback.onSuccess(true);
            }
            catch (IOException e) {
                e.printStackTrace();
                callback.onFail(CustomMessages.getComponent("Error.failedOfflineTeleportHere", new TagResolver[]{Placeholder.unparsed((String)"player", (String)name)}));
            }
        });
    }

    private static void setLocation(OfflinePlayer player, Location location) throws IOException {
        UUID uuid = player.getUniqueId();
        File dataFile = NBTReader.getPlayerFile(uuid);
        if (dataFile == null) {
            return;
        }
        CompoundBinaryTag rawTag = BinaryTagIO.unlimitedReader().read(dataFile.toPath(), BinaryTagIO.Compression.GZIP);
        CompoundBinaryTag.Builder builder = (CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put(rawTag);
        ListBinaryTag.Builder posTag = ListBinaryTag.builder();
        posTag.add((BinaryTag)DoubleBinaryTag.of((double)location.getX()));
        posTag.add((BinaryTag)DoubleBinaryTag.of((double)location.getY()));
        posTag.add((BinaryTag)DoubleBinaryTag.of((double)location.getZ()));
        ListBinaryTag.Builder rotTag = ListBinaryTag.builder();
        rotTag.add((BinaryTag)FloatBinaryTag.of((float)location.getYaw()));
        rotTag.add((BinaryTag)FloatBinaryTag.of((float)location.getPitch()));
        builder.put("Pos", (BinaryTag)posTag.build());
        builder.put("Rotation", (BinaryTag)rotTag.build());
        builder.put("WorldUUIDMost", (BinaryTag)LongBinaryTag.of((long)location.getWorld().getUID().getMostSignificantBits()));
        builder.put("WorldUUIDLeast", (BinaryTag)LongBinaryTag.of((long)location.getWorld().getUID().getLeastSignificantBits()));
        BinaryTagIO.writer().write(builder.build(), dataFile.toPath(), BinaryTagIO.Compression.GZIP);
    }

    public static interface NBTCallback<D> {
        public void onSuccess(D var1);

        default public void onFail(@NotNull Component message) {
        }
    }
}

