/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities.minimessage;

import io.github.niestrat99.advancedteleport.utilities.minimessage.AdventureUtils;
import java.util.SortedSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialComponent {
    private String value;
    @Nullable
    private Component cache;

    PartialComponent(String raw) {
        this.value = raw;
        this.cache = null;
    }

    public static PartialComponent of(@NotNull String value) {
        return new PartialComponent(value);
    }

    public Component get(TagResolver ... placeholders) {
        if (placeholders.length == 0) {
            if (this.cache == null) {
                this.cache = AdventureUtils.cleanDeserialise(this.value, new TagResolver[0]);
            }
            return this.cache;
        }
        return AdventureUtils.cleanDeserialise(this.value, placeholders);
    }

    public void formatRaw(SortedSet<String> placeholders) {
        String tempValue = this.value;
        int i = 0;
        for (String placeholder : placeholders) {
            String prefix = this.prefix(i);
            tempValue = tempValue.replace(prefix, placeholder);
            this.cache = null;
            ++i;
        }
        this.value = tempValue;
    }

    private String prefix(int index) {
        return index == 0 ? "<prefix>" : String.format("<prefix:%s>", index);
    }
}

