/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities.minimessage;

import io.github.niestrat99.advancedteleport.utilities.Pair;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.PreProcess;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class AdventureUtils {
    @SafeVarargs
    public static Component lazyPlaceholder(@NotNull String input, Pair<String, Object> ... template) {
        TagResolver.Builder resolver = TagResolver.builder();
        for (Pair<String, Object> placeholder : template) {
            Tag tag;
            String placeholderName = placeholder.fst();
            Object value = placeholder.snd();
            if (value instanceof Component) {
                Component component = (Component)value;
                tag = Tag.selfClosingInserting((Component)component);
            } else if (value instanceof Supplier) {
                Supplier supplier = (Supplier)value;
                Object suppliedValue = supplier.get();
                if (suppliedValue instanceof Component) {
                    Component component = (Component)suppliedValue;
                    tag = Tag.selfClosingInserting((Component)component);
                } else {
                    tag = new LazyStringReplacement(supplier);
                }
            } else {
                tag = Tag.preProcessParsed((String)value.toString());
            }
            resolver.tag(placeholderName, tag);
        }
        return MiniMessage.miniMessage().deserialize(input, resolver.build());
    }

    public static Component cleanDeserialise(String input, TagResolver ... placeholders) {
        return MiniMessage.miniMessage().deserialize(input, placeholders).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("</[a-zA-Z-_]+>").replacement("").build());
    }

    private record LazyStringReplacement(Supplier<?> supplier) implements Tag,
    PreProcess
    {
        @NotNull
        public String value() {
            return this.supplier.get().toString();
        }
    }
}

