/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities;

import java.util.List;

public class PagedLists<T> {
    private final List<T> list;
    private final int pages;
    private final int contents;
    private final int contentsPerPage;
    private int currentPage;

    public PagedLists(List<T> list, int contentsPerPage) {
        if (contentsPerPage < 1) {
            throw new IllegalArgumentException("The provided int must be bigger than 0 for contents per page!");
        }
        this.list = list;
        int pages = 1;
        for (int bls = list.size(); bls > contentsPerPage; bls -= contentsPerPage) {
            ++pages;
        }
        this.pages = pages;
        this.contents = list.size();
        this.currentPage = 1;
        this.contentsPerPage = contentsPerPage;
    }

    public int getTotalContents() {
        return this.contents;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public List<T> getContentsInPage(int page) {
        if (page > this.getTotalPages()) {
            throw new IllegalArgumentException("The provided page is an int larger than the total number of pages!");
        }
        int sIndex = (page - 1) * this.getContentsPerPage();
        int eIndex = this.getContentsPerPage() + sIndex;
        if (eIndex > this.getList().size()) {
            eIndex = this.getList().size();
        }
        this.setPage(page);
        return this.getList().subList(sIndex, eIndex);
    }

    public int getTotalPages() {
        return this.pages;
    }

    public int getContentsPerPage() {
        return this.contentsPerPage;
    }

    private List<T> getList() {
        return this.list;
    }

    private void setPage(int page) {
        this.currentPage = page;
    }
}

