/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.niestrat99.advancedteleport.CoreClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class IconMenu
implements Listener,
InventoryHolder {
    private static final Pattern HEX_PATTERN = Pattern.compile("^[0-9a-fA-F]+$");
    private final String title;
    private final int size;
    private final int pageCount;
    private int currentPage;
    private OptionPage[] optionPages;
    private CoreClass core;
    private UUID player;
    private Inventory inventory;

    public IconMenu(String title, int size, int pageCount, CoreClass core) {
        this.title = title;
        this.size = size;
        this.core = core;
        this.player = null;
        this.inventory = null;
        this.optionPages = new OptionPage[pageCount];
        for (int i = 0; i < this.optionPages.length; ++i) {
            this.optionPages[i] = new OptionPage(size);
        }
        this.currentPage = 0;
        this.pageCount = pageCount;
        core.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)core);
    }

    private static ItemStack setItemNameAndLore(ItemStack item, String name, List<String> lore) {
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        ArrayList<String> colLore = new ArrayList<String>();
        for (String str : lore) {
            colLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)str));
        }
        im.setLore(colLore);
        item.setItemMeta(im);
        return item;
    }

    public IconMenu setIcon(int page, int position, Icon icon) {
        this.optionPages[page].optionIcons[position] = icon;
        return this;
    }

    public void open(Player player) {
        this.player = player.getUniqueId();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.size, (String)this.title);
        this.updateContents();
        player.openInventory(this.inventory);
    }

    private void updateContents() {
        for (int i = 0; i < this.size; ++i) {
            Icon icon = this.optionPages[this.currentPage].optionIcons[i];
            if (icon != null) {
                this.inventory.setItem(i, icon.item);
                continue;
            }
            this.inventory.clear(i);
        }
    }

    public void openNextPage() {
        if (this.currentPage + 1 >= this.pageCount) {
            return;
        }
        ++this.currentPage;
        this.updatePage();
    }

    public void updatePage() {
        this.updateContents();
        this.getPlayer().updateInventory();
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.player);
    }

    public void openPreviousPage() {
        if (this.currentPage - 1 < 0) {
            return;
        }
        --this.currentPage;
        this.updatePage();
    }

    public void openPage(int page) {
        if (page >= this.pageCount || page < 0) {
            return;
        }
        this.currentPage = page;
        this.updatePage();
    }

    public int getPageCount() {
        return this.pageCount;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClosed(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() == this) {
            this.destroy();
        }
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
        this.core = null;
        this.optionPages = null;
        this.player = null;
        this.inventory = null;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getHolder() != this) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        OptionPage currentPage = this.optionPages[this.currentPage];
        if (slot >= 0 && slot < this.size && currentPage.optionIcons[slot] != null) {
            CoreClass plugin = this.core;
            Icon icon = currentPage.optionIcons[slot];
            OptionClickEvent e = new OptionClickEvent((Player)event.getWhoClicked(), slot, icon);
            Player p = (Player)event.getWhoClicked();
            icon.activate(p, e);
            if (e.willClose()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> ((Player)p).closeInventory(), 1L);
            }
            if (e.willDestroy()) {
                this.destroy();
            }
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    private static class OptionPage {
        private final Icon[] optionIcons;

        public OptionPage(int size) {
            this.optionIcons = new Icon[size];
        }
    }

    public static class Icon {
        private final ItemStack item;
        private String[] commands;
        private OptionClickEventHandler handler;

        public Icon(ItemStack item) {
            this.item = item;
        }

        public Icon withCommands(String ... commands) {
            this.commands = commands;
            return this;
        }

        public Icon withNameAndLore(String name, List<String> lore) {
            IconMenu.setItemNameAndLore(this.item, name, lore);
            return this;
        }

        public Icon withTexture(String texture) {
            String typeName = this.item.getType().name();
            if ((typeName.equalsIgnoreCase("SKULL_ITEM") && this.item.getDurability() == 3 || typeName.equalsIgnoreCase("PLAYER_HEAD")) && texture != null && !texture.isEmpty()) {
                GameProfile profile = new GameProfile(UUID.nameUUIDFromBytes(texture.getBytes()), "AdvTPHead");
                byte[] data = texture.startsWith("http") ? Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", texture).getBytes()) : (HEX_PATTERN.matcher(texture).matches() ? Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"https://textures.minecraft.net/texture/%s\"}}}", texture).getBytes()) : texture.getBytes());
                profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(data)));
                SkullMeta skullMeta = (SkullMeta)this.item.getItemMeta();
                try {
                    Field profileField = skullMeta.getClass().getDeclaredField("profile");
                    profileField.setAccessible(true);
                    profileField.set(skullMeta, profile);
                }
                catch (NoSuchFieldException e) {
                    CoreClass.getInstance().getLogger().severe("Failed to access the profile field building an icon menu, apparently it doesn't exist?");
                }
                catch (IllegalAccessException ex) {
                    CoreClass.getInstance().getLogger().severe("Failed to access the profile field building an icon menu, apparently you don't have access to it. Holly, you idiot.");
                }
                this.item.setItemMeta((ItemMeta)skullMeta);
            }
            return this;
        }

        public Icon withHandler(OptionClickEventHandler handler) {
            this.handler = handler;
            return this;
        }

        public void activate(Player player, OptionClickEvent event) {
            if (this.commands != null) {
                for (String command : this.commands) {
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                }
            }
            if (this.handler != null) {
                this.handler.onOptionClick(event);
            }
        }

        public ItemStack getItem() {
            return this.item;
        }
    }

    public static class OptionClickEvent {
        private final Player player;
        private final int position;
        private final Icon icon;
        private boolean close;
        private boolean destroy;

        public OptionClickEvent(Player player, int position, Icon icon) {
            this.player = player;
            this.position = position;
            this.icon = icon;
            this.close = true;
            this.destroy = true;
        }

        public Player getPlayer() {
            return this.player;
        }

        public int getPosition() {
            return this.position;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public boolean willClose() {
            return this.close;
        }

        public boolean willDestroy() {
            return this.destroy;
        }

        public void setWillClose(boolean close) {
            this.close = close;
        }

        public void setWillDestroy(boolean destroy) {
            this.destroy = destroy;
        }
    }

    public static interface OptionClickEventHandler {
        public void onOptionClick(OptionClickEvent var1);
    }
}

