/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.utilities;

import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.TeleportRequest;
import io.github.niestrat99.advancedteleport.api.TeleportRequestType;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.managers.InvulnerabilityManager;
import io.github.niestrat99.advancedteleport.managers.MovementManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class AcceptRequest {
    public static void acceptRequest(TeleportRequest request) {
        Location toLoc;
        Player player = request.responder();
        CustomMessages.sendMessage((CommandSender)request.requester(), "Info.requestAcceptedResponder", new TagResolver[]{Placeholder.unparsed((String)"player", (String)player.getName())});
        CustomMessages.sendMessage((CommandSender)player, "Info.requestAccepted", new TagResolver[0]);
        Location location = toLoc = request.type() == TeleportRequestType.TPAHERE ? request.requester().getLocation() : request.responder().getLocation();
        if (PaymentManager.getInstance().canPay(request.type().name().toLowerCase().replaceAll("_", ""), request.requester(), toLoc.getWorld())) {
            if (request.type() == TeleportRequestType.TPAHERE) {
                AcceptRequest.teleport(request.requester(), player, "tpahere");
            } else {
                AcceptRequest.teleport(player, request.requester(), "tpa");
            }
        }
        request.destroy();
    }

    private static void teleport(Player toPlayer, Player fromPlayer, String type) {
        Player payingPlayer;
        Location toLocation = toPlayer.getLocation();
        ATTeleportEvent event = new ATTeleportEvent(fromPlayer, toLocation, fromPlayer.getLocation(), "", ATTeleportEvent.TeleportType.valueOf(type.toUpperCase()));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        ATPlayer atPlayer = ATPlayer.getPlayer(fromPlayer);
        int warmUp = atPlayer.getWarmUp(type, toLocation.getWorld());
        Player player = payingPlayer = type.equalsIgnoreCase("tpahere") ? toPlayer : fromPlayer;
        if (warmUp > 0 && !fromPlayer.hasPermission("at.admin.bypass.timer")) {
            MovementManager.createMovementTimer(fromPlayer, toLocation, type, "Teleport.eventTeleport", warmUp, payingPlayer, new TagResolver[0]);
            return;
        }
        ATPlayer.teleportWithOptions(fromPlayer, toLocation, PlayerTeleportEvent.TeleportCause.COMMAND);
        CustomMessages.sendMessage((CommandSender)fromPlayer, "Teleport.eventTeleport", new TagResolver[0]);
        PaymentManager.getInstance().withdraw(type, payingPlayer, toLocation.getWorld());
        InvulnerabilityManager.createInvulnerability(fromPlayer, atPlayer.getInvulnerability(type, event.getToLocation().getWorld()));
        if (MainConfig.get().APPLY_COOLDOWN_AFTER.get().equalsIgnoreCase("teleport")) {
            CooldownManager.addToCooldown(type, payingPlayer, toLocation.getWorld());
        }
    }
}

