/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.sql.DataFailManager;
import io.github.niestrat99.advancedteleport.sql.SQLManager;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class HomeSQLManager
extends SQLManager {
    private static HomeSQLManager instance;

    public HomeSQLManager() {
        instance = this;
    }

    public static HomeSQLManager get() {
        return instance;
    }

    @Override
    public void createTable() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            CoreClass.debug("Creating table data for the home manager if it is not already set up.");
            try (Connection connection = this.implementConnection();){
                PreparedStatement createTable = this.prepareStatement(connection, "CREATE TABLE IF NOT EXISTS " + tablePrefix + "_homes (id INTEGER PRIMARY KEY " + this.getStupidAutoIncrementThing() + ", uuid_owner VARCHAR(256) NOT NULL, home VARCHAR(256) NOT NULL,x DOUBLE NOT NULL,y DOUBLE NOT NULL,z DOUBLE NOT NULL,yaw FLOAT NOT NULL,pitch FLOAT NOT NULL,world VARCHAR(256) NOT NULL,icon VARCHAR(256) DEFAULT 'GRASS_BLOCK' NOT NULL,timestamp_created BIGINT NOT NULL,timestamp_updated BIGINT NOT NULL)");
                this.executeUpdate(createTable);
            }
            catch (SQLException exception) {
                CoreClass.getInstance().getLogger().severe("Failed to create the homes table.");
                exception.printStackTrace();
            }
            this.transferOldData();
        });
    }

    @Override
    public void transferOldData() {
        File file = new File(CoreClass.getInstance().getDataFolder(), "homes.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration homes = YamlConfiguration.loadConfiguration((File)file);
        for (String player : homes.getKeys(false)) {
            ConfigurationSection homeSection = homes.getConfigurationSection(player);
            if (homeSection == null) continue;
            for (String home : homeSection.getKeys(false)) {
                String world;
                ConfigurationSection homeRaw = homes.getConfigurationSection(player + "." + home);
                if (homeRaw == null || (world = homeRaw.getString("world")) == null || Bukkit.getWorld((String)world) == null) continue;
                this.addHome(new Location(Bukkit.getWorld((String)world), homeRaw.getDouble("x"), homeRaw.getDouble("y"), homeRaw.getDouble("z"), (float)homeRaw.getDouble("yaw"), (float)homeRaw.getDouble("pitch")), UUID.fromString(player), home, false);
            }
        }
        file.renameTo(new File(CoreClass.getInstance().getDataFolder(), "homes-backup.yml"));
    }

    public void addHome(Location location, UUID owner, String name) {
        this.addHome(location, owner, name, true);
    }

    public void addHome(Location location, UUID owner, String name, boolean async) {
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> this.addHomePrivate(location, owner, name));
        } else {
            this.addHomePrivate(location, owner, name);
        }
    }

    private void addHomePrivate(Location location, UUID owner, String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "INSERT INTO " + tablePrefix + "_homes (uuid_owner, home, x, y, z, yaw, pitch, world, timestamp_created, timestamp_updated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, owner.toString());
            statement.setString(2, name);
            this.prepareLocation(location, 3, statement);
            statement.setLong(9, System.currentTimeMillis());
            statement.setLong(10, System.currentTimeMillis());
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.ADD_HOME, location.getWorld().getName(), String.valueOf(location.getX()), String.valueOf(location.getY()), String.valueOf(location.getZ()), String.valueOf(location.getYaw()), String.valueOf(location.getPitch()), name, owner.toString());
            exception.printStackTrace();
        }
    }

    public CompletableFuture<Integer> getHomeId(String name, UUID owner) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = this.implementConnection();){
                PreparedStatement statement = this.prepareStatement(connection, "SELECT id FROM " + tablePrefix + "_homes WHERE home = ? AND uuid_owner = ?;");
                statement.setString(1, name);
                statement.setString(2, owner.toString());
                ResultSet set = this.executeQuery(statement);
                if (!set.next()) return -1;
                Integer n = set.getInt("id");
                return n;
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
            return -1;
        }, CoreClass.async);
    }

    public void removeHome(UUID owner, String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_homes WHERE uuid_owner = ? AND home = ?");
            statement.setString(1, owner.toString());
            statement.setString(2, name);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.DELETE_HOME, owner.toString(), name);
            throw new RuntimeException(exception);
        }
    }

    public void moveHome(Location newLocation, UUID owner, String name) {
        this.moveHome(newLocation, owner, name, true);
    }

    public void moveHome(Location newLocation, UUID owner, String name, boolean async) {
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)CoreClass.getInstance(), () -> this.moveHomePrivate(newLocation, owner, name));
        } else {
            this.moveHomePrivate(newLocation, owner, name);
        }
    }

    public void moveHomePrivate(Location newLocation, UUID owner, String name) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "UPDATE " + tablePrefix + "_homes SET x = ?, y = ?, z = ?, yaw = ?, pitch = ?, world = ?, timestamp_updated = ? WHERE uuid_owner = ? AND home = ? ");
            this.prepareLocation(newLocation, 1, statement);
            statement.setLong(7, System.currentTimeMillis());
            statement.setString(8, owner.toString());
            statement.setString(9, name);
            this.executeUpdate(statement);
        }
        catch (SQLException exception) {
            DataFailManager.get().addFailure(DataFailManager.Operation.MOVE_HOME, newLocation.getWorld().getName(), String.valueOf(newLocation.getX()), String.valueOf(newLocation.getY()), String.valueOf(newLocation.getZ()), String.valueOf(newLocation.getYaw()), String.valueOf(newLocation.getPitch()), name, owner.toString());
            exception.printStackTrace();
        }
    }

    public LinkedHashMap<String, Home> getHomes(String ownerUUID) {
        LinkedHashMap<String, Home> linkedHashMap;
        block9: {
            Connection connection = this.implementConnection();
            try {
                PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_homes WHERE uuid_owner = ?");
                statement.setString(1, ownerUUID);
                ResultSet results = this.executeQuery(statement);
                LinkedHashMap<String, Home> homes = new LinkedHashMap<String, Home>();
                while (results.next()) {
                    Home home = new Home(UUID.fromString(ownerUUID), results.getString("home"), new WorldlessLocation(results.getString("world"), results.getDouble("x"), results.getDouble("y"), results.getDouble("z"), results.getFloat("yaw"), results.getFloat("pitch")), results.getLong("timestamp_created"), results.getLong("timestamp_updated"));
                    homes.put(results.getString("home"), home);
                }
                linkedHashMap = homes;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new RuntimeException(exception);
                }
            }
            connection.close();
        }
        return linkedHashMap;
    }

    public void purgeHomes(String worldName) {
        try (Connection connection = this.implementConnection();){
            PreparedStatement statement = this.prepareStatement(connection, "SELECT uuid_owner, home FROM " + tablePrefix + "_homes WHERE world = ?");
            statement.setString(1, worldName);
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(set.getString("uuid_owner")));
                if (player.getName() == null || !ATPlayer.isPlayerCached(player.getName())) continue;
                ATPlayer.getPlayer(player).removeHome(set.getString("home"));
            }
            set.close();
            statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_homes WHERE world = ?");
            statement.setString(1, worldName);
            this.executeUpdate(statement);
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
    }

    public void purgeHomes(UUID owner) {
        try (Connection connection = this.implementConnection();){
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)owner);
            if (player.getName() != null && ATPlayer.isPlayerCached(player.getName())) {
                ATPlayer atPlayer = ATPlayer.getPlayer(player);
                PreparedStatement statement = this.prepareStatement(connection, "SELECT home FROM " + tablePrefix + "_homes WHERE uuid_owner = ?");
                statement.setString(1, owner.toString());
                ResultSet set = statement.executeQuery();
                while (set.next()) {
                    atPlayer.removeHome(set.getString("home"));
                }
                set.close();
            }
            PreparedStatement statement = this.prepareStatement(connection, "DELETE FROM " + tablePrefix + "_homes WHERE uuid_owner = ?");
            statement.setString(1, owner.toString());
            this.executeUpdate(statement);
        }
        catch (SQLException throwables) {
            throw new RuntimeException(throwables);
        }
    }

    public CompletableFuture<List<Home>> getHomesBulk() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Home> arrayList;
            block9: {
                Connection connection = this.implementConnection();
                try {
                    PreparedStatement statement = this.prepareStatement(connection, "SELECT * FROM " + tablePrefix + "_homes");
                    ResultSet set = this.executeQuery(statement);
                    ArrayList<Home> homes = new ArrayList<Home>();
                    while (set.next()) {
                        UUID owner = UUID.fromString(set.getString("uuid_owner"));
                        String name = set.getString("home");
                        double x = set.getDouble("x");
                        double y = set.getDouble("y");
                        double z = set.getDouble("z");
                        double yaw = set.getDouble("yaw");
                        double pitch = set.getDouble("pitch");
                        String worldStr = set.getString("world");
                        long createdTimestamp = set.getLong("timestamp_created");
                        long updatedTimestamp = set.getLong("timestamp_updated");
                        homes.add(new Home(owner, name, new WorldlessLocation(worldStr, x, y, z, (float)yaw, (float)pitch), createdTimestamp, updatedTimestamp));
                    }
                    arrayList = homes;
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                connection.close();
            }
            return arrayList;
        }, CoreClass.async);
    }
}

