/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.sql;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.WorldlessLocation;
import io.github.niestrat99.advancedteleport.sql.BlocklistManager;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.PlayerSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class DataFailManager {
    private static DataFailManager instance;
    private final HashMap<Fail, Integer> pendingFails = new HashMap();
    private final File failCsv;

    public DataFailManager() {
        instance = this;
        this.failCsv = new File(CoreClass.getInstance().getDataFolder(), "fails.csv");
        if (this.failCsv.exists()) {
            try {
                String currentLine;
                BufferedReader reader = new BufferedReader(new FileReader(this.failCsv));
                while ((currentLine = reader.readLine()) != null) {
                    String[] data = currentLine.split(",");
                    Operation operation = Operation.valueOf(data[0]);
                    ArrayList<String> newData = new ArrayList<String>();
                    for (int i = 1; i < data.length; ++i) {
                        StringBuilder wholeData = new StringBuilder();
                        wholeData.append(data[i]);
                        while (i + 1 < data.length && data[i].endsWith("\\")) {
                            wholeData.append(data[i + 1]);
                            ++i;
                        }
                        newData.add(wholeData.toString());
                    }
                    this.addFailure(operation, newData.toArray(new String[0]));
                }
                this.failCsv.delete();
            }
            catch (IOException e) {
                CoreClass.getInstance().getLogger().severe("Failed to read the failure CSV file: " + e.getMessage());
                e.printStackTrace();
            }
        }
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)CoreClass.getInstance(), () -> {
            for (Fail fail : this.pendingFails.keySet()) {
                CoreClass.getInstance().getLogger().warning("Handling failure " + fail.operation.name() + ".");
                this.handleFailure(fail);
            }
        }, 1200L, 1200L);
    }

    public void addFailure(Operation operation, String ... data) {
        Fail fail = new Fail(operation, data);
        if (!this.pendingFails.containsKey(fail)) {
            CoreClass.getInstance().getLogger().warning("SQL failure added for operation " + operation.name() + ".");
            this.pendingFails.put(fail, 1);
        }
    }

    public void handleFailure(Fail fail) {
        Runnable run = null;
        switch (fail.operation) {
            case ADD_HOME: {
                run = () -> HomeSQLManager.get().addHome(this.locFromStrings(fail.data), UUID.fromString(fail.data[7]), fail.data[6]);
                break;
            }
            case DELETE_HOME: {
                run = () -> HomeSQLManager.get().removeHome(UUID.fromString(fail.data[0]), fail.data[1]);
                break;
            }
            case MOVE_HOME: {
                run = () -> HomeSQLManager.get().moveHome(this.locFromStrings(fail.data), UUID.fromString(fail.data[7]), fail.data[6]);
                break;
            }
            case ADD_PLAYER: {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(fail.data[0]));
                if (offlinePlayer.getName() == null) {
                    CoreClass.getInstance().getLogger().warning("Null name for " + fail.data[0] + ". Won't proceed with this.");
                    this.pendingFails.remove(fail);
                    return;
                }
                run = () -> PlayerSQLManager.get().addPlayer(offlinePlayer);
                break;
            }
            case UPDATE_PLAYER: {
                run = () -> PlayerSQLManager.get().updatePlayerInformation(Bukkit.getOfflinePlayer((UUID)UUID.fromString(fail.data[0])));
                break;
            }
            case CHANGE_TELEPORTATION: {
                run = () -> PlayerSQLManager.get().setTeleportationOn(UUID.fromString(fail.data[0]), Boolean.parseBoolean(fail.data[1]));
                break;
            }
            case SET_MAIN_HOME: {
                run = () -> PlayerSQLManager.get().setMainHome(UUID.fromString(fail.data[1]), fail.data[0]);
                break;
            }
            case ADD_BLOCK: {
                run = () -> BlocklistManager.get().blockUser(fail.data[0], fail.data[1], fail.data[2]);
                break;
            }
            case UNBLOCK: {
                run = () -> BlocklistManager.get().unblockUser(fail.data[0], fail.data[1]);
                break;
            }
            case ADD_WARP: {
                Warp warp = AdvancedTeleportAPI.getWarps().get((Object)fail.data[6]) != null ? (Warp)AdvancedTeleportAPI.getWarps().get((Object)fail.data[6]) : new Warp(UUID.fromString(fail.data[7]), fail.data[6], this.locFromStrings(fail.data), Long.parseLong(fail.data[8]), Long.parseLong(fail.data[9]));
                if (warp == null) {
                    return;
                }
                run = () -> WarpSQLManager.get().addWarp(warp);
                break;
            }
            case MOVE_WARP: {
                run = () -> WarpSQLManager.get().moveWarp(this.locFromStrings(fail.data), fail.data[6]);
                break;
            }
            case DELETE_WARP: {
                run = () -> WarpSQLManager.get().removeWarp(fail.data[0]);
                break;
            }
            case UPDATE_LOCATION: {
                run = () -> PlayerSQLManager.get().setPreviousLocation(fail.data[6], this.locFromStrings(fail.data));
            }
        }
        CompletableFuture.runAsync(run, CoreClass.async).whenComplete((v, err) -> {
            if (err != null) {
                this.pendingFails.put(fail, this.pendingFails.get(fail) + 1);
            } else {
                this.pendingFails.remove(fail);
            }
        });
    }

    @NotNull
    private WorldlessLocation locFromStrings(String ... data) {
        if (data.length < 6) {
            throw new IllegalArgumentException("Not enough arguments to get a location! " + Arrays.toString(data));
        }
        String worldStr = data[0];
        double x = Double.parseDouble(data[1]);
        double y = Double.parseDouble(data[2]);
        double z = Double.parseDouble(data[3]);
        float yaw = Float.parseFloat(data[4]);
        float pitch = Float.parseFloat(data[5]);
        return new WorldlessLocation(worldStr, x, y, z, yaw, pitch);
    }

    public static DataFailManager get() {
        return instance;
    }

    public void onDisable() {
        try {
            if (!this.pendingFails.isEmpty()) {
                if (!this.failCsv.exists()) {
                    this.failCsv.createNewFile();
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.failCsv));
                for (Fail fail : this.pendingFails.keySet()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append(fail.operation.name());
                    for (String data : fail.data) {
                        builder.append(",").append(data.replaceAll(",", "\\\\,"));
                    }
                    writer.write(builder.toString());
                    writer.write("\n");
                }
                writer.close();
            } else {
                this.failCsv.delete();
            }
        }
        catch (IOException e) {
            CoreClass.getInstance().getLogger().severe("Failed to write to the failure CSV file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static enum Operation {
        ADD_BLOCK,
        UNBLOCK,
        ADD_HOME,
        MOVE_HOME,
        DELETE_HOME,
        CHANGE_TELEPORTATION,
        UPDATE_PLAYER,
        ADD_PLAYER,
        UPDATE_LOCATION,
        SET_MAIN_HOME,
        ADD_WARP,
        MOVE_WARP,
        DELETE_WARP;

    }

    public static class Fail {
        private final String[] data;
        private final Operation operation;

        public Fail(Operation operation, String ... data) {
            this.data = data;
            this.operation = operation;
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.operation});
            result = 31 * result + Arrays.hashCode(this.data);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Fail fail = (Fail)o;
            return Arrays.equals(this.data, fail.data) && this.operation == fail.operation;
        }
    }
}

