/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.payments.types;

import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.payments.Payment;
import io.github.niestrat99.advancedteleport.payments.types.LevelsPayment;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PointsPayment
extends Payment {
    private int points;
    private LevelsPayment levels;

    public PointsPayment(int points) {
        this.points = points;
        this.levels = null;
    }

    @Override
    public double getPaymentAmount() {
        return this.points;
    }

    @Override
    public void setPaymentAmount(double amount) {
        this.points = (int)amount;
    }

    @Override
    public double getPlayerAmount(Player player) {
        int xpLevels = this.getTotalEXPFromLevel(player.getLevel());
        int totalXPinLevel = this.expInLevel(player.getLevel());
        return xpLevels + (int)(player.getExp() * (float)totalXPinLevel);
    }

    @Override
    public String getMessagePath() {
        return "Info.paymentPoints";
    }

    @Override
    public String getId() {
        return "exp";
    }

    @Override
    public void setPlayerAmount(Player player) {
        int expPoints = this.levels == null ? 0 : this.getEXPBetweenLevels(player.getLevel(), (int)this.levels.getPaymentAmount());
        player.giveExp(-this.points);
        player.giveExp(-expPoints);
        if (expPoints > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Info.paymentEXP", new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(this.points + expPoints)), Placeholder.unparsed((String)"levels", (String)String.valueOf(player.getLevel()))});
        }
        if (this.points > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Info.paymentPoints", new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(this.points + expPoints)), Placeholder.unparsed((String)"points", (String)String.valueOf(this.getPlayerAmount(player)))});
        }
    }

    @Override
    public boolean canPay(Player player) {
        int requiredPoints = this.points;
        if (this.levels != null) {
            if (this.levels.getPaymentAmount() > (double)player.getLevel()) {
                CustomMessages.sendMessage((CommandSender)player, "Error.notEnoughEXP", new TagResolver[]{Placeholder.unparsed((String)"levels", (String)String.valueOf(this.levels.getPaymentAmount()))});
                return false;
            }
            int expPoints = this.getEXPBetweenLevels(player.getLevel(), (int)this.levels.getPaymentAmount());
            requiredPoints += expPoints;
        }
        if (this.getPlayerAmount(player) >= (double)requiredPoints) {
            return true;
        }
        CustomMessages.sendMessage((CommandSender)player, "Error.notEnoughEXPPoints", new TagResolver[]{Placeholder.unparsed((String)"points", (String)String.valueOf(requiredPoints))});
        return false;
    }

    protected int getTotalEXPFromLevel(int maxLevel) {
        int expPoints = 0;
        for (int i = 0; i < maxLevel; ++i) {
            expPoints += this.expInLevel(i);
        }
        return expPoints;
    }

    protected int getEXPBetweenLevels(int maxLevel, int levels) {
        int minLevel = maxLevel - levels;
        return this.getTotalEXPFromLevel(maxLevel) - this.getTotalEXPFromLevel(minLevel);
    }

    protected int expInLevel(int currentLevel) {
        if (currentLevel < 16) {
            return 2 * currentLevel + 7;
        }
        if (currentLevel < 31) {
            return 5 * currentLevel - 38;
        }
        return 9 * currentLevel - 158;
    }

    public void addLevels(LevelsPayment levels) {
        if (this.levels == null) {
            this.levels = levels;
        } else {
            this.levels.setPaymentAmount(this.levels.getPaymentAmount() + levels.getPaymentAmount());
        }
    }
}

