/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.payments.types;

import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.payments.Payment;
import java.util.Iterator;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemsPayment
extends Payment {
    private final Material material;
    private int amount;

    public ItemsPayment(Material material, int amount) {
        this.material = material;
        this.amount = amount;
    }

    public static ItemsPayment getFromString(String str) {
        String[] parts = str.split(":");
        switch (parts.length) {
            case 0: {
                return null;
            }
            case 1: {
                Material material = Material.getMaterial((String)parts[0].toUpperCase());
                if (material == null) {
                    return null;
                }
                return new ItemsPayment(material, 1);
            }
        }
        Material material = Material.getMaterial((String)parts[0].toUpperCase());
        if (material == null) {
            return null;
        }
        int amount = 1;
        if (parts[1].matches("^[0-9]+$")) {
            amount = Integer.parseInt(parts[1]);
        }
        return new ItemsPayment(material, amount);
    }

    @Override
    public double getPaymentAmount() {
        return this.amount;
    }

    @Override
    public void setPaymentAmount(double amount) {
        this.amount = (int)amount;
    }

    @Override
    public double getPlayerAmount(Player player) {
        int count = 0;
        for (ItemStack item : player.getInventory().all(this.material).values()) {
            count += item.getAmount();
        }
        return count;
    }

    @Override
    public String getMessagePath() {
        return null;
    }

    @Override
    public String getId() {
        return "item";
    }

    @Override
    public void setPlayerAmount(Player player) {
        int remaining = this.amount;
        ItemMeta meta = new ItemStack(this.material).getItemMeta();
        String name = meta != null && meta.hasLocalizedName() ? meta.getLocalizedName() : this.material.name();
        Iterator iterator = player.getInventory().all(this.material).keySet().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (remaining == 0) break;
            ItemStack item = player.getInventory().getItem(slot);
            if (item == null) continue;
            if (remaining >= item.getAmount()) {
                remaining -= item.getAmount();
                player.getInventory().setItem(slot, null);
                continue;
            }
            item.setAmount(item.getAmount() - remaining);
            remaining = 0;
        }
        if (this.amount > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Info.paymentItems", new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(this.amount)), Placeholder.unparsed((String)"type", (String)name)});
        }
    }

    @Override
    public boolean canPay(Player player) {
        boolean result = super.canPay(player);
        if (!result) {
            ItemMeta meta = new ItemStack(this.material).getItemMeta();
            String name = meta != null && meta.hasLocalizedName() ? meta.getLocalizedName() : this.material.name();
            CustomMessages.sendMessage((CommandSender)player, "Error.notEnoughItems", new TagResolver[]{Placeholder.unparsed((String)"amount", (String)String.valueOf(this.amount)), Placeholder.unparsed((String)"type", (String)name)});
        }
        return result;
    }

    public Material getMaterial() {
        return this.material;
    }

    private boolean hasNBT(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        for (NamespacedKey namespacedKey : meta.getPersistentDataContainer().getKeys()) {
        }
        return false;
    }

    public static class NBTJSONRepresentation {
    }
}

