/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Home;
import io.github.niestrat99.advancedteleport.api.Spawn;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.managers.InvulnerabilityManager;
import io.github.niestrat99.advancedteleport.managers.ParticleManager;
import io.github.niestrat99.advancedteleport.managers.RTPManager;
import io.github.niestrat99.advancedteleport.utilities.ConditionChecker;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TeleportTrackingManager
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (e.getPlayer().hasMetadata("NPC")) {
            return;
        }
        Player player = e.getPlayer();
        if (player.hasPermission("at.admin.bypass.teleport-on-join")) {
            return;
        }
        boolean teleported = false;
        if (!player.hasPlayedBefore() && MainConfig.get().TELEPORT_TO_SPAWN_FIRST.get().booleanValue()) {
            String name = MainConfig.get().FIRST_SPAWN_POINT.get();
            Spawn spawn = AdvancedTeleportAPI.getSpawn(name);
            if (spawn != null) {
                this.spawn(player, spawn.getLocation());
                teleported = true;
            } else if (name.isEmpty() && AdvancedTeleportAPI.getMainSpawn() != null) {
                this.spawn(player, AdvancedTeleportAPI.getMainSpawn().getLocation());
                teleported = true;
            } else {
                CoreClass.getInstance().getLogger().warning("First-join teleport point " + name + " does not exist.");
            }
        }
        if (!player.hasPlayedBefore() && MainConfig.get().USE_RANDOM_LOCATION_FIRST_SPAWN_POINT.get().booleanValue()) {
            World targetWorld;
            String worldName = MainConfig.get().FIRST_RANDOM_LOCATION_WORLD_NAME.get();
            if ((worldName == null || worldName.isEmpty()) && AdvancedTeleportAPI.getMainSpawn() != null) {
                worldName = AdvancedTeleportAPI.getMainSpawn().getName();
            }
            World world = targetWorld = worldName == null || worldName.isEmpty() ? player.getWorld() : Bukkit.getWorld((String)worldName);
            if (targetWorld != null) {
                teleported = true;
                AdvancedTeleportAPI.getRandomLocation(targetWorld, player).whenCompleteAsync((result, err) -> {
                    if (err != null) {
                        CoreClass.getInstance().getLogger().warning("Failed to randomly teleport " + player.getName() + " on their first join! No location could be found.");
                        return;
                    }
                    ATPlayer atPlayer = ATPlayer.getPlayer(player);
                    this.spawn(player, (Location)result);
                    InvulnerabilityManager.createInvulnerability(player, atPlayer.getInvulnerability("tpr", result.getWorld()));
                    ParticleManager.onPostTeleport(player, "tpr");
                    if (MainConfig.get().USE_HOMES.get().booleanValue() && MainConfig.get().SET_RANDOM_FIRST_LOCATION_HOME.get().booleanValue()) {
                        atPlayer.addHome("home", (Location)result);
                    }
                }, CoreClass.sync);
            } else {
                CoreClass.getInstance().getLogger().warning("Failed to randomly teleport " + player.getName() + " on their first join! The target world (" + worldName + ") either doesn't exist or wasn't specified.");
            }
        }
        if (!teleported && MainConfig.get().TELEPORT_TO_SPAWN_EVERY.get().booleanValue()) {
            Spawn spawn = AdvancedTeleportAPI.getDestinationSpawn(player.getWorld(), player);
            this.spawn(player, spawn.getLocation());
        }
    }

    private void spawn(Player player, Location spawn) {
        Bukkit.getScheduler().runTaskLater((Plugin)CoreClass.getInstance(), () -> ATPlayer.teleportWithOptions(player, spawn, PlayerTeleportEvent.TeleportCause.PLUGIN).whenComplete((result, err) -> {
            if (!result.booleanValue()) {
                CoreClass.getInstance().getLogger().warning("Failed to teleport " + player.getName() + " on joining.");
            }
        }), 10L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getPlayer().hasMetadata("NPC")) {
            return;
        }
        String result = ConditionChecker.canTeleport(e.getFrom(), e.getTo(), null, e.getPlayer());
        if (result != null) {
            CustomMessages.sendMessage((CommandSender)e.getPlayer(), result, new TagResolver[]{Placeholder.unparsed((String)"world", (String)e.getTo().getWorld().getName())});
            e.setCancelled(true);
            return;
        }
        CoreClass.debug("Testing to see if " + e.getPlayer().getName() + " can have their location changed via a " + e.getCause().name() + " teleport...");
        if (MainConfig.get().USE_BASIC_TELEPORT_FEATURES.get().booleanValue() && MainConfig.get().BACK_TELEPORT_CAUSES.get().contains(e.getCause().name())) {
            CoreClass.debug(e.getPlayer().getName() + "'s back location has been updated to " + CoreClass.getShortLocation(e.getFrom()));
            ATPlayer.getPlayer(e.getPlayer()).setPreviousLocation(e.getFrom());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(ATTeleportEvent e) {
        if (!e.getType().isRestricted()) {
            return;
        }
        String result = ConditionChecker.canTeleport(e.getFromLocation(), e.getToLocation(), e.getType().getName(), e.getPlayer());
        if (result != null) {
            CustomMessages.sendMessage((CommandSender)e.getPlayer(), result, new TagResolver[]{Placeholder.unparsed((String)"world", (String)e.getToLocation().getWorld().getName())});
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent e) {
        if (e.getEntity().hasMetadata("NPC")) {
            return;
        }
        CoreClass.debug("Testing to see if " + e.getEntity().getName() + " can have their location changed via death...");
        if (MainConfig.get().USE_BASIC_TELEPORT_FEATURES.get().booleanValue() && e.getEntity().hasPermission("at.member.back.death")) {
            CoreClass.debug(e.getEntity().getName() + "'s back (death) location has been updated to " + CoreClass.getShortLocation(e.getEntity().getLocation()));
            ATPlayer.getPlayer(e.getEntity()).setPreviousLocation(e.getEntity().getLocation());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent e) {
        if (e.getPlayer().hasMetadata("NPC")) {
            return;
        }
        if (!MainConfig.get().USE_SPAWN.get().booleanValue()) {
            return;
        }
        ConfigSection deathManagement = MainConfig.get().DEATH_MANAGEMENT.get();
        String spawnCommand = deathManagement.getString(e.getPlayer().getWorld().getName());
        if (spawnCommand == null || spawnCommand.equals("default")) {
            spawnCommand = deathManagement.getString("default");
            CoreClass.debug("Default command: " + spawnCommand);
            if (spawnCommand == null) {
                return;
            }
        }
        for (String command : spawnCommand.split(";")) {
            CoreClass.debug("Handling respawn command: " + command);
            if (TeleportTrackingManager.handleSpawn(e, command)) break;
        }
    }

    private static boolean handleSpawn(@NotNull PlayerRespawnEvent e, @NotNull String spawnCommand) {
        World operatingWorld;
        ATPlayer atPlayer = ATPlayer.getPlayer(e.getPlayer());
        ConfigSection deathManagement = MainConfig.get().DEATH_MANAGEMENT.get();
        World world = atPlayer.getPreviousLocation() == null ? (AdvancedTeleportAPI.getMainSpawn() == null ? (World)Bukkit.getWorlds().get(0) : AdvancedTeleportAPI.getMainSpawn().getLocation().getWorld()) : (operatingWorld = atPlayer.getPreviousLocation().getWorld());
        if (spawnCommand.equals("default") && (spawnCommand = deathManagement.getString("default")) == null) {
            return false;
        }
        if (spawnCommand.startsWith("tpr") && MainConfig.get().RAPID_RESPONSE.get().booleanValue()) {
            Location loc;
            String worldStr;
            World world2 = operatingWorld;
            if (spawnCommand.indexOf(58) != -1 && !(worldStr = spawnCommand.substring(spawnCommand.indexOf(58))).isEmpty() && (world2 = Bukkit.getWorld((String)worldStr)) == null) {
                world2 = operatingWorld;
            }
            if ((loc = RTPManager.getLocationUrgently(world2)) != null) {
                e.setRespawnLocation(loc);
                return true;
            }
        }
        if (spawnCommand.equals("spawn")) {
            Spawn spawn = AdvancedTeleportAPI.getDestinationSpawn(operatingWorld, e.getPlayer());
            e.setRespawnLocation(spawn.getLocation());
            CoreClass.debug("Respawn location set to: " + CoreClass.getShortLocation(spawn.getLocation()));
            return true;
        }
        if (spawnCommand.equals("home")) {
            if (atPlayer.getMainHome() != null) {
                e.setRespawnLocation(atPlayer.getMainHome().getLocation());
                CoreClass.debug("Respawn location set to: " + CoreClass.getShortLocation(atPlayer.getMainHome().getLocation()));
                return true;
            }
            if (!atPlayer.getHomes().isEmpty()) {
                Home home = (Home)atPlayer.getHomes().values().iterator().next();
                e.setRespawnLocation(home.getLocation());
                CoreClass.debug("Respawn location set to: " + CoreClass.getShortLocation(home.getLocation()));
                return true;
            }
        }
        if (spawnCommand.equals("bed")) {
            CoreClass.debug("Setting respawn point to " + String.valueOf(e.getPlayer()) + "'s bed.");
            return e.getPlayer().getBedSpawnLocation() != null;
        }
        if (spawnCommand.startsWith("warp:")) {
            try {
                String warpName = spawnCommand.split(":")[1];
                Warp warp = AdvancedTeleportAPI.getWarp(warpName);
                CoreClass.debug("Checking for warp " + warpName + " to respawn at.");
                if (warp != null) {
                    e.setRespawnLocation(warp.getLocation());
                    CoreClass.debug("Respawn location set to: " + CoreClass.getShortLocation(warp.getLocation()));
                    return true;
                }
                CoreClass.getInstance().getLogger().warning("Unknown warp " + warpName + " for death in " + String.valueOf(operatingWorld));
            }
            catch (IndexOutOfBoundsException ex) {
                CoreClass.getInstance().getLogger().warning("Malformed warp name for death in " + String.valueOf(operatingWorld));
            }
        }
        return spawnCommand.equals("anchor");
    }
}

