/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import com.google.common.collect.Sets;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.utilities.RandomCoords;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.Nullable;

public class RTPManager {
    private static final HashSet<String> airs = Sets.newHashSet((Object[])new String[]{"AIR", "CAVE_AIR", "VOID_AIR"});
    private static HashMap<UUID, Queue<Location>> locQueue;

    public static void init() {
        locQueue = new HashMap();
        if (!PaperLib.isPaper()) {
            CoreClass.debug("Server is not using Paper, cannot initialise RTPManager.");
            return;
        }
        if (!MainConfig.get().RAPID_RESPONSE.get().booleanValue()) {
            CoreClass.debug("Rapid response is not enabled, cannot initialise RTPManager.");
            return;
        }
        CoreClass.getInstance().getLogger().info("Preparing random teleportation locations. If your server performance or memory suffers, please set `use-rapid-response` to false in the config.yml file.");
        try {
            RTPManager.getPreviousLocations();
        }
        catch (IOException e) {
            CoreClass.getInstance().getLogger().severe("Failed to load previous RTP locations, generating new ones: " + e.getMessage());
        }
        for (World loadedWorld : Bukkit.getWorlds()) {
            RTPManager.loadWorldData(loadedWorld);
        }
    }

    public static boolean isInitialised() {
        return locQueue != null;
    }

    public static CompletableFuture<Location> getNextAvailableLocation(World world) {
        Queue<Location> queue = locQueue.get(world.getUID());
        RTPManager.addLocation(world, false, 0).thenAccept(location -> {
            if (location == null) {
                return;
            }
            queue.add((Location)location);
            locQueue.put(world.getUID(), queue);
        });
        if (queue == null || queue.isEmpty()) {
            return RTPManager.addLocation(world, true, 0);
        }
        return CompletableFuture.completedFuture(queue.poll());
    }

    public static Location getLocationUrgently(World world) {
        Queue<Location> queue = locQueue.get(world.getUID());
        RTPManager.addLocation(world, false, 0).thenAccept(location -> {
            if (location == null) {
                return;
            }
            queue.add((Location)location);
            locQueue.put(world.getUID(), queue);
        });
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        return queue.remove();
    }

    public static CompletableFuture<@Nullable Location> addLocation(World world, boolean urgent, int tries) {
        Location location;
        CoreClass.debug("Attempting to either add a location or return it for /rtp.");
        if (!PaperLib.isPaper()) {
            return CompletableFuture.completedFuture(null);
        }
        ++tries;
        if (locQueue.get(world.getUID()) != null && locQueue.get(world.getUID()).size() > MainConfig.get().PREPARED_LOCATIONS_LIMIT.get()) {
            Location loc2 = locQueue.get(world.getUID()).poll();
            if (!PluginHookManager.get().isClaimed(loc2)) {
                CoreClass.debug("Area is not claimed - returning as valid location");
                return CompletableFuture.completedFuture(loc2);
            }
        }
        if ((location = RandomCoords.generateCoords(world)) == null) {
            return CompletableFuture.completedFuture(null);
        }
        int[] coords = new int[]{location.getBlockX(), location.getBlockZ()};
        int finalTries = tries;
        CoreClass.debug("Attempting coordinates: " + Arrays.toString(coords) + " (try " + finalTries + ")");
        return ((CompletableFuture)PaperLib.getChunkAtAsync((World)world, (int)(coords[0] >> 4), (int)(coords[1] >> 4), (boolean)true, (boolean)urgent).thenApplyAsync(chunk -> {
            Block block;
            Block block2 = block = world.getEnvironment().equals((Object)World.Environment.NETHER) ? RTPManager.doBinaryJump(world, coords) : world.getHighestBlockAt(coords[0], coords[1]);
            if (RTPManager.isValidLocation(block)) {
                CoreClass.debug("Valid location found - returning it");
                return block.getLocation().add(0.5, 1.0, 0.5);
            }
            if (finalTries < 10) {
                CoreClass.debug("Invalid location, trying again...");
                return RTPManager.addLocation(world, urgent, finalTries).join();
            }
            CoreClass.debug("Invalid location - not going to try again");
            return null;
        }, CoreClass.async)).thenApplyAsync(loc -> loc, CoreClass.sync);
    }

    private static Block doBinaryJump(World world, int[] coords) {
        Location location = new Location(world, (double)coords[0], 128.0, (double)coords[1]);
        int jumpAmount = 128;
        if (world.getEnvironment() == World.Environment.NETHER) {
            location.setY(64.0);
            jumpAmount = 64;
        }
        boolean up = false;
        Location tempLoc = location.clone();
        while (true) {
            if ((jumpAmount /= 2) == 0) {
                location.setY(-3.0);
                return location.getBlock();
            }
            Location subTempLocation = tempLoc.clone();
            Material currentMat = up ? subTempLocation.add(0.0, (double)jumpAmount, 0.0).getBlock().getType() : subTempLocation.subtract(0.0, (double)jumpAmount, 0.0).getBlock().getType();
            tempLoc = subTempLocation.clone();
            if (currentMat != Material.AIR) {
                if (subTempLocation.add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR && subTempLocation.clone().add(0.0, 1.0, 0.0).getBlock().getType() == Material.AIR) {
                    return subTempLocation.add(0.5, -1.0, 0.5).getBlock();
                }
                up = true;
                continue;
            }
            up = false;
        }
    }

    private static boolean isValidLocation(Block block) {
        if (airs.contains(block.getType().name())) {
            return false;
        }
        if (MainConfig.get().AVOID_BIOMES.get().contains(block.getBiome().name())) {
            return false;
        }
        return !MainConfig.get().AVOID_BLOCKS.get().contains(block.getType().name());
    }

    public static void loadWorldData(World world) {
        int size;
        if (locQueue == null) {
            return;
        }
        if (MainConfig.get().WHITELIST_WORLD.get().booleanValue() && !MainConfig.get().ALLOWED_WORLDS.get().contains(world.getName())) {
            return;
        }
        if (world.getGenerator() != null && MainConfig.get().IGNORE_WORLD_GENS.get().contains(world.getGenerator().getClass().getName())) {
            return;
        }
        for (int i = size = ((Queue)locQueue.getOrDefault(world.getUID(), new ArrayDeque())).size(); i < MainConfig.get().PREPARED_LOCATIONS_LIMIT.get(); ++i) {
            RTPManager.addLocation(world, false, 0).thenAccept(location -> {
                Queue queue = locQueue.getOrDefault(world.getUID(), new ArrayDeque());
                queue.add(location);
                locQueue.put(world.getUID(), queue);
            });
        }
    }

    public static void unloadWorldData(World world) {
        locQueue.remove(world.getUID());
    }

    public static void clearEverything() {
        locQueue.clear();
    }

    public static void getPreviousLocations() throws IOException {
        String currentLine;
        CoreClass.debug("Loading previously discovered locations.");
        File rtpLocsFile = new File(CoreClass.getInstance().getDataFolder(), "rtp-locations.csv");
        if (!rtpLocsFile.exists()) {
            CoreClass.debug("Not loading previous locations - rtp-locations.csv does not exist.");
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(rtpLocsFile));
        while ((currentLine = reader.readLine()) != null) {
            try {
                String[] data = currentLine.split(",");
                UUID worldUUID = UUID.fromString(data[0]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                double[] loc = new double[]{Double.parseDouble(data[1]), Double.parseDouble(data[2]), Double.parseDouble(data[3])};
                Location location = new Location(world, loc[0], loc[1], loc[2]);
                Queue queue = locQueue.getOrDefault(worldUUID, new ArrayDeque());
                queue.add(location);
                locQueue.put(worldUUID, queue);
                CoreClass.debug("Added previous location " + String.valueOf(location));
            }
            catch (Exception exception) {}
        }
        reader.close();
        rtpLocsFile.delete();
    }

    public static void saveLocations() throws IOException {
        File rtpLocsFile = new File(CoreClass.getInstance().getDataFolder(), "rtp-locations.csv");
        if (!rtpLocsFile.exists()) {
            rtpLocsFile.createNewFile();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(rtpLocsFile));
        for (UUID worldUUID : locQueue.keySet()) {
            Queue<Location> locations = locQueue.get(worldUUID);
            while (locations.peek() != null) {
                Location loc = locations.poll();
                String locLine = worldUUID.toString() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
                writer.write(locLine);
                writer.write("\n");
            }
        }
        writer.close();
    }
}

