/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.BorderPlugin;
import io.github.niestrat99.advancedteleport.hooks.ClaimPlugin;
import io.github.niestrat99.advancedteleport.hooks.MapPlugin;
import io.github.niestrat99.advancedteleport.hooks.PluginHook;
import io.github.niestrat99.advancedteleport.hooks.borders.ChunkyBorderHook;
import io.github.niestrat99.advancedteleport.hooks.borders.VanillaBorderHook;
import io.github.niestrat99.advancedteleport.hooks.borders.WorldBorderHook;
import io.github.niestrat99.advancedteleport.hooks.claims.GriefPreventionClaimHook;
import io.github.niestrat99.advancedteleport.hooks.claims.LandsClaimHook;
import io.github.niestrat99.advancedteleport.hooks.claims.WorldGuardClaimHook;
import io.github.niestrat99.advancedteleport.hooks.imports.EssentialsHook;
import io.github.niestrat99.advancedteleport.hooks.maps.DynmapHook;
import io.github.niestrat99.advancedteleport.hooks.maps.SquaremapHook;
import io.github.niestrat99.advancedteleport.hooks.particles.PlayerParticlesHook;
import io.github.niestrat99.advancedteleport.sql.HomeSQLManager;
import io.github.niestrat99.advancedteleport.sql.SpawnSQLManager;
import io.github.niestrat99.advancedteleport.sql.WarpSQLManager;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginHookManager {
    private HashMap<String, PluginHook> activePluginHooks;
    private static PluginHookManager instance;

    public PluginHookManager() {
        instance = this;
        this.init();
    }

    public void init() {
        this.activePluginHooks = new HashMap();
        this.loadPlugin("essentials", EssentialsHook.class);
        this.loadPlugin("worldborder", WorldBorderHook.class);
        this.loadPlugin("chunkyborder", ChunkyBorderHook.class);
        this.loadPlugin("vanilla", VanillaBorderHook.class);
        this.loadPlugin("playerparticles", PlayerParticlesHook.class);
        this.loadPlugin("worldguard", WorldGuardClaimHook.class);
        this.loadPlugin("lands", LandsClaimHook.class);
        this.loadPlugin("griefprevention", GriefPreventionClaimHook.class);
        this.loadPlugin("squaremap", SquaremapHook.class);
        this.loadPlugin("dynmap", DynmapHook.class);
        this.getPluginHooks(MapPlugin.class, true).forEach(mapPlugin -> {
            mapPlugin.enable();
            this.addIcons(MainConfig.get().MAP_WARPS.isEnabled(), WarpSQLManager.get().getWarpsBulk(), mapPlugin::addWarp);
            this.addIcons(MainConfig.get().MAP_HOMES.isEnabled(), HomeSQLManager.get().getHomesBulk(), mapPlugin::addHome);
            this.addIcons(MainConfig.get().MAP_SPAWNS.isEnabled(), SpawnSQLManager.get().getSpawns(), mapPlugin::addSpawn);
        });
    }

    @Contract(pure=true)
    public static PluginHookManager get() {
        return instance;
    }

    @Contract(pure=true)
    @NotNull
    public <H extends PluginHook> Stream<H> getPluginHooks(@NotNull Class<H> clazz, boolean filterUsable) {
        return this.activePluginHooks.values().stream().filter(clazz::isInstance).map(clazz::cast).filter(hook -> !filterUsable || hook.pluginUsable());
    }

    @Contract(pure=true)
    @NotNull
    public <H extends PluginHook> Stream<H> getPluginHooks(@NotNull Class<H> clazz) {
        return this.getPluginHooks(clazz, false);
    }

    @Contract(pure=true)
    @Nullable
    public <H extends PluginHook> H getPluginHook(@NotNull String name, @NotNull Class<H> clazz) {
        PluginHook plugin = this.activePluginHooks.get(name);
        if (plugin == null) {
            return null;
        }
        if (!clazz.isInstance(plugin)) {
            return null;
        }
        return (H)((PluginHook)clazz.cast(plugin));
    }

    private void loadPlugin(@NotNull String name, @NotNull Class<? extends PluginHook> clazz) {
        try {
            this.activePluginHooks.put(name, clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException | NoClassDefFoundError | InvocationTargetException throwable) {
            // empty catch block
        }
    }

    @Contract(pure=true)
    public double[] getRandomCoords(@NotNull World world) {
        return this.getPluginHooks(BorderPlugin.class, true).filter(plugin -> plugin.canUse(world)).findFirst().map(hook -> new double[]{hook.getMinX(world), hook.getMaxX(world), hook.getMinZ(world), hook.getMaxZ(world)}).orElse(null);
    }

    @Contract(pure=true)
    public boolean isClaimed(@NotNull Location location) {
        CoreClass.debug("Check initiated to see if " + String.valueOf(location) + " is claimed.");
        return this.getPluginHooks(ClaimPlugin.class, true).filter(plugin -> plugin.canUse(location.getWorld())).anyMatch(hook -> {
            boolean result = hook.isClaimed(location);
            CoreClass.debug("Claim result for " + hook.pluginName() + ": " + result);
            return result;
        });
    }

    @Contract(pure=true)
    public boolean floodgateEnabled() {
        try {
            Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private <T> void addIcons(boolean requirement, @NotNull CompletableFuture<List<T>> pois, @NotNull Consumer<T> handler) {
        if (!requirement) {
            return;
        }
        pois.thenAcceptAsync(result -> result.forEach(handler), CoreClass.sync);
    }
}

