/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.hooks.ParticlesPlugin;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParticleManager {
    private ParticleManager() {
    }

    public static void applyParticles(@NotNull Player player, @NotNull String command) {
        if (!MainConfig.get().USE_PARTICLES.get().booleanValue()) {
            return;
        }
        PluginHookManager.get().getPluginHooks(ParticlesPlugin.class, true).forEach(plugin -> plugin.applyParticles(player, command));
    }

    public static void removeParticles(@NotNull Player player, @NotNull String command) {
        if (!MainConfig.get().USE_PARTICLES.get().booleanValue()) {
            return;
        }
        String particle = MainConfig.get().TELEPORT_PARTICLES.valueOf(command).get();
        if (particle.equals("spark")) {
            ParticleManager.doSpark(player.getLocation());
        }
        PluginHookManager.get().getPluginHooks(ParticlesPlugin.class, true).forEach(hook -> hook.removeParticles(player, command));
    }

    public static void onPreTeleport(@NotNull Player player, @NotNull String command) {
        ParticleManager.onTeleport(player, command, MainConfig.get().TELEPORT_PARTICLES);
    }

    public static void onPostTeleport(@NotNull Player player, @NotNull String command) {
        ParticleManager.onTeleport(player, command, MainConfig.get().POST_TELEPORT_PARTICLES);
    }

    private static void onTeleport(@NotNull Player player, @NotNull String command, @NotNull MainConfig.PerCommandOption<String> particlesOption) {
        if (!MainConfig.get().USE_PARTICLES.get().booleanValue()) {
            return;
        }
        ParticleManager.removeParticles(player, command);
        String particle = particlesOption.valueOf(command).get();
        if (particle.equals("spark")) {
            ParticleManager.doSpark(player.getLocation());
            return;
        }
        ParticleManager.applyParticles(player, command);
        Bukkit.getServer().getScheduler().runTask((Plugin)CoreClass.getInstance(), () -> ParticleManager.removeParticles(player, command));
    }

    @Nullable
    public static String getData(@NotNull Player player) {
        if (!MainConfig.get().USE_PARTICLES.get().booleanValue()) {
            return null;
        }
        return PluginHookManager.get().getPluginHooks(ParticlesPlugin.class, true).map(hook -> hook.getParticle(player)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void doSpark(@NotNull Location location) {
        location.getWorld().spawnParticle(ParticleManager.getSpark(), location, 50, 0.0, 0.0, 0.0, 0.5);
    }

    private static Particle getSpark() {
        try {
            Particle particle = (Particle)Registry.PARTICLE_TYPE.get(NamespacedKey.fromString((String)"minecraft:firework"));
            if (particle == null) {
                return Particle.valueOf((String)"FIREWORKS_SPARK");
            }
            return particle;
        }
        catch (NoSuchFieldError whyWouldYouDoThisSpigot) {
            return Particle.valueOf((String)"FIREWORKS_SPARK");
        }
    }
}

