/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import io.github.niestrat99.advancedteleport.managers.InvulnerabilityManager;
import io.github.niestrat99.advancedteleport.managers.ParticleManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class MovementManager
implements Listener {
    private static final HashMap<UUID, ImprovedRunnable> movement = new HashMap();

    @EventHandler
    public void onMovement(PlayerMoveEvent event) {
        boolean cancelled = MovementManager.willCancelTimer(event);
        UUID uuid = event.getPlayer().getUniqueId();
        if (cancelled && movement.containsKey(uuid)) {
            ImprovedRunnable timer = movement.get(uuid);
            timer.cancel();
            CustomMessages.sendMessage((CommandSender)event.getPlayer(), "Teleport.eventMovement", new TagResolver[0]);
            ParticleManager.removeParticles(event.getPlayer(), timer.command);
            movement.remove(uuid);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!movement.containsKey(player.getUniqueId())) {
            return;
        }
        if (MainConfig.get().CANCEL_WARM_UP_ON_DAMAGE.get().booleanValue() && !player.hasPermission("at.admin.bypass.damage")) {
            return;
        }
        ImprovedRunnable timer = movement.get(player.getUniqueId());
        timer.cancel();
        CustomMessages.sendMessage((CommandSender)player, "Teleport.eventDamage", new TagResolver[0]);
        ParticleManager.removeParticles(player, timer.command);
        movement.remove(player.getUniqueId());
    }

    private static boolean willCancelTimer(PlayerMoveEvent event) {
        Location locFrom;
        Location locTo;
        boolean cancelOnRotate = MainConfig.get().CANCEL_WARM_UP_ON_ROTATION.get() != false && !event.getPlayer().hasPermission("at.admin.bypass.rotation");
        boolean cancelOnMove = MainConfig.get().CANCEL_WARM_UP_ON_MOVEMENT.get() != false && !event.getPlayer().hasPermission("at.admin.bypass.movement");
        boolean cancelled = false;
        if (cancelOnMove) {
            locTo = event.getTo();
            locFrom = event.getFrom();
            if (MainConfig.get().CHECK_EXACT_COORDINATES.get().booleanValue()) {
                if (locTo.getX() != locFrom.getX() || locTo.getY() != locFrom.getY() || locTo.getZ() != locFrom.getZ()) {
                    cancelled = true;
                }
            } else if (locTo.getBlockX() != locFrom.getBlockX() || locTo.getBlockY() != locFrom.getBlockY() || locTo.getBlockZ() != locFrom.getBlockZ()) {
                cancelled = true;
            }
        }
        if (cancelOnRotate && !cancelled) {
            locTo = event.getTo();
            locFrom = event.getFrom();
            if (locTo.getPitch() != locFrom.getPitch() || locTo.getYaw() != locFrom.getYaw()) {
                cancelled = true;
            }
        }
        return cancelled;
    }

    public static HashMap<UUID, ImprovedRunnable> getMovement() {
        return movement;
    }

    public static void createMovementTimer(Player teleportingPlayer, Location location, String command, String message, int warmUp, TagResolver ... placeholders) {
        MovementManager.createMovementTimer(teleportingPlayer, location, command, message, warmUp, teleportingPlayer, placeholders);
    }

    public static void createMovementTimer(final Player teleportingPlayer, final Location location, final String command, final String message, int warmUp, final Player payingPlayer, final TagResolver ... placeholders) {
        final UUID uuid = teleportingPlayer.getUniqueId();
        if (MainConfig.get().BLINDNESS_ON_WARMUP.get().booleanValue()) {
            teleportingPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, warmUp * 20 + 20, 0, false, false));
        }
        ParticleManager.applyParticles(teleportingPlayer, command);
        ImprovedRunnable movementTimer = new ImprovedRunnable(command){

            public void run() {
                if (!PaymentManager.getInstance().canPay(command, payingPlayer, location.getWorld())) {
                    return;
                }
                ParticleManager.onPreTeleport(teleportingPlayer, command);
                ATPlayer.teleportWithOptions(teleportingPlayer, location, PlayerTeleportEvent.TeleportCause.COMMAND).whenComplete((result, err) -> {
                    if (!result.booleanValue()) {
                        CustomMessages.sendMessage((CommandSender)teleportingPlayer, "Error.teleportFailed", new TagResolver[0]);
                        return;
                    }
                    CustomMessages.sendMessage((CommandSender)teleportingPlayer, message, placeholders);
                    PaymentManager.getInstance().withdraw(command, payingPlayer, location.getWorld());
                    ParticleManager.onPostTeleport(teleportingPlayer, command);
                    InvulnerabilityManager.createInvulnerability(teleportingPlayer, ATPlayer.getPlayer(teleportingPlayer).getInvulnerability(command, location.getWorld()));
                    if (MainConfig.get().APPLY_COOLDOWN_AFTER.get().equalsIgnoreCase("teleport")) {
                        CooldownManager.addToCooldown(command, payingPlayer, location.getWorld());
                    }
                });
                movement.remove(uuid);
            }
        };
        movement.put(uuid, movementTimer);
        movementTimer.runTaskLater((Plugin)CoreClass.getInstance(), (long)warmUp * 20L);
        if (MainConfig.get().CANCEL_WARM_UP_ON_MOVEMENT.get().booleanValue() && !teleportingPlayer.hasPermission("at.admin.bypass.movement") || MainConfig.get().CANCEL_WARM_UP_ON_ROTATION.get().booleanValue() && !teleportingPlayer.hasPermission("at.admin.bypass.rotation")) {
            CustomMessages.sendMessage((CommandSender)teleportingPlayer, "Teleport.eventBeforeTP", new TagResolver[]{Placeholder.unparsed((String)"countdown", (String)String.valueOf(warmUp)), Placeholder.component((String)"countdown-formatted", (ComponentLike)CustomMessages.toTime(warmUp))});
        } else {
            CustomMessages.sendMessage((CommandSender)teleportingPlayer, "Teleport.eventBeforeTPMovementAllowed", new TagResolver[]{Placeholder.unparsed((String)"countdown", (String)String.valueOf(warmUp)), Placeholder.component((String)"countdown-formatted", (ComponentLike)CustomMessages.toTime(warmUp))});
        }
    }

    public static abstract class ImprovedRunnable
    extends BukkitRunnable {
        private final String command;

        ImprovedRunnable(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

