/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InvulnerabilityManager {
    public static void createInvulnerability(Player player, int duration) {
        DamageListener damage = new DamageListener(player);
        Bukkit.getScheduler().runTaskLater((Plugin)CoreClass.getInstance(), task -> damage.destroy(), (long)duration * 20L);
    }

    private static class DamageListener
    implements Listener {
        @NotNull
        private final Player player;

        public DamageListener(@NotNull Player player) {
            this.player = player;
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CoreClass.getInstance());
        }

        @EventHandler
        public void onDamage(EntityDamageEvent event) {
            if (event.getEntity() != this.player) {
                return;
            }
            if (MainConfig.get().INVULNERABILITY_DAMAGE_BLACKLIST.get().contains(event.getCause().name())) {
                return;
            }
            event.setCancelled(true);
        }

        protected void destroy() {
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

