/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CooldownManager {
    private static final HashMap<String, List<ATRunnable>> cooldown = new HashMap();

    public static int secondsLeftOnCooldown(String command, Player player) {
        if (player.hasPermission("at.admin.bypass.cooldown")) {
            return 0;
        }
        List<ATRunnable> list = cooldown.get(CooldownManager.getKey(command));
        if (list == null) {
            return 0;
        }
        for (ATRunnable runnable : list) {
            if (!runnable.uuid.toString().equals(player.getUniqueId().toString())) continue;
            return (int)Math.ceil((double)(runnable.startingTime + runnable.ms * 1000L - System.currentTimeMillis()) / 1000.0);
        }
        return 0;
    }

    public static void addToCooldown(String command, Player player, World toWorld) {
        List<ATRunnable> list = cooldown.get(CooldownManager.getKey(command));
        ATPlayer atPlayer = ATPlayer.getPlayer(player);
        list.add(new ATRunnable(player.getUniqueId(), atPlayer.getCooldown(command, toWorld), command));
        cooldown.put(CooldownManager.getKey(command), list);
    }

    private static String getKey(String command) {
        return MainConfig.get().APPLY_COOLDOWN_TO_ALL_COMMANDS.get() != false ? "all" : command;
    }

    public static void init() {
        cooldown.clear();
        if (MainConfig.get().APPLY_COOLDOWN_TO_ALL_COMMANDS.get().booleanValue()) {
            cooldown.put("all", new ArrayList());
        } else {
            for (String command : Arrays.asList("tpa", "tpahere", "tpr", "warp", "spawn", "home", "back")) {
                cooldown.put(command, new ArrayList());
            }
        }
    }

    public static class ATRunnable
    extends BukkitRunnable {
        private final UUID uuid;
        private final long startingTime;
        private final String command;
        private long ms;

        public ATRunnable(UUID uuid, long waitingTime, String command) {
            this.uuid = uuid;
            this.ms = waitingTime;
            if (MainConfig.get().ADD_COOLDOWN_DURATION_TO_WARM_UP.get().booleanValue() && !Bukkit.getPlayer((UUID)uuid).hasPermission("at.admin.bypass.timer")) {
                this.ms += (long)MainConfig.get().WARM_UPS.valueOf(command).get().intValue();
            }
            this.command = CooldownManager.getKey(command);
            this.startingTime = System.currentTimeMillis();
            this.runTaskLater((Plugin)CoreClass.getInstance());
        }

        public synchronized BukkitTask runTaskLater(Plugin plugin) throws IllegalArgumentException, IllegalStateException {
            return super.runTaskLater(plugin, this.ms * 20L);
        }

        public void run() {
            List<ATRunnable> list = cooldown.get(this.command);
            list.remove((Object)this);
        }
    }
}

