/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.managers;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.commands.ATCommand;
import io.github.niestrat99.advancedteleport.commands.CoreCommand;
import io.github.niestrat99.advancedteleport.commands.SubATCommand;
import io.github.niestrat99.advancedteleport.commands.core.ClearCacheCommand;
import io.github.niestrat99.advancedteleport.commands.core.ExportCommand;
import io.github.niestrat99.advancedteleport.commands.core.HelpCommand;
import io.github.niestrat99.advancedteleport.commands.core.ImportCommand;
import io.github.niestrat99.advancedteleport.commands.core.InfoCommand;
import io.github.niestrat99.advancedteleport.commands.core.MapCommand;
import io.github.niestrat99.advancedteleport.commands.core.ParticlesCommand;
import io.github.niestrat99.advancedteleport.commands.core.PurgeCommand;
import io.github.niestrat99.advancedteleport.commands.core.ReloadCommand;
import io.github.niestrat99.advancedteleport.commands.home.DelHomeCommand;
import io.github.niestrat99.advancedteleport.commands.home.HomeCommand;
import io.github.niestrat99.advancedteleport.commands.home.HomesCommand;
import io.github.niestrat99.advancedteleport.commands.home.MoveHomeCommand;
import io.github.niestrat99.advancedteleport.commands.home.SetHomeCommand;
import io.github.niestrat99.advancedteleport.commands.home.SetMainHomeCommand;
import io.github.niestrat99.advancedteleport.commands.spawn.MirrorSpawn;
import io.github.niestrat99.advancedteleport.commands.spawn.RemoveSpawn;
import io.github.niestrat99.advancedteleport.commands.spawn.SetMainSpawn;
import io.github.niestrat99.advancedteleport.commands.spawn.SetSpawn;
import io.github.niestrat99.advancedteleport.commands.spawn.SpawnCommand;
import io.github.niestrat99.advancedteleport.commands.teleport.Back;
import io.github.niestrat99.advancedteleport.commands.teleport.ToggleTP;
import io.github.niestrat99.advancedteleport.commands.teleport.TpAll;
import io.github.niestrat99.advancedteleport.commands.teleport.TpBlockCommand;
import io.github.niestrat99.advancedteleport.commands.teleport.TpCancel;
import io.github.niestrat99.advancedteleport.commands.teleport.TpHereOffline;
import io.github.niestrat99.advancedteleport.commands.teleport.TpList;
import io.github.niestrat99.advancedteleport.commands.teleport.TpLoc;
import io.github.niestrat99.advancedteleport.commands.teleport.TpNo;
import io.github.niestrat99.advancedteleport.commands.teleport.TpOff;
import io.github.niestrat99.advancedteleport.commands.teleport.TpOffline;
import io.github.niestrat99.advancedteleport.commands.teleport.TpOn;
import io.github.niestrat99.advancedteleport.commands.teleport.TpUnblock;
import io.github.niestrat99.advancedteleport.commands.teleport.TpYes;
import io.github.niestrat99.advancedteleport.commands.teleport.Tpa;
import io.github.niestrat99.advancedteleport.commands.teleport.TpaHere;
import io.github.niestrat99.advancedteleport.commands.teleport.Tpo;
import io.github.niestrat99.advancedteleport.commands.teleport.TpoHere;
import io.github.niestrat99.advancedteleport.commands.teleport.Tpr;
import io.github.niestrat99.advancedteleport.commands.warp.DeleteWarpCommand;
import io.github.niestrat99.advancedteleport.commands.warp.MoveWarpCommand;
import io.github.niestrat99.advancedteleport.commands.warp.SetWarpCommand;
import io.github.niestrat99.advancedteleport.commands.warp.WarpCommand;
import io.github.niestrat99.advancedteleport.commands.warp.WarpsCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private static final LinkedHashMap<String, PluginCommand> atCommands = new LinkedHashMap();
    public static final LinkedHashMap<String, SubATCommand> subcommands = new LinkedHashMap();
    public static final LinkedHashMap<String, PluginCommand> registeredCommands = new LinkedHashMap();

    public static void registerCommands() {
        CommandManager.register("at", new CoreCommand());
        CommandManager.register("back", new Back());
        CommandManager.register("toggletp", new ToggleTP());
        CommandManager.register("tpa", new Tpa());
        CommandManager.register("tpahere", new TpaHere());
        CommandManager.register("tpall", new TpAll());
        CommandManager.register("tpblock", new TpBlockCommand());
        CommandManager.register("tpcancel", new TpCancel());
        CommandManager.register("tpalist", new TpList());
        CommandManager.register("tploc", new TpLoc());
        CommandManager.register("tpno", new TpNo());
        CommandManager.register("tpo", new Tpo());
        CommandManager.register("tpoff", new TpOff());
        CommandManager.register("tpohere", new TpoHere());
        CommandManager.register("tpon", new TpOn());
        CommandManager.register("tpr", new Tpr());
        CommandManager.register("tpunblock", new TpUnblock());
        CommandManager.register("tpyes", new TpYes());
        CommandManager.register("tpoffline", new TpOffline());
        CommandManager.register("tpofflinehere", new TpHereOffline());
        CommandManager.register("home", new HomeCommand());
        CommandManager.register("sethome", new SetHomeCommand());
        CommandManager.register("delhome", new DelHomeCommand());
        CommandManager.register("homes", new HomesCommand());
        CommandManager.register("movehome", new MoveHomeCommand());
        CommandManager.register("setmainhome", new SetMainHomeCommand());
        CommandManager.register("warp", new WarpCommand());
        CommandManager.register("setwarp", new SetWarpCommand());
        CommandManager.register("delwarp", new DeleteWarpCommand());
        CommandManager.register("movewarp", new MoveWarpCommand());
        CommandManager.register("warps", new WarpsCommand());
        CommandManager.register("spawn", new SpawnCommand());
        CommandManager.register("setspawn", new SetSpawn());
        CommandManager.register("mirrorspawn", new MirrorSpawn());
        CommandManager.register("removespawn", new RemoveSpawn());
        CommandManager.register("setmainspawn", new SetMainSpawn());
        subcommands.put("clearcache", new ClearCacheCommand());
        subcommands.put("import", new ImportCommand());
        subcommands.put("help", new HelpCommand());
        subcommands.put("reload", new ReloadCommand());
        subcommands.put("info", new InfoCommand());
        subcommands.put("export", new ExportCommand());
        subcommands.put("purge", new PurgeCommand());
        subcommands.put("particles", new ParticlesCommand());
        subcommands.put("map", new MapCommand());
        CommandManager.syncCommands();
    }

    private static void register(String name, ATCommand atCommand) {
        PluginCommand command = Bukkit.getPluginCommand((String)("advancedteleport:" + name));
        CoreClass.debug("Fetching " + String.valueOf(command) + " - " + String.valueOf(command));
        if (command == null) {
            command = atCommands.get(name);
        }
        if (command == null) {
            CoreClass.getInstance().getLogger().warning("Could not add command " + name + " - has it been set up properly?");
            return;
        }
        atCommands.put(name, command);
        CommandMap map = CommandManager.getMap();
        if (map == null) {
            return;
        }
        HashMap<String, Command> commands = CommandManager.getCommands(map);
        if (commands == null) {
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>(command.getAliases());
        aliases.add(command.getName());
        boolean removed = false;
        for (String alias : aliases) {
            if (!MainConfig.get().DISABLED_COMMANDS.get().contains(alias) && !removed && atCommand.getRequiredFeature()) continue;
            CoreClass.debug(alias + " has been marked for removal.");
            if (!command.isRegistered()) continue;
            removed = true;
            command.unregister(map);
        }
        if (removed) {
            for (String alias : aliases) {
                commands.remove(alias);
                commands.remove("advancedteleport:" + alias);
                CoreClass.debug("Removed " + alias + ".");
                Bukkit.getScheduler().runTaskLater((Plugin)CoreClass.getInstance(), () -> {
                    Iterator commandIterator = commands.keySet().iterator();
                    HashMap<String, Command> pendingChanges = new HashMap<String, Command>();
                    while (commandIterator.hasNext()) {
                        String otherCmd = (String)commandIterator.next();
                        String[] parts = otherCmd.split(":");
                        if (parts.length < 2 || !parts[1].equals(alias) || parts[0].equals("advancedteleport")) continue;
                        CoreClass.debug("Letting " + parts[0] + "'s " + alias + " take over...");
                        pendingChanges.put(alias, (Command)commands.get(otherCmd));
                        break;
                    }
                    commands.putAll(pendingChanges);
                }, 100L);
            }
            return;
        }
        if (!command.isRegistered()) {
            command.register(map);
            commands.put(name, (Command)command);
            commands.put("advancedteleport:" + name, (Command)command);
            for (String alias : aliases) {
                commands.put(alias, (Command)command);
                commands.put("advancedteleport:" + alias, (Command)command);
            }
        }
        if (command.getExecutor() != atCommand) {
            CommandExecutor usageExecutor = (sender, cmd, label, args) -> {
                boolean result = atCommand.onCommand(sender, cmd, label, args);
                if (!result) {
                    CustomMessages.sendMessage(sender, "Error.commandUse", new TagResolver[]{Placeholder.unparsed((String)"usage", (String)CustomMessages.asString("Usages." + name))});
                }
                return true;
            };
            command.setExecutor(usageExecutor);
            command.setTabCompleter((TabCompleter)atCommand);
        }
        CoreClass.debug(String.valueOf(aliases) + " has " + (command.isRegistered() ? "" : "not ") + "been registed successfully.");
        registeredCommands.put(name, command);
    }

    private static CommandMap getMap() {
        try {
            Method map = Bukkit.getServer().getClass().getDeclaredMethod("getCommandMap", new Class[0]);
            return (CommandMap)map.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static HashMap<String, Command> getCommands(CommandMap map) {
        try {
            Field commands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            commands.setAccessible(true);
            return (HashMap)commands.get(map);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void syncCommands() {
        try {
            Method method = Bukkit.getServer().getClass().getDeclaredMethod("syncCommands", new Class[0]);
            method.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

