/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.listeners.spigot;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.jetbrains.annotations.NotNull;

public class SpigotSignChangeListener
implements Listener {
    @EventHandler
    public void onSignChange(@NotNull SignChangeEvent event) {
        Block block = event.getBlock();
        BlockState state = block.getState();
        Player player = event.getPlayer();
        if (!(state instanceof Sign)) {
            return;
        }
        String line = event.getLine(0);
        CoreClass.debug("First line of the sign: " + line);
        if (line == null) {
            return;
        }
        ATSign atSign = AdvancedTeleportAPI.getSignByFlatDisplayName(Component.text((String)line));
        CoreClass.debug("Sign found: " + String.valueOf(atSign));
        if (atSign == null) {
            return;
        }
        CoreClass.debug("Is sign enabled: " + atSign.isEnabled());
        CoreClass.debug("Does player have permission to create the sign: " + player.hasPermission(atSign.getAdminPermission()));
        CoreClass.debug("Can player create the sign regardless of permission: " + atSign.canCreate(event.getLines(), player));
        if (!atSign.isEnabled()) {
            return;
        }
        if (player.hasPermission(atSign.getAdminPermission())) {
            if (!atSign.canCreate(event.getLines(), player)) {
                return;
            }
            event.setLine(0, LegacyComponentSerializer.legacySection().serialize(atSign.getDisplayName()));
        } else {
            CustomMessages.sendMessage((CommandSender)player, "Error.noPermissionSign", new TagResolver[0]);
            event.setCancelled(true);
        }
    }
}

