/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.listeners.paper;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.jetbrains.annotations.NotNull;

public class PaperSignChangeListener
implements Listener {
    @EventHandler
    public void onSignChange(@NotNull SignChangeEvent event) {
        Block block = event.getBlock();
        BlockState state = block.getState();
        Player player = event.getPlayer();
        CoreClass.debug("SignChangeEvent fired, first of all, is it a sign?: " + (state instanceof Sign));
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        Component line = event.line(0);
        CoreClass.debug("Line 1: " + String.valueOf(line));
        if (!(line instanceof TextComponent)) {
            return;
        }
        TextComponent component = (TextComponent)line;
        ATSign atSign = AdvancedTeleportAPI.getSignByFlatDisplayName(component);
        CoreClass.debug("Sign obtained: " + String.valueOf(atSign));
        if (atSign == null) {
            return;
        }
        CoreClass.debug("Is the sign enabled?: " + atSign.isEnabled());
        CoreClass.debug("Does the player have permission to create the sign?: " + player.hasPermission(atSign.getAdminPermission()));
        if (!atSign.isEnabled()) {
            return;
        }
        if (player.hasPermission(atSign.getAdminPermission())) {
            boolean result = atSign.canCreate(event.lines(), player);
            CoreClass.debug("Can the player create the sign regardless of permission?: " + result);
            if (!result) {
                return;
            }
            event.line(0, atSign.getDisplayName());
        } else {
            CustomMessages.sendMessage((CommandSender)player, "Error.noPermissionSign", new TagResolver[0]);
            event.setCancelled(true);
        }
    }
}

