/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.listeners.paper;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATSign;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.managers.CooldownManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PaperLegacySignListener
implements Listener {
    @EventHandler
    public void onSignInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        BlockState blockState = clickedBlock.getState();
        CoreClass.debug("Block interaction detected for " + player.getName() + ", is it a sign: " + (blockState instanceof Sign));
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        ATSign atSign = AdvancedTeleportAPI.getSignByDisplayName(sign.line(0));
        CoreClass.debug("Obtained sign: " + String.valueOf(atSign));
        if (atSign != null) {
            CoreClass.debug("Is sign enabled: " + atSign.isEnabled());
        }
        if (atSign == null || !atSign.isEnabled()) {
            return;
        }
        CoreClass.debug("Does player have permission to use the sign: " + player.hasPermission(atSign.getRequiredPermission()));
        if (!player.hasPermission(atSign.getRequiredPermission())) {
            return;
        }
        int cooldown = CooldownManager.secondsLeftOnCooldown(atSign.getName().toLowerCase(), player);
        if (cooldown > 0) {
            CustomMessages.sendMessage((CommandSender)player, "Error.onCooldown", new TagResolver[]{Placeholder.unparsed((String)"time", (String)String.valueOf(cooldown))});
            return;
        }
        atSign.onInteract(sign, player);
    }
}

