/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.listeners;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.managers.MovementManager;
import io.github.niestrat99.advancedteleport.managers.ParticleManager;
import io.github.niestrat99.advancedteleport.sql.PlayerSQLManager;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerListeners
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        ATPlayer.relog(event.getPlayer());
        PlayerSQLManager.get().updatePlayerData((OfflinePlayer)event.getPlayer());
        if (!MainConfig.get().NOTIFY_ADMINS.get().booleanValue()) {
            return;
        }
        if (!event.getPlayer().hasPermission("at.admin.notify")) {
            return;
        }
        if (CoreClass.getInstance().getUpdateInfo() == null) {
            return;
        }
        String title = (String)CoreClass.getInstance().getUpdateInfo()[1];
        String newVersion = (String)CoreClass.getInstance().getUpdateInfo()[0];
        String currentVersion = CoreClass.getInstance().getDescription().getVersion();
        CustomMessages.sendMessage((CommandSender)event.getPlayer(), "Info.updateInfo", new TagResolver[]{Placeholder.unparsed((String)"version", (String)currentVersion), Placeholder.unparsed((String)"new-version", (String)newVersion), Placeholder.unparsed((String)"title", (String)title)});
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerLeave(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (player.hasMetadata("NPC")) {
            return;
        }
        ATPlayer.removePlayer(player);
        if (MovementManager.getMovement().containsKey(player.getUniqueId())) {
            MovementManager.ImprovedRunnable runnable = MovementManager.getMovement().get(player.getUniqueId());
            ParticleManager.removeParticles(event.getPlayer(), runnable.getCommand());
        }
    }
}

