/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.limitations.worlds;

import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.limitations.worlds.WorldRule;
import io.github.niestrat99.advancedteleport.limitations.worlds.list.StopIntoRule;
import io.github.niestrat99.advancedteleport.limitations.worlds.list.StopOutOfRule;
import io.github.niestrat99.advancedteleport.limitations.worlds.list.StopWithinRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WorldRulesManager {
    private final HashMap<String, List<WorldRule>> rules = new HashMap();

    public WorldRulesManager() {
        ConfigSection worlds = MainConfig.get().WORLD_RULES.get();
        for (String world : worlds.getKeys(false)) {
            this.addWorld(world, worlds.getString(world));
        }
    }

    private void addWorld(String world, String rulesRaw) {
        String[] rules = rulesRaw.split(";");
        ArrayList<WorldRule> ruleList = new ArrayList<WorldRule>();
        for (String rule : rules) {
            if (rule.startsWith("stop-teleportation-out")) {
                ruleList.add(new StopOutOfRule(rule.replaceFirst("stop-teleportation-out", "")));
                continue;
            }
            if (rule.startsWith("stop-teleportation-within")) {
                ruleList.add(new StopWithinRule(rule.replaceFirst("stop-teleportation-within", "")));
                continue;
            }
            if (!rule.startsWith("stop-teleportation-into")) continue;
            ruleList.add(new StopIntoRule(rule.replaceFirst("stop-teleportation-into", "")));
        }
        this.rules.put(world, ruleList);
    }

    public boolean canTeleport(Player player, Location toLoc) {
        String world = player.getLocation().getWorld().getName();
        List<WorldRule> rulesFromWorld = this.rules.getOrDefault(world, this.rules.get("default"));
        List<WorldRule> rulesToWorld = this.rules.getOrDefault(toLoc.getWorld().getName(), this.rules.get("default"));
        if (rulesFromWorld != null && !rulesFromWorld.isEmpty()) {
            for (WorldRule rule : rulesFromWorld) {
                if (rule instanceof StopIntoRule || rule.canTeleport(player, toLoc)) continue;
                return false;
            }
        }
        if (rulesToWorld != null && !rulesToWorld.isEmpty()) {
            for (WorldRule rule : rulesToWorld) {
                if (!(rule instanceof StopIntoRule) || rule.canTeleport(player, toLoc)) continue;
                return false;
            }
        }
        return true;
    }
}

