/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.limitations.commands;

import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.limitations.commands.CommandRule;
import io.github.niestrat99.advancedteleport.limitations.commands.list.IgnoreRule;
import io.github.niestrat99.advancedteleport.limitations.commands.list.OverrideRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class CommandRuleManager {
    private final HashMap<String, List<CommandRule>> rules = new HashMap();

    public CommandRuleManager() {
        for (String command : Arrays.asList("tpa", "tpahere", "tpr", "warp", "spawn", "home", "back")) {
            this.addCommand(command, MainConfig.get().COMMAND_RULES.valueOf(command).get());
        }
    }

    private void addCommand(@NotNull String command, @NotNull String rulesRaw) {
        String[] rules = rulesRaw.split(";");
        ArrayList<CommandRule> ruleList = new ArrayList<CommandRule>();
        for (String rule : rules) {
            if (rule.startsWith("override")) {
                ruleList.add(new OverrideRule(rule.replaceFirst("override", "")));
                continue;
            }
            if (!rule.startsWith("ignore")) continue;
            ruleList.add(new IgnoreRule(rule.replaceFirst("ignore", "")));
        }
        this.rules.put(command, ruleList);
    }

    public int canTeleport(@NotNull Player player, @NotNull Location toLoc, @NotNull String command) {
        List<CommandRule> commandRules = this.rules.get(command);
        if (commandRules == null) {
            return 0;
        }
        for (CommandRule rule : commandRules) {
            if (rule instanceof IgnoreRule) {
                if (rule.canTeleport(player, toLoc)) continue;
                return -1;
            }
            if (!(rule instanceof OverrideRule) || !rule.canTeleport(player, toLoc)) continue;
            return 1;
        }
        return 0;
    }
}

