/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver.strategy;

import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.strategy.PathResolutionStrategy;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Repositories;
import java.util.Arrays;
import java.util.Collection;

public final class MavenSnapshotPathResolutionStrategy
implements PathResolutionStrategy {
    private static final String PATH_FORMAT_ALT = "%s%s/%s/%s-SNAPSHOT/%4$s-%s/%3$s-%4$s-%5$s.jar";
    private static final String PATH_FORMAT = "%s%s/%s/%s-SNAPSHOT/%3$s-%4$s-%5$s.jar";

    @Override
    public Collection<String> pathTo(Repository repository, Dependency dependency) {
        String repoUrl = Repositories.fetchFormattedUrl(repository);
        String version = dependency.version().replace("-SNAPSHOT", "");
        String alt = String.format(PATH_FORMAT_ALT, repoUrl, dependency.groupId().replace('.', '/'), dependency.artifactId(), version, dependency.snapshotId());
        String general = String.format(PATH_FORMAT, repoUrl, dependency.groupId().replace('.', '/'), dependency.artifactId(), version, dependency.snapshotId());
        return Arrays.asList(general, alt);
    }
}

