/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.facade;

import io.github.niestrat99.advancedteleport.libs.slimjar.app.builder.ApplicationBuilder;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.InjectableClassLoader;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.PassthroughRelocator;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.facade.GsonFacade;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.facade.GsonFacadeFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.facade.ReflectiveGsonFacade;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Packages;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;

public final class ReflectiveGsonFacadeFactory
implements GsonFacadeFactory {
    private static final String GSON_PACKAGE = "com#google#gson#Gson";
    private static final String GSON_TYPES_PACKAGE = "com#google#gson#internal#$Gson$Types";
    private final Constructor<?> gsonConstructor;
    private final Method gsonFromJsonMethod;
    private final Method gsonFromJsonTypeMethod;
    private final Method canonicalizeMethod;

    private ReflectiveGsonFacadeFactory(Constructor<?> gsonConstructor, Method gsonFromJsonMethod, Method gsonFromJsonTypeMethod, Method canonicalizeMethod) {
        this.gsonConstructor = gsonConstructor;
        this.gsonFromJsonMethod = gsonFromJsonMethod;
        this.gsonFromJsonTypeMethod = gsonFromJsonTypeMethod;
        this.canonicalizeMethod = canonicalizeMethod;
    }

    @Override
    public GsonFacade createFacade() throws ReflectiveOperationException {
        Object gson = this.gsonConstructor.newInstance(new Object[0]);
        return new ReflectiveGsonFacade(gson, this.gsonFromJsonMethod, this.gsonFromJsonTypeMethod, this.canonicalizeMethod);
    }

    public static GsonFacadeFactory create(Path downloadPath, Collection<Repository> repositories) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException, InterruptedException {
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        return ReflectiveGsonFacadeFactory.create(downloadPath, repositories, classLoader);
    }

    public static GsonFacadeFactory create(Path downloadPath, Collection<Repository> repositories, InjectableClassLoader classLoader) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException, InterruptedException {
        ApplicationBuilder.injecting("SlimJar", classLoader).downloadDirectoryPath(downloadPath).dataProviderFactory(url -> () -> ReflectiveGsonFacadeFactory.getGsonDependency(repositories)).relocatorFactory(rules -> new PassthroughRelocator()).preResolutionDataProviderFactory(a -> Collections::emptyMap).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        Class<?> gsonClass = Class.forName(Packages.fix(GSON_PACKAGE), true, classLoader);
        Constructor<?> gsonConstructor = gsonClass.getConstructor(new Class[0]);
        Method gsonFromJsonMethod = gsonClass.getMethod("fromJson", Reader.class, Class.class);
        Method gsonFromJsonTypeMethod = gsonClass.getMethod("fromJson", Reader.class, Type.class);
        Class<?> gsonTypesClass = Class.forName(Packages.fix(GSON_TYPES_PACKAGE), true, classLoader);
        Method canonicalizeMethod = gsonTypesClass.getMethod("canonicalize", Type.class);
        return new ReflectiveGsonFacadeFactory(gsonConstructor, gsonFromJsonMethod, gsonFromJsonTypeMethod, canonicalizeMethod);
    }

    private static DependencyData getGsonDependency(Collection<Repository> repositories) {
        Dependency gson = new Dependency(Packages.fix("com#google#code#gson"), "gson", "2.8.6", null, Collections.emptyList());
        return new DependencyData(Collections.emptySet(), repositories, Collections.singleton(gson), Collections.emptyList());
    }
}

