/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.dependency;

import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.reader.dependency.DependencyReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public final class ModuleDependencyDataProvider
implements DependencyDataProvider {
    private final DependencyReader dependencyReader;
    private final URL moduleUrl;

    public ModuleDependencyDataProvider(DependencyReader dependencyReader, URL moduleUrl) {
        this.dependencyReader = dependencyReader;
        this.moduleUrl = moduleUrl;
    }

    @Override
    public DependencyData get() throws IOException, ReflectiveOperationException {
        URL depFileURL = this.getURL();
        URLConnection connection = depFileURL.openConnection();
        if (!(connection instanceof JarURLConnection)) {
            throw new AssertionError((Object)"Invalid Module URL provided(Non-Jar File)");
        }
        JarURLConnection jarURLConnection = (JarURLConnection)connection;
        JarFile jarFile = jarURLConnection.getJarFile();
        ZipEntry dependencyFileEntry = jarFile.getEntry("slimjar.json");
        if (dependencyFileEntry == null) {
            return new DependencyData(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        }
        try (InputStream inputStream = jarFile.getInputStream(dependencyFileEntry);){
            DependencyData dependencyData = this.dependencyReader.read(inputStream);
            return dependencyData;
        }
    }

    public URL getURL() throws MalformedURLException {
        return new URL("jar:file:" + this.moduleUrl.getFile() + "!/slimjar.json");
    }
}

