/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver.pinger;

import io.github.niestrat99.advancedteleport.libs.slimjar.logging.LogDispatcher;
import io.github.niestrat99.advancedteleport.libs.slimjar.logging.ProcessLogger;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.pinger.URLPinger;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;

public final class HttpURLPinger
implements URLPinger {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private static final String SLIMJAR_USER_AGENT = "SlimjarApplication/* URL Validation Ping";
    private static final Collection<String> SUPPORTED_PROTOCOLS = Arrays.asList("HTTP", "HTTPS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ping(URL url) {
        String urlStr = url.toString();
        LOGGER.debug("Pinging %s", urlStr);
        if (!this.isSupported(url)) {
            LOGGER.debug("Protocol not supported for %s", url.toString());
            return false;
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.addRequestProperty("User-Agent", SLIMJAR_USER_AGENT);
            connection.connect();
            boolean result = connection.getResponseCode() == 200;
            LOGGER.debug("Ping %s for %s", result ? "successful" : "failed", url.toString());
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("Ping failed for %s", url.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    @Override
    public boolean isSupported(URL url) {
        String protocol = url.getProtocol().toUpperCase(Locale.ENGLISH);
        return SUPPORTED_PROTOCOLS.contains(protocol);
    }
}

