/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.resolver;

import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import java.net.URL;
import java.util.Objects;

public final class ResolutionResult {
    private final Repository repository;
    private final URL dependencyURL;
    private final URL checksumURL;
    private final boolean isAggregator;
    private transient boolean checked;

    public ResolutionResult(Repository repository, URL dependencyURL, URL checksumURL, boolean isAggregator, boolean checked) {
        this.repository = repository;
        this.dependencyURL = dependencyURL;
        this.checksumURL = checksumURL;
        this.isAggregator = isAggregator;
        this.checked = checked;
        if (!isAggregator) {
            Objects.requireNonNull(dependencyURL, "Resolved URL must not be null for non-aggregator dependencies");
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public URL getDependencyURL() {
        return this.dependencyURL;
    }

    public URL getChecksumURL() {
        return this.checksumURL;
    }

    public boolean isAggregator() {
        return this.isAggregator;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked() {
        this.checked = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionResult that = (ResolutionResult)o;
        return this.dependencyURL.toString().equals(that.toString()) && Objects.equals(this.checksumURL.toString(), that.checksumURL.toString()) && this.isAggregator == that.isAggregator && this.checked == that.checked;
    }

    public int hashCode() {
        return Objects.hash(this.dependencyURL.toString(), this.checksumURL.toString(), this.isAggregator, this.checked);
    }
}

