/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.relocation;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public final class RelocationRule {
    private final String originalPackagePattern;
    private final String relocatedPackagePattern;
    private final Collection<String> exclusions;
    private final Collection<String> inclusions;

    public RelocationRule(String original, String relocated, Collection<String> exclusions, Collection<String> inclusions) {
        this.originalPackagePattern = original;
        this.relocatedPackagePattern = relocated;
        this.exclusions = exclusions;
        this.inclusions = inclusions;
    }

    public RelocationRule(String original, String relocated) {
        this(original, relocated, Collections.emptyList(), Collections.emptyList());
    }

    public String getOriginalPackagePattern() {
        return this.originalPackagePattern;
    }

    public String getRelocatedPackagePattern() {
        return this.relocatedPackagePattern;
    }

    public Collection<String> getExclusions() {
        return this.exclusions;
    }

    public Collection<String> getInclusions() {
        return this.inclusions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelocationRule that = (RelocationRule)o;
        return this.originalPackagePattern.equals(that.originalPackagePattern) && this.relocatedPackagePattern.equals(that.relocatedPackagePattern);
    }

    public int hashCode() {
        return Objects.hash(this.originalPackagePattern, this.relocatedPackagePattern);
    }

    public String toString() {
        return "RelocationRule{originalPackagePattern='" + this.originalPackagePattern + "', relocatedPackagePattern='" + this.relocatedPackagePattern + "'}";
    }
}

