/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader;

import io.github.niestrat99.advancedteleport.libs.slimjar.injector.agent.ByteBuddyInstrumentationFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.agent.InstrumentationFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.Injectable;
import io.github.niestrat99.advancedteleport.libs.slimjar.relocation.facade.ReflectiveJarRelocatorFacadeFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Repository;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.jar.JarFile;

public final class InstrumentationInjectable
implements Injectable {
    private final Instrumentation instrumentation;

    public InstrumentationInjectable(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    @Override
    public void inject(URL url) throws IOException, URISyntaxException {
        this.instrumentation.appendToSystemClassLoaderSearch(new JarFile(new File(url.toURI())));
    }

    public static Injectable create(Path downloadPath, Collection<Repository> repositories) throws IOException, NoSuchAlgorithmException, ReflectiveOperationException, URISyntaxException, InterruptedException {
        return InstrumentationInjectable.create(new ByteBuddyInstrumentationFactory(ReflectiveJarRelocatorFacadeFactory.create(downloadPath, repositories)));
    }

    public static Injectable create(InstrumentationFactory factory) throws IOException, NoSuchAlgorithmException, ReflectiveOperationException, URISyntaxException, InterruptedException {
        return new InstrumentationInjectable(factory.create());
    }
}

