/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.injector;

import io.github.niestrat99.advancedteleport.libs.slimjar.injector.DependencyInjector;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.InjectionFailedException;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.helper.InjectionHelper;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.helper.InjectionHelperFactory;
import io.github.niestrat99.advancedteleport.libs.slimjar.injector.loader.Injectable;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.ResolutionResult;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.Dependency;
import io.github.niestrat99.advancedteleport.libs.slimjar.resolver.data.DependencyData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class SimpleDependencyInjector
implements DependencyInjector {
    private final InjectionHelperFactory injectionHelperFactory;
    private final List<Dependency> processingDependencies = Collections.synchronizedList(new ArrayList());

    public SimpleDependencyInjector(InjectionHelperFactory injectionHelperFactory) {
        this.injectionHelperFactory = injectionHelperFactory;
    }

    @Override
    public void inject(Injectable injectable, DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        InjectionHelper helper = this.injectionHelperFactory.create(data, preResolvedResults);
        this.injectDependencies(injectable, helper, data.dependencies());
    }

    private void injectDependencies(Injectable injectable, InjectionHelper injectionHelper, Collection<Dependency> dependencies) throws RuntimeException {
        dependencies.stream().filter(dependency -> !injectionHelper.isInjected((Dependency)dependency)).forEach(dependency -> {
            if (this.processingDependencies.contains(dependency)) {
                return;
            }
            this.processingDependencies.add((Dependency)dependency);
            try {
                File depJar = injectionHelper.fetch((Dependency)dependency);
                if (depJar == null) {
                    return;
                }
                injectable.inject(depJar.toURI().toURL());
                this.injectDependencies(injectable, injectionHelper, dependency.transitive());
            }
            catch (IOException e) {
                throw new InjectionFailedException((Dependency)dependency, e);
            }
            catch (IllegalAccessException | InvocationTargetException | URISyntaxException e) {
                e.printStackTrace();
            }
            catch (InterruptedException | ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.processingDependencies.remove(dependency);
        });
    }
}

