/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output;

import io.github.niestrat99.advancedteleport.libs.slimjar.downloader.output.OutputWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ChanneledFileOutputWriter
implements OutputWriter {
    private static final Logger LOGGER = Logger.getLogger(ChanneledFileOutputWriter.class.getName());
    private final File outputFile;

    public ChanneledFileOutputWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public File writeFrom(InputStream inputStream, long length) throws IOException {
        LOGGER.log(Level.FINE, "Attempting to write from inputStream...");
        if (!this.outputFile.exists()) {
            LOGGER.log(Level.FINE, "Writing {0} bytes...", length == -1L ? "unknown" : Long.valueOf(length));
            Files.copy(inputStream, this.outputFile.toPath(), new CopyOption[0]);
        }
        inputStream.close();
        return this.outputFile;
    }
}

