/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.libs.slimjar.app.builder;

import io.github.niestrat99.advancedteleport.libs.slimjar.app.module.ModuleExtractor;
import io.github.niestrat99.advancedteleport.libs.slimjar.app.module.TemporaryModuleExtractor;
import io.github.niestrat99.advancedteleport.libs.slimjar.util.Modules;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class IsolationConfiguration {
    private final String applicationClass;
    private final Collection<String> modules;
    private final ClassLoader parentClassloader;
    private final ModuleExtractor moduleExtractor;

    public IsolationConfiguration(String applicationClass, Collection<String> modules, ClassLoader parentClassloader, ModuleExtractor moduleExtractor) {
        this.applicationClass = applicationClass;
        this.modules = Collections.unmodifiableCollection(modules);
        this.parentClassloader = parentClassloader;
        this.moduleExtractor = moduleExtractor;
    }

    public String getApplicationClass() {
        return this.applicationClass;
    }

    public Collection<String> getModules() {
        return this.modules;
    }

    public ClassLoader getParentClassloader() {
        return this.parentClassloader;
    }

    public ModuleExtractor getModuleExtractor() {
        return this.moduleExtractor;
    }

    public static Builder builder(String applicationClass) {
        return new Builder().applicationClass(applicationClass);
    }

    public static final class Builder {
        private String applicationClass;
        private Collection<String> modules = new HashSet<String>();
        private ClassLoader parentClassloader;
        private ModuleExtractor moduleExtractor;

        public Builder applicationClass(String applicationClass) {
            this.applicationClass = applicationClass;
            return this;
        }

        public Builder modules(Collection<String> modules) {
            HashSet<String> mod = new HashSet<String>(modules);
            mod.addAll(modules);
            this.modules = mod;
            return this;
        }

        public Builder module(String module) {
            this.modules.add(module);
            return this;
        }

        public Builder parentClassLoader(ClassLoader classLoader) {
            this.parentClassloader = classLoader;
            return this;
        }

        public Builder moduleExtractor(ModuleExtractor moduleExtractor) {
            this.moduleExtractor = moduleExtractor;
            return this;
        }

        String getApplicationClass() {
            if (this.applicationClass == null) {
                throw new AssertionError((Object)"Application Class not Provided!");
            }
            return this.applicationClass;
        }

        Collection<String> getModules() throws IOException, URISyntaxException {
            if (this.modules == null || this.modules.isEmpty()) {
                this.modules = Modules.findLocalModules();
            }
            return this.modules;
        }

        ClassLoader getParentClassloader() {
            if (this.parentClassloader == null) {
                this.parentClassloader = ClassLoader.getSystemClassLoader().getParent();
            }
            return this.parentClassloader;
        }

        ModuleExtractor getModuleExtractor() {
            if (this.moduleExtractor == null) {
                this.moduleExtractor = new TemporaryModuleExtractor();
            }
            return this.moduleExtractor;
        }

        public IsolationConfiguration build() throws IOException, URISyntaxException {
            return new IsolationConfiguration(this.getApplicationClass(), this.getModules(), this.getParentClassloader(), this.getModuleExtractor());
        }
    }
}

