/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.hooks.borders;

import com.wimbli.WorldBorder.BorderData;
import com.wimbli.WorldBorder.WorldBorder;
import io.github.niestrat99.advancedteleport.hooks.BorderPlugin;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class WorldBorderHook
extends BorderPlugin<WorldBorder, Void> {
    private WorldBorder worldBorder;

    @Contract(pure=true)
    public WorldBorderHook() {
        super("WorldBorder");
    }

    @Override
    @Contract(pure=true)
    public boolean canUse(@NotNull World world) {
        if (!super.canUse(world)) {
            return false;
        }
        return this.plugin().map(plugin -> {
            this.worldBorder = plugin;
            return this.worldBorder.getWorldBorder(world.getName()) != null;
        }).orElse(false);
    }

    @Override
    @Contract(pure=true)
    public double getMinX(@NotNull World world) {
        BorderData data = this.worldBorder.getWorldBorder(world.getName());
        return this.getCentre(world).getX() - (double)data.getRadiusX();
    }

    @Override
    @Contract(pure=true)
    public double getMinZ(@NotNull World world) {
        BorderData data = this.worldBorder.getWorldBorder(world.getName());
        return this.getCentre(world).getZ() - (double)data.getRadiusZ();
    }

    @Override
    @Contract(pure=true)
    public double getMaxX(@NotNull World world) {
        BorderData data = this.worldBorder.getWorldBorder(world.getName());
        return this.getCentre(world).getX() + (double)data.getRadiusX();
    }

    @Override
    @Contract(pure=true)
    public double getMaxZ(@NotNull World world) {
        BorderData data = this.worldBorder.getWorldBorder(world.getName());
        return this.getCentre(world).getZ() + (double)data.getRadiusZ();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Location getCentre(@NotNull World world) {
        BorderData data = this.worldBorder.getWorldBorder(world.getName());
        return new Location(world, data.getX(), 128.0, data.getZ());
    }
}

