/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.config;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.config.ATConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.Title;
import io.github.niestrat99.advancedteleport.limitations.LimitationsManager;
import io.github.niestrat99.advancedteleport.payments.PaymentManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public final class MainConfig
extends ATConfig {
    private static MainConfig instance;
    private static List<String> defaults;
    public ConfigOption<Boolean> USE_BASIC_TELEPORT_FEATURES;
    public ConfigOption<Boolean> USE_WARPS;
    public ConfigOption<Boolean> USE_RANDOMTP;
    public ConfigOption<Boolean> USE_SPAWN;
    public ConfigOption<Boolean> USE_HOMES;
    public ConfigOption<List<String>> DISABLED_COMMANDS;
    public ConfigOption<Integer> REQUEST_LIFETIME;
    public ConfigOption<Boolean> USE_MULTIPLE_REQUESTS;
    public ConfigOption<Boolean> NOTIFY_ON_EXPIRE;
    public ConfigOption<Integer> WARM_UP_TIMER_DURATION;
    public ConfigOption<Boolean> CANCEL_WARM_UP_ON_ROTATION;
    public ConfigOption<Boolean> CANCEL_WARM_UP_ON_MOVEMENT;
    public ConfigOption<Boolean> CANCEL_WARM_UP_ON_DAMAGE;
    public ConfigOption<Boolean> CHECK_EXACT_COORDINATES;
    public PerCommandOption<Integer> WARM_UPS;
    public ConfigOption<ConfigSection> CUSTOM_WARM_UPS;
    public ConfigOption<Boolean> BLINDNESS_ON_WARMUP;
    public ConfigOption<Integer> COOLDOWN_TIMER_DURATION;
    public ConfigOption<Boolean> ADD_COOLDOWN_DURATION_TO_WARM_UP;
    public ConfigOption<Boolean> APPLY_COOLDOWN_TO_ALL_COMMANDS;
    public ConfigOption<String> APPLY_COOLDOWN_AFTER;
    public PerCommandOption<Integer> COOLDOWNS;
    public ConfigOption<ConfigSection> CUSTOM_COOLDOWNS;
    public ConfigOption<Object> COST_AMOUNT;
    public PerCommandOption<Object> COSTS;
    public ConfigOption<ConfigSection> CUSTOM_COSTS;
    public ConfigOption<Integer> INVULNERABILITY_DURATION;
    public ConfigOption<List<String>> INVULNERABILITY_DAMAGE_BLACKLIST;
    public PerCommandOption<Integer> COMMAND_INVULNERABILITY_DURATIONS;
    public ConfigOption<ConfigSection> CUSTOM_INVULNERABILITY_DURATIONS;
    public ConfigOption<Boolean> USE_PARTICLES;
    public PerCommandOption<String> TELEPORT_PARTICLES;
    public PerCommandOption<String> POST_TELEPORT_PARTICLES;
    public PerCommandOption<String> WAITING_PARTICLES;
    public ConfigOption<Boolean> USE_MYSQL;
    public ConfigOption<String> MYSQL_HOST;
    public ConfigOption<Integer> MYSQL_PORT;
    public ConfigOption<String> MYSQL_DATABASE;
    public ConfigOption<String> USERNAME;
    public ConfigOption<String> PASSWORD;
    public ConfigOption<String> TABLE_PREFIX;
    public ConfigOption<Boolean> USE_SSL;
    public ConfigOption<Boolean> AUTO_RECONNECT;
    public ConfigOption<Boolean> ALLOW_PUBLIC_KEY_RETRIEVAL;
    public ConfigOption<Boolean> ENABLE_DISTANCE_LIMITATIONS;
    public ConfigOption<Integer> MAXIMUM_TELEPORT_DISTANCE;
    public ConfigOption<Boolean> MONITOR_ALL_TELEPORTS;
    public PerCommandOption<Integer> DISTANCE_LIMITS;
    public ConfigOption<ConfigSection> CUSTOM_DISTANCE_LIMITS;
    public ConfigOption<Boolean> ENABLE_TELEPORT_LIMITATIONS;
    public ConfigOption<Boolean> MONITOR_ALL_TELEPORTS_LIMITS;
    public ConfigOption<ConfigSection> WORLD_RULES;
    public PerCommandOption<String> COMMAND_RULES;
    public ConfigOption<ConfigSection> X;
    public ConfigOption<ConfigSection> Z;
    public ConfigOption<Boolean> RAPID_RESPONSE;
    public ConfigOption<Boolean> USE_VANILLA_BORDER;
    public ConfigOption<Boolean> USE_PLUGIN_BORDERS;
    public ConfigOption<Boolean> PROTECT_CLAIM_LOCATIONS;
    public ConfigOption<Integer> PREPARED_LOCATIONS_LIMIT;
    public ConfigOption<List<String>> IGNORE_WORLD_GENS;
    public ConfigOption<List<String>> AVOID_BLOCKS;
    public ConfigOption<List<String>> AVOID_BIOMES;
    public ConfigOption<Boolean> WHITELIST_WORLD;
    public ConfigOption<Boolean> REDIRECT_TO_WORLD;
    public ConfigOption<List<String>> ALLOWED_WORLDS;
    public ConfigOption<Integer> DEFAULT_HOMES_LIMIT;
    public ConfigOption<Boolean> ADD_BED_TO_HOMES;
    public ConfigOption<Boolean> DENY_HOMES_IF_OVER_LIMIT;
    public ConfigOption<Boolean> HIDE_HOMES_IF_DENIED;
    public ConfigOption<Boolean> OVERWRITE_SETHOME;
    public ConfigOption<Boolean> SHOW_HOMES_WITH_NO_INPUT;
    public ConfigOption<Boolean> PRIORITISE_MAIN_HOME;
    public ConfigOption<String> TPA_REQUEST_RECEIVED;
    public ConfigOption<String> TPA_REQUEST_SENT;
    public ConfigOption<String> TPAHERE_REQUEST_RECEIVED;
    public ConfigOption<String> TPAHERE_REQUEST_SENT;
    public ConfigOption<List<String>> BACK_TELEPORT_CAUSES;
    public ConfigOption<Integer> BACK_SEARCH_RADIUS;
    public MapOptions MAP_HOMES;
    public MapOptions MAP_WARPS;
    public MapOptions MAP_SPAWNS;
    public ConfigOption<Boolean> TELEPORT_TO_SPAWN_FIRST;
    public ConfigOption<String> FIRST_SPAWN_POINT;
    public ConfigOption<Boolean> USE_RANDOM_LOCATION_FIRST_SPAWN_POINT;
    public ConfigOption<String> FIRST_RANDOM_LOCATION_WORLD_NAME;
    public ConfigOption<Boolean> SET_RANDOM_FIRST_LOCATION_HOME;
    public ConfigOption<Boolean> TELEPORT_TO_SPAWN_EVERY;
    public ConfigOption<Boolean> TELEPORT_TO_NEAREST_SPAWN;
    public ConfigOption<Boolean> USE_OVERWORLD;
    public ConfigOption<ConfigSection> DEATH_MANAGEMENT;
    public ConfigOption<List<String>> DEFAULT_PERMISSIONS;
    public ConfigOption<Boolean> ALLOW_ADMIN_PERMS;
    public ConfigOption<Boolean> CHECK_FOR_UPDATES;
    public ConfigOption<Boolean> NOTIFY_ADMINS;
    public ConfigOption<Boolean> DEBUG;
    public ConfigOption<Boolean> USE_FLOODGATE_FORMS;
    public ConfigOption<Boolean> SEND_ACTIONBAR_TO_CONSOLE;
    public ConfigOption<Boolean> RETAIN_PASSENGERS;
    public ConfigOption<Boolean> RETAIN_VEHICLES;
    public ConfigOption<Boolean> RETAIN_LIVING_ONLY;
    public ConfigOption<Boolean> TELEPORT_ON_SIGN_SIDE;

    public MainConfig() throws Exception {
        super("config.yml");
    }

    public void addDefaults() {
        instance = this;
        this.setTitle(new Title().withWidth(100).addSolidLine().addLine("-<( AdvancedTeleport )>-", Title.Pos.CENTER).addLine("Made by Niestrat99 and Thatsmusic99", Title.Pos.CENTER).addLine("").addSolidLine('-').addLine("A rapidly growing teleportation plugin looking to break the boundaries of traditional teleport plugins.").addLine("").addLine("SpigotMC - https://www.spigotmc.org/resources/advanced-teleport.64139/").addLine("Wiki - https://tm-holly.gitbook.io/advancedteleport/").addLine("Discord - https://discord.gg/mgWbbN4").addSolidLine());
        this.addComment("Another comment at the very top for all you lads :)");
        this.addDefault("use-basic-teleport-features", true, "Features", "Whether basic teleportation features should be enabled or not.\nThis includes /tpa, /tpahere, /tpblock, /tpunblock and /back.\nThis does not disable the command for other plugins - if you want other plugins to use the provided commands, use Bukkit's commands.yml file.\nPlease refer to https://bukkit.gamepedia.com/Commands.yml for this!");
        this.addDefault("use-warps", true, "Whether warps should be enabled in the plugin.");
        this.addDefault("use-spawn", true, "Whether the plugin should modify spawn/spawn properties.");
        this.addDefault("use-randomtp", true, "Whether the plugin should allow random teleportation.");
        this.addDefault("use-homes", true, "Whether homes should be enabled in the plugin.");
        this.addDefault("disabled-commands", new ArrayList(), "The commands that AT should not register upon starting up.\nIn other words, this gives up the command for other plugins to use.\nNOTE: If you are using Essentials with AT and want AT to give up its commands to Essentials, Essentials does NOT go down without a fight. Jesus Christ. You'll need to restart the server for anything to change.\nTo use this section, use the following format:\ndisabled-commands:\n- back");
        this.addSection("Teleport Requesting");
        this.addDefault("request-lifetime", 60, "How long tpa and tpahere requests last before expiring.");
        this.addDefault("allow-multiple-requests", true, "Whether or not the plugin should enable the use of multiple requests.\nWhen enabled, user 1 may get TPA requests from user 2 and 3, but user 1 is prompted to select a specific request.\nWhen this is disabled and user 1 receives requests from user 2 and then 3, they will only have user 3's request to respond to.");
        this.addDefault("notify-on-expire", true, "Let the player know when their request has timed out or been displaced by another user's request.\nDisplacement only occurs when allow-multiple-requests is disabled.");
        this.addDefault("warm-up-timer-duration", 3, "Warm-Up Timers", "The number of seconds it takes for the teleportation to take place following confirmation.\n(i.e. \"You will teleport in 3 seconds!\")\nThis acts as the default option for the per-command warm-ups.");
        this.addDefault("cancel-warm-up-on-rotation", true, "Whether or not teleportation should be cancelled if the player rotates or moves.");
        this.addDefault("cancel-warm-up-on-movement", true, "Whether or not teleportation should be cancelled upon movement only.");
        this.addDefault("cancel-warm-up-on-damage", true, "Whether or not teleportation should be cancelled when the player receives damage.\nBest option to accompany the invulnerability system if your server has it enabled, so that players can't cheese it. :thumbsup:");
        this.addDefault("check-exact-coordinates", false, "Whether the plugin should check for change in exact X, Y and Z vs. block X, Y, Z.\nBy default, the player will have to cross into a new block (e.g. 60x 60y 60z -> 61x 60y 60z) to cancel the teleportation.");
        this.addComment("per-command-warm-ups", "Command-specific warm-ups.");
        this.addDefault("per-command-warm-ups.tpa", "default", "Warm-up timer for /tpa.");
        this.addDefault("per-command-warm-ups.tpahere", "default", "Warm-up timer for /tpahere");
        this.addDefault("per-command-warm-ups.tpr", "default", "Warm-up timer for /tpr, or /rtp.");
        this.addDefault("per-command-warm-ups.warp", "default", "Warm-up timer for /warp");
        this.addDefault("per-command-warm-ups.spawn", "default", "Warm-up timer for /spawn");
        this.addDefault("per-command-warm-ups.home", "default", "Warm-up timer for /home");
        this.addDefault("per-command-warm-ups.back", "default", "Warm-up timer for /back");
        this.addComment("Use this section to create custom warm-ups per-group.\nUse the following format:\ncustom-warm-ups:\n  vip-warm-up: 3\nGiving a group, such as VIP, the permission at.member.timer.vip-warm-up will have a warm-up of 3.\nThe key (vip-warm-up) and group name (VIP) do not have to be different, this is just an example.\nYou can also add at.member.timer.3, but this is more efficient if you find permissions lag.To make it per-command, use at.member.timer.<command>.vip-warm-up. To make it per-world, use at.member.timer.<world>.vip-warm-up.\nTo combine the two, you can use at.member.timer.<command>.<world>.vip-warm-up.");
        this.makeSectionLenient("custom-warm-ups");
        this.addDefault("blindness-on-warmup", false, "Gives the teleporting player a blindness effect whilst waiting to teleport.");
        this.addDefault("cooldown-duration", 5, "Cooldowns", "How long before the user can use a command again.\nThis stops users spamming commands repeatedly.\nThis is also the default cooldown period for all commands.");
        this.addDefault("add-cooldown-duration-to-warm-up", true, "Adds the warm-up duration to the cooldown duration.\nFor example, if the cooldown duration was 5 seconds but the warm-up was 3, the cooldown becomes 8 seconds long.");
        this.addDefault("apply-cooldown-to-all-commands", false, "Whether or not the cooldown of one command will stop a user from using all commands.\nFor example, if a player used /tpa with a cooldown of 10 seconds but then used /tpahere with a cooldown of 5, the 10-second cooldown would still apply.\nOn the other hand, if a player used /tpahere, the cooldown of 5 seconds would apply to /tpa and other commands.");
        this.addDefault("apply-cooldown-after", "request", "When to apply the cooldown\nOptions include:\n- request - Cooldown starts as soon as any teleport command is made and still applies even if no teleport takes place (i.e. cancelled by movement or not accepted).\n- accept - Cooldown starts only when the teleport request is accepted (with /tpyes) and still applies even if no teleport takes place (i.e. cancelled by movement).\n- teleport - Cooldown starts only when the teleport actually happens.\nNote:\n'request' and 'accept' behave the same for /rtp, /back, /spawn, /warp, and /home\ncooldown for /tpall always starts when the command is ran, regardless if any player accepts or teleports");
        this.addComment("per-command-cooldowns", "Command-specific cooldowns.");
        this.addDefault("per-command-cooldowns.tpa", "default", "Cooldown for /tpa.");
        this.addDefault("per-command-cooldowns.tpahere", "default", "Cooldown for /tpahere");
        this.addDefault("per-command-cooldowns.tpr", "default", "Cooldown for /tpr, or /rtp.");
        this.addDefault("per-command-cooldowns.warp", "default", "Cooldown for /warp");
        this.addDefault("per-command-cooldowns.spawn", "default", "Cooldown for /spawn");
        this.addDefault("per-command-cooldowns.home", "default", "Cooldown for /home");
        this.addDefault("per-command-cooldowns.back", "default", "Cooldown for /back");
        this.makeSectionLenient("custom-cooldowns");
        this.addComment("custom-cooldowns", "Use this section to create custom cooldowns per-group.\nUse the following format:\ncustom-cooldowns:\n  vip-cooldown: 3\nGiving a group, such as VIP, the permission at.member.cooldown.vip-cooldown will have a cooldown of 3.\nThe key (vip-cooldown) and group name (VIP) do not have to be different, this is just an example.\nYou can also add at.member.cooldown.3, but this is more efficient if you find permissions lag. To make it per-command, use at.member.cooldown.<command>.vip-cooldown. To make it per-world, use at.member.cooldown.<world>.vip-cooldown.\nTo combine the two, you can use at.member.cooldown.<command>.<world>.vip-cooldown.");
        this.addDefault("cost-amount", 100.0, "Teleportation Costs", "The amount it costs to teleport somewhere.\nIf you want to use Vault Economy, use 100.0 to charge $100.\nIf you have multiple plugins hooking into Vault, enter the plugin name in front separated by a colon, e.g. Essentials:100.50\nDo note some plugins require Vault support to be toggled on manually.\nIf you want to use Minecraft EXP points, use 10EXP for 10 EXP Points.\nIf you want to use Minecraft EXP levels, use 5LVL for 5 levels.\nIf you want to use items, use the format MATERIAL:AMOUNT or MATERIAL:AMOUNT:BYTE.\nFor example, on 1.13+, ORANGE_WOOL:3 for 3 orange wool, but on versions before 1.13, WOOL:3:1.\nIf you're on a legacy version and unsure on what byte to use, see https://minecraftitemids.com/types\nTo use multiple methods of charging, use a ; - e.g. '100.0;10LVL' for $100 and 10 EXP levels.\nTo disable, just put an empty string, i.e. ''");
        this.addComment("per-command-cost", "Command-specific costs.");
        this.addDefault("per-command-cost.tpa", "default", "Cost for /tpa.");
        this.addDefault("per-command-cost.tpahere", "default", "Cost for /tpahere.");
        this.addDefault("per-command-cost.tpr", "default", "Cost for /tpr, or /rtp.");
        this.addDefault("per-command-cost.warp", "default", "Cost for /warp");
        this.addDefault("per-command-cost.spawn", "default", "Cost for /spawn");
        this.addDefault("per-command-cost.home", "default", "Cost for /home");
        this.addDefault("per-command-cost.back", "default", "Cost for /back");
        this.makeSectionLenient("custom-costs");
        this.addComment("custom-costs", "Use this section to create custom costs per-group.\nUse the following format:\ncustom-costs:\n  vip-cost: Essentials:100\nGiving a group, such as VIP, the permission at.member.cost.vip-cost will have a cost of $100.\nTo make it per-command, add the permission at.member.cost.tpa.vip-cost (for tpa) instead.");
        this.addDefault("invulnerability-duration", 0, "Invulnerability", "How long the invulnerability period lasts in seconds.");
        this.addDefault("damage-blacklist", new ArrayList(), "All damage causes that are not cancelled by invulnerability.\nThe full list is accessible here: https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/entity/EntityDamageEvent.DamageCause.html");
        this.addComment("per-command-invulnerability", "Command-specific invulnerability durations.");
        this.addDefault("per-command-invulnerability.tpa", "default", "Invulnerability duration for /tpa.");
        this.addDefault("per-command-invulnerability.tpahere", "default", "Invulnerability duration for /tpahere.");
        this.addDefault("per-command-invulnerability.tpr", "default", "Invulnerability duration for /tpr, or /rtp.");
        this.addDefault("per-command-invulnerability.warp", "default", "Invulnerability duration for /warp");
        this.addDefault("per-command-invulnerability.spawn", "default", "Invulnerability duration for /spawn");
        this.addDefault("per-command-invulnerability.home", "default", "Invulnerability duration for /home");
        this.addDefault("per-command-invulnerability.back", "default", "Invulnerability duration for /back");
        this.makeSectionLenient("custom-invulnerability-periods");
        this.addComment("custom-invulnerability-periods", "Use this section to create custom invulnerability periods per-group.\nUse the following format:\ncustom-invulnerability-periods:\n  vip: 5\nGiving a group, such as VIP, the permission at.member.invulnerability.vip will have an invulnerable period of 5 seconds.\nTo make it per-command, add the permission at.member.invulnerability.tpa.vip (for tpa) instead.You can also add at.member.invulnerability.5, but this is more efficient if you find permissions lag.\n");
        this.addDefault("use-particles", true, "Particles", "Whether particles should be used in the plugin.\nSome standalone implementation is used, but otherwise, PlayerParticles is used.");
        this.addDefault("default-waiting-particles", "", "The default waiting particles during the warm-up period.");
        this.addComment("waiting-particles", "Command-specific waiting particles.");
        this.addDefault("waiting-particles.tpa", "default");
        this.addDefault("waiting-particles.tpahere", "default");
        this.addDefault("waiting-particles.tpr", "default");
        this.addDefault("waiting-particles.warp", "default");
        this.addDefault("waiting-particles.spawn", "default");
        this.addDefault("waiting-particles.home", "default");
        this.addDefault("waiting-particles.back", "default");
        this.addDefault("default-teleporting-particles", "spark", "The default particles used as soon as the player teleports. \nAt this time, only spark is supported. However, other recommendations are welcome with that.");
        this.addComment("teleporting-particles", "Command-specific teleporting particles.");
        this.addDefault("teleporting-particles.tpa", "default");
        this.addDefault("teleporting-particles.tpahere", "default");
        this.addDefault("teleporting-particles.tpr", "default");
        this.addDefault("teleporting-particles.warp", "default");
        this.addDefault("teleporting-particles.spawn", "default");
        this.addDefault("teleporting-particles.home", "default");
        this.addDefault("teleporting-particles.back", "default");
        this.addDefault("default-post-teleport-particles", "spark", "The default particles used immediately after the player teleports. \nAt this time, only spark is supported. However, other recommendations are welcome with that.");
        this.addComment("post-teleport-particles", "Command-specific post-teleport particles.");
        this.addDefault("post-teleport-particles.tpa", "default");
        this.addDefault("post-teleport-particles.tpahere", "default");
        this.addDefault("post-teleport-particles.tpr", "default");
        this.addDefault("post-teleport-particles.warp", "default");
        this.addDefault("post-teleport-particles.spawn", "default");
        this.addDefault("post-teleport-particles.home", "default");
        this.addDefault("post-teleport-particles.back", "default");
        this.addSection("SQL Storage");
        this.addDefault("use-mysql", false, "Whether the plugin should use SQL storage or not.\nBy default, AT uses SQLite storage, which stores data in a .db file locally.");
        this.addDefault("mysql-host", "127.0.0.1", "The MySQL host to connect to.");
        this.addDefault("mysql-port", 3306, "The port to connect to.");
        this.addDefault("mysql-database", "database", "The database to connect to.");
        this.addDefault("mysql-username", "username", "The username to use when connecting.");
        this.addDefault("mysql-password", "password", "The password to use when connecting.");
        this.addDefault("mysql-table-prefix", "advancedtp", "The prefix of all AT tables. \nIf you're on Bungee, you may want to add your server's name to the end.");
        this.addDefault("use-ssl", false, "Whether or not to connect to the MySQL server using SSL.");
        this.addDefault("auto-reconnect", true, "Whether or not the plugin should reconnect to the MySQL server when a connection is closed.");
        this.addDefault("allow-public-key-retrieval", false, "Whether or not to enable public key retrieval. \nPlease do not enable it without being explicitly told by one of the developers.");
        this.addDefault("enable-distance-limitations", false, "Distance Limitations", "Enables the distance limiter to stop players teleporting over a large distance.\nThis is only applied when people are teleporting in the same world.");
        this.addDefault("maximum-teleport-distance", 1000, "The maximum distance that a player can teleport.\nThis is the default distance applied to all commands when specified.");
        this.addDefault("monitor-all-teleports-distance", false, "Whether or not all teleports - not just AT's - should be checked for distance.");
        this.addComment("per-command-distance-limitations", "Determines the distance limit for each command.");
        this.addDefault("per-command-distance-limitations.tpa", "default", "Distance limit for /tpa");
        this.addDefault("per-command-distance-limitations.tpahere", "default", "Distance limit for /tpahere");
        this.addDefault("per-command-distance-limitations.tpr", "default", "Distance limit for /tpr");
        this.addDefault("per-command-distance-limitations.warp", "default", "Distance limit for /warp");
        this.addDefault("per-command-distance-limitations.spawn", "default", "Distance limit for /spawn");
        this.addDefault("per-command-distance-limitations.home", "default", "Distance limit for /home");
        this.addDefault("per-command-distance-limitations.back", "default", "Distance limit for /back");
        this.makeSectionLenient("custom-distance-limitations");
        this.addComment("custom-distance-limitations", "Use this section to create custom distance limitations per-group.\nUse the following format:\ncustom-distance-limitations:\n  vip-distance: 300000\nGiving a group, such as VIP, the permission at.member.distance.vip-distance will have a maximum distance of 300000.\nThe key (vip-distance) and group name (VIP) do not have to be different, this is just an example.\nYou can also add at.member.distance.300000, but this is more efficient if you find permissions lag. To make it per-command, use at.member.distance.<command>.vip-distance. To make it per-world, use at.member.distance.<world>.vip-distance.\nTo combine the two, you can use at.member.distance.<command>.<world>.vip-distance.");
        this.addSection("Teleportation Limitations");
        this.addComment("WARNING: A lot of the options below are considered advanced and use special syntax that is not often accepted in YAML.\nWhen using such options, wrap them in quotes: ''\nAs an example, 'stop-teleportation-out:world,world_nether'");
        this.addDefault("enable-teleport-limitations", false, "Enables teleport limitations. This means cross-world or even world teleportation can be limited within specific worlds.");
        this.addDefault("monitor-all-teleports-limitations", false, "Whether or not all teleportation - not just AT's - should be checked to see if teleportation is allowed.");
        this.addComment("world-rules", "The teleportation rules defined for each world.\nRules include:\n- stop-teleportation-out - Stops players teleporting to another world when they are in this world.\n- stop-teleportation-within - Stops players teleporting within the world.\n- stop-teleportation-into - Stops players teleporting into this world.\nTo combine multiple rules, use a ; - e.g. stop-teleportation-out;stop-teleportation-within\nFor out and into rules, you can make it so that rules only initiate when in or going to a specific world using :, e.g. stop-teleportation-out:world stops players teleporting to \"world\" in the world they're currently in.\nTo do the opposite (i.e. initiates the rule when users are not in the specified world), use !, e.g. stop-teleportation-into!world stops teleportation into a specific world if they are not in \"world\". If ! and : are used in the same rule, then : is given top priority.To make this rule work with multiple worlds, use a comma (,), e.g. stop-teleportation-into:world,world_nether");
        this.makeSectionLenient("world-rules");
        this.addDefault("world-rules.default", "stop-teleportation-within");
        this.addExample("world-rules.world", "default");
        this.addExample("world-rules.world_nether", "stop-teleportation-into!world");
        this.addComment("command-rules", "The teleportation rules defined for each AT command.\nRules include:\n- override - The command will override world rules and run regardless.\n- ignore - The command will refuse to run regardless of world rules.\nTo combine multiple rules, use a ;.\nTo make rules behave differently in different worlds, use : to initiate the rule in a specific world (e.g. override:world to make the command override \"world\"'s rules.)\nTo initiate rules outside of a specific world, use ! (e.g. override!world to make the command override world rules everywhere but in world)\nTo use multiple worlds, use a comma (,).\nBy default, all commands will comply with the world rules. If no rules are specified, they will comply.\nAll worlds specified will be considered the world in which the player is currently in. For worlds being teleported to, add > to the start of the world name.\nFor example, ignore:world,>world_nether will not run if the player is in \"world\" or if the player is going into the Nether.");
        this.addDefault("command-rules.tpa", "");
        this.addDefault("command-rules.tpahere", "");
        this.addDefault("command-rules.tpr", "");
        this.addDefault("command-rules.warp", "");
        this.addDefault("command-rules.spawn", "");
        this.addDefault("command-rules.home", "");
        this.addDefault("command-rules.back", "");
        this.addSection("RandomTP");
        this.makeSectionLenient("x");
        this.addDefault("x.default", "5000;-5000");
        this.addExample("x.world_the_end", "10000;-10000");
        this.addComment("x", "Defines the range of X coordinates that players can teleport to.\nUsing a value for example 5000 would automatically set the minimum to -5000.\nThese are able to be defined for each world by name.\nSplit the values with a semicolon (;).\nIf a world is defined here but not in the z section, the x values will be reused for the z coords.\n");
        this.addComment("z", "Defines the range of z coordinates that players can teleport to.\nUsing a value for example 5000 would automatically set the minimum to -5000.\nThese are able to be defined for each world by name.\nSplit the values with a semicolon (;).\nIf a world is defined here but not in the x section, the z values will be reused for the x coords.\n");
        this.makeSectionLenient("z");
        this.addDefault("z.default", "5000;-5000");
        this.addExample("z.world_the_end", "10000;-10000");
        this.addDefault("maximum-x", 5000, "Deprecated\n # The maximum X coordinate to go up to when selecting a random location.");
        this.addDefault("maximum-z", 5000, "Deprecated\n # The maximum Z coordinate to go up to when selecting a random location.");
        this.addDefault("minimum-x", -5000, "Deprecated\n # The minimum X coordinate to go down to when selecting a random location.");
        this.addDefault("minimum-z", -5000, "Deprecated\n # The minimum Z coordinate to go down to when selecting a random location.");
        this.addDefault("use-rapid-response", true, "Use the new rapid response system for RTP.\nThis means valid locations are prepared before a user chooses to use /tpr or interact with a sign, meaning they are ready for use and can instantly TP a player.\nThis feature allows you to use the \"tpr\" death option in the death management section further down.\nIMPORTANT NOTE - this feature only works on the Paper server type and any of its forks. It is not considered safe to use on Spigot or Bukkit.");
        this.addDefault("use-vanilla-border", false, "Whether the plugin should use the Vanilla world border as a viable option for managing /tpr boundaries.");
        this.addDefault("use-plugin-borders", true, "Whether the plugin should use plugin world borders for managing /tpr boundaries.\nCurrently supported plugins are WorldBorder and ChunkyBorder.");
        this.addDefault("protect-claim-locations", true, "If enabled checks if the player is in either an unclaimed area or that they have build permission in the area.\nSupported plugins are Lands, WorldGuard, and GriefPrevention.");
        this.addDefault("prepared-locations-limit", 3, "How many locations can be prepared per world when using AT's Rapid Response system.\nThese are immediately prepared upon startup and when a world is loaded.");
        this.addDefault("ignore-world-generators", new ArrayList<String>(Arrays.asList("us.talabrek.ultimateskyblock.world.SkyBlockChunkGenerator", "us.talabrek.ultimateskyblock.world.SkyBlockNetherChunkGenerator", "world.bentobox.bskyblock.generators.ChunkGeneratorWorld", "world.bentobox.acidisland.world.ChunkGeneratorWorld", "world.bentobox.oneblock.generators.ChunkGeneratorWorld", "com.wasteofplastic.askyblock.generators.ChunkGeneratorWorld", "com.wasteofplastic.acidisland.generators.ChunkGeneratorWorld", "b.a", "com.chaseoes.voidworld.VoidWorld.VoidWorldGenerator", "club.bastonbolado.voidgenerator.EmptyChunkGenerator", "de.xtkq.voidgen.generator.interfaces.ChunkGen")), "AT's Rapid Response system automatically loads locations for each world, but can be problematic on some worlds, mostly SkyBlock worlds.\nIn response, this list acts as pro-active protection and ignores worlds generated using the following generators.\nThis is provided as an option so you can have control over which worlds have locations load.");
        this.addDefault("avoid-blocks", new ArrayList<String>(Arrays.asList("WATER", "LAVA", "STATIONARY_WATER", "STATIONARY_LAVA")), "Blocks that people must not be able to land in when using /tpr.");
        this.addDefault("avoid-biomes", new ArrayList<String>(Arrays.asList("OCEAN", "DEEP_OCEAN")), "Biomes that the plugin should avoid when searching for a location.");
        this.addDefault("whitelist-worlds", false, "Whether or not /tpr should only be used in the worlds listed below.");
        this.addDefault("redirect-to-whitelisted-worlds", true, "Whether or not players should be directed to a whitelisted world when using /tpr.\nWhen this option is disabled and the player tries to use /tpr in a non-whitelisted world, the command simply won't work.");
        this.addDefault("allowed-worlds", new ArrayList<String>(Arrays.asList("world", "world_nether")), "Worlds you can use /tpr in.\nIf a player uses /tpr in a world that doesn't allow it, they will be teleported in the first world on the list instead.\nTo make this feature effective, turn on \"whitelist-worlds\" above.");
        this.addDefault("default-homes-limit", -1, "Homes", "The default maximum of homes people can have.\nThis can be overridden by giving people permissions such as at.member.homes.10.\nTo disable this, use -1 as provided by default.");
        this.addDefault("add-bed-to-homes", true, "Whether or not the bed home should be added to /homes.");
        this.addDefault("deny-homes-if-over-limit", false, "Whether or not players should be denied access to some of their homes if they exceed their homes limit.\nThe homes denied access to will end up being their most recently set homes.\nFor example, having homes A, B, C, D and E with a limit of 3 will deny access to D and E.");
        this.addDefault("hide-homes-if-denied", false, "If homes should be hidden from /homes should they be denied access.\nIf this is false, they will be greyed out in the /homes list.");
        this.addDefault("overwrite-sethome", false, "When enabled, setting homes with a name that already exists in your list gets overwritten.");
        this.addDefault("show-homes-with-no-input", false, "Shows a list of homes the player has when doing /home and nothing else.\nThis overwrites /home when attempting to teleport to their main home, but if you're more used to what Essentials does, set this to true.");
        this.addDefault("prioritise-main-home", true, "If the player has a main home set, then the option above is ignored. I gotta be flexible.");
        this.addDefault("tpa-request-received", "none", "Notifications/Sounds", "The sound played when a player receives a teleportation (tpa) request.\nFor 1.16+, check https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Sound.html for a list of sounds you can use\nFor 1.15 and below, check https://www.spigotmc.org/threads/sounds-spigot-1-7-1-14-4-sound-enums.340452/ for a list of sounds down to 1.7.\n(Friendly reminder that 1.7.x is not supported though!)\nSet to \"none\" if you want no sound playing.");
        this.addDefault("tpa-request-sent", "none", "The sound played when a player sends a teleportation (tpa) request.");
        this.addDefault("tpahere-request-received", "none", "The sound played when a player receives a teleportation (tpahere) request.");
        this.addDefault("tpahere-request-sent", "none", "The sound played when a player sends a teleportation (tpahere) request.");
        this.addDefault("used-teleport-causes", new ArrayList<String>(Arrays.asList("COMMAND", "PLUGIN", "SPECTATE")), "Back", "The teleport causes that the plugin must listen to allow players to teleport back to the previous location.\nYou can see a full list of these causes at https://hub.spigotmc.org/javadocs/spigot/org/bukkit/event/player/PlayerTeleportEvent.TeleportCause.html");
        this.addDefault("back-search-radius", 5, "The cubic radius to search for a safe block when using /back.\nIf a player teleports from an unsafe location and uses /back to return to it, the plugin will search all blocks within this radius to see if it is a safe place for the player to be moved to.\nIt is recommend to avoid setting this option too high as this can have a worst case execution time of O(n^3) (e.g. run 27 times, 64, 125, 216 and so on).\nTo disable, either set to 0 or -1.");
        this.addSection("Map Plugin Integration");
        this.addComment("At this time, AdvancedTeleport supports dynmap and squaremap.\nIf you are using dynmap, the plugin has extra icons you can use as placeholders.");
        for (String type : Arrays.asList("homes", "warps", "spawns")) {
            String singular = type.substring(0, type.length() - 1);
            String capitalised = type.toUpperCase().charAt(0) + type.toLowerCase().substring(1);
            this.addComment(type, "Covers map options for " + type + ".");
            this.addDefault(type + ".enabled", !type.equals("homes"), "Whether the icons for " + type + " will be added at all.");
            this.addDefault(type + ".default-icon", singular + "-default", "The default icon for " + type + " in the map.");
            this.addDefault(type + ".shown-by-default", true, "Whether the player viewing the map has to explicitly enable the layer to view " + type + " on the map.");
            this.addDefault(type + ".hover-tooltip", "{name}", "The tooltip that will appear when someone hovers over the icon in the map.\nFor Dynmap, this supports HTML formatting.");
            this.addDefault(type + ".click-tooltip", "{name}", "Squaremap only - the tooltip that will appear when someone clicks on the icon.");
            this.addDefault(type + ".icon-size", "32", "The scale of the icon on the map.\nWith Dynmap, only 8, 16 and 32 are supported. With Squaremap, 2147483647 is your limit. But don't try it.");
            this.addDefault(type + ".layer-name", capitalised, "The layer display name that appears on the map.");
        }
        this.addDefault("add-spawns", true, "Whether to make spawnpoints visible for everyone on the map.");
        this.addDefault("add-warps", true, "Whether to make warps visible for everyone on the map.");
        this.addDefault("add-homes", false, "Whether to make all homes visible for everyone on the map.");
        this.addDefault("default-icon-size", 40, "The default icon size for AT's icons on the map.");
        this.addDefault("teleport-to-spawn-on-first-join", true, "Spawn Management", "Whether the player should be teleported to the spawnpoint when they join for the first time.");
        this.addDefault("first-spawn-point", "", "The name of the spawnpoint players will be first teleported to if they joined for the first time.\nIf it is blank, then it will take the main spawnpoint.");
        this.addDefault("use-random-location-for-first-spawn-point", false, "Teleports all new players to a random location when they join the server for the first time.");
        this.addDefault("first-random-teleportation-world-name", "", "The world that the player will be randomly teleported into when they join for the first time.\nIf left blank, the player will either teleport within the world of the main spawnpoint, or the\nworld they first spawn in.");
        this.addDefault("set-first-random-location-as-home", false, "If players are teleported to a random location when they first join the server, this sets the\nlocation as a home for those players called \"home\".");
        this.addDefault("teleport-to-spawn-on-every-join", false, "Whether the player should be teleported to the spawnpoint every time they join.");
        this.addDefault("teleport-to-nearest-spawnpoint", false, "Whether using /spawn, joining or respawning should send the user to the closest spawnpoint they have access to.\nIf the user doesn't have permission to the specified spawnpoint, then they are not sent to it.\nOnly spawns in the same dimension/world are considered. If no spawnpoint is set in the same dimension, then the normal main spawn is used.");
        this.addDefault("use-overworld", true, "If no main spawn has been set and the world being checked is in the Nether or End, use the Overworld spawn instead (if applicable).");
        this.addComment("death-management", "Determines how and where players teleport when they die.\nOptions include:\n- spawn - Teleports the player to the spawnpoint of either the world or specified by the plugin.\n- bed - Teleports to the player's bed.\n- anchor - 1.16+ only, teleports to the player's respawn anchor. However, due to limitations with Spigot's API, it may or may not always work. (add Player#getRespawnAnchor pls)\n- warp:Warp Name - Teleports the player to a specified warp. For example, if you want to teleport to Hub, you'd type warp:Hub\n- tpr - Teleports the player to a random location. Can only be used when the rapid response system is enabled.\n- home - Teleports the player to their main or first home.\n- default - Uses the default respawn option, which is spawn unless set differently.\nIf you're using EssentialsX Spawn and want AT to take over respawn mechanics, set respawn-listener-priority in EssX's config.yml file to lowest.");
        this.makeSectionLenient("death-management");
        this.addDefault("death-management.default", "bed;spawn");
        this.addExample("death-management.world", "default");
        this.addExample("death-management.special-world", "warp:Special");
        this.addExample("death-management.another-world", "bed");
        this.addDefault("default-permissions", new ArrayList<String>(Arrays.asList("at.member.*", "at.member.warp.*", "at.member.warp.sign.*", "at.member.core.help", "at.member.core.info")), "Permissions", "The default permissions given to users without OP.\nBy default, Advanced Teleport allows users without OP to use all member features.\nThis allows for permission management without a permissions plugin, especially if a user doesn't understand how such plugins work.\nHowever, if you have a permissions plugin and Vault installed, you cannot make admin permissions work by default.");
        this.addDefault("allow-admin-permissions-as-default-perms", false, "Allows admin permissions to be allowed as default permissions by default.\nIf you want to use admin permissions, it's often recommended to use a permissions plugin such as LuckPerms.\nDo not enable this if you are unsure of the risks this option proposes.");
        this.addSection("Updates");
        this.addDefault("check-for-updates", true, "Whether or not the plugin should check for updates.");
        this.addDefault("notify-admins-on-update", true, "Whether or not to notify admins when an update is available.\nAnyone with the permission at.admin.notify will receive this notification.");
        this.addDefault("debug", false, "Miscellaneous", "Used for debugging purposes.");
        this.addDefault("use-floodgate-forms", true, "Whether to use Cumulus forms for Bedrock players.\nThese work by having a Bedrock player type in the command itself (such as /warp, /tpa, /setwarp), then fill in the rest of the commands through a form.\nThis only works when Geyser and Floodgate are used on the server. This improves accessibility for mobile or console players.");
        this.addDefault("send-actionbar-to-console", true, "If you are just using action bars for messages and have empty base messages, the console will not receive them.\nIf you have this option set to true, then the console will receive the message that the action bar uses.");
        this.addDefault("retain-passengers", false, "Keeps any entities riding teleporting players on their heads.\nOnly available to newer versions of Paper and uses experimental API - don't expect this to be set to true by default for a while!\nTeleportation is also not async if this has to be used.");
        this.addDefault("retain-vehicle", false, "Keeps any entities being ridden by teleporting players.\nOnly available to newer versions of Paper and uses experimental API - don't expect this to be set to true by default for a while!\nTeleportation is also not async if this has to be used.");
        this.addDefault("retain-living-vehicles-only", true, "If it's not a minecart or boat, take it with us. Requires the above option to be set to true.");
        this.addDefault("teleport-on-sign-side", false, "Applies to 1.20+ servers - whether the player will have to click the front of the sign (or where teleportation text is) to activate a sign.\nIf a player clicks on a sign with different lines on either side, the plugin prioritises the clicked side.");
    }

    public static MainConfig get() {
        return instance;
    }

    public void moveToNew() {
        this.moveTo("features.teleport", "use-basic-teleport-features");
        this.moveTo("features.warps", "use-warps");
        this.moveTo("features.spawn", "use-spawn");
        this.moveTo("features.randomTP", "use-randomtp");
        this.moveTo("features.homes", "use-homes");
        this.moveTo("timers.requestLifetime", "request-lifetime");
        this.moveTo("timers.teleportTimer", "warm-up-timer-duration");
        this.moveTo("timers.cancel-on-rotate", "cancel-warm-up-on-rotation");
        this.moveTo("timers.cancel-on-movement", "cancel-warm-up-on-movement");
        for (String command : Arrays.asList("tpa", "tpahere", "tpr", "warp", "spawn", "home", "back")) {
            this.moveTo("timers.teleportTimers." + command, "per-command-warm-ups." + command);
        }
        this.moveTo("cooldowns.default", "cooldown-duration");
        this.moveTo("cooldowns.apply-globally", "apply-cooldown-to-all-commands");
        this.moveTo("cooldowns.add-to-timer", "add-cooldown-duration-to-warm-up");
        for (String command : Arrays.asList("tpa", "tpahere", "tpr", "warp", "spawn", "home", "back")) {
            this.moveTo("cooldowns." + command, "per-command-cooldowns." + command);
        }
        this.moveTo("distance-limiter.enabled", "enable-distance-limitations");
        this.moveTo("distance-limiter.distance-limit", "maximum-teleport-distance");
        this.moveTo("distance-limiter.monitor-all-teleports", "monitor-all-teleports-distance");
        boolean defaultVault = this.getBoolean("booleans.useVault");
        boolean defaultEXP = this.getBoolean("booleans.EXPPayment");
        int defaultEXPAmount = this.getInteger("payments.exp.teleportPrice");
        double defaultPrice = this.getDouble("payments.vault.teleportPrice");
        StringBuilder builder = new StringBuilder();
        if (defaultVault) {
            builder.append(defaultPrice);
        }
        if (defaultEXP) {
            if (!builder.isEmpty()) {
                builder.append(";");
            }
            builder.append(defaultEXPAmount).append("LVL");
        }
        if (!builder.isEmpty()) {
            this.set("cost-amount", builder.toString());
        }
        for (String command : Arrays.asList("tpa", "tpahere", "tpr", "warp", "spawn", "home", "back")) {
            try {
                Object vault = this.get("payments.vault." + command + ".price");
                Object exp = this.get("payments.exp." + command + ".price");
                boolean vaultOn = this.get("payments.vault." + command + ".enabled").equals("default") ? defaultVault : this.getBoolean("payments.vault." + command + ".enabled");
                boolean expOn = this.get("payments.exp." + command + ".enabled").equals("default") ? defaultEXP : this.getBoolean("payments.exp." + command + ".enabled");
                StringBuilder paymentCombination = new StringBuilder();
                if (vaultOn) {
                    if (vault.equals("default")) {
                        paymentCombination.append(defaultPrice);
                    } else {
                        paymentCombination.append(vault);
                    }
                    if (expOn) {
                        paymentCombination.append(";");
                    }
                }
                if (expOn) {
                    if (exp.equals("default")) {
                        paymentCombination.append(defaultEXPAmount).append("LVL");
                    } else {
                        paymentCombination.append(exp).append("LVL");
                    }
                }
                if (paymentCombination.isEmpty()) {
                    paymentCombination.append("default");
                }
                this.set("per-command-cost." + command, paymentCombination.toString());
            }
            catch (Exception exception) {}
        }
        this.moveTo("sounds.tpa.requestSent", "tpa-request-sent");
        this.moveTo("sounds.tpa.requestReceived", "tpa-request-received");
        this.moveTo("sounds.tpahere.requestSent", "tpahere-request-sent");
        this.moveTo("sounds.tpahere.requestReceived", "tpahere-request-received");
        this.moveTo("tpr.maximum-x", "maximum-x");
        this.moveTo("tpr.maximum-z", "maximum-z");
        this.moveTo("tpr.minimum-x", "minimum-x");
        this.moveTo("tpr.minimum-z", "minimum-z");
        this.moveTo("tpr.useWorldBorder", "use-world-border");
        this.moveTo("tpr.avoidBlocks", "avoid-blocks");
        this.moveTo("back.teleport-causes", "used-teleport-causes");
        this.moveTo("homes.default-limit", "default-homes-limit");
        this.moveTo("homes.add-bed-to-homes", "add-bed-to-homes");
        this.moveTo("spawn.death.teleport", "death-management");
        this.moveTo("spawn.join.teleport-on-first-join", "teleport-to-spawn-on-first-join");
        this.moveTo("spawn.join.teleport-on-every-join", "teleport-to-spawn-on-every-join");
        this.moveTo("permissions.default-permissions", "default-permissions");
        this.moveTo("permissions.allow-admin-perms-as-defaults", "allow-admin-permissions-as-default-perms");
    }

    public void postSave() {
        List<Object> permissions;
        this.USE_BASIC_TELEPORT_FEATURES = new ConfigOption("use-basic-teleport-features");
        this.USE_WARPS = new ConfigOption("use-warps");
        this.USE_RANDOMTP = new ConfigOption("use-randomtp");
        this.USE_SPAWN = new ConfigOption("use-spawn");
        this.USE_HOMES = new ConfigOption("use-homes");
        this.DISABLED_COMMANDS = new ConfigOption("disabled-commands");
        this.REQUEST_LIFETIME = new ConfigOption("request-lifetime");
        this.USE_MULTIPLE_REQUESTS = new ConfigOption("allow-multiple-requests");
        this.NOTIFY_ON_EXPIRE = new ConfigOption("notify-on-expire");
        this.WARM_UP_TIMER_DURATION = new ConfigOption("warm-up-timer-duration");
        this.CANCEL_WARM_UP_ON_ROTATION = new ConfigOption("cancel-warm-up-on-rotation");
        this.CANCEL_WARM_UP_ON_MOVEMENT = new ConfigOption("cancel-warm-up-on-movement");
        this.CANCEL_WARM_UP_ON_DAMAGE = new ConfigOption("cancel-warm-up-on-damage");
        this.CHECK_EXACT_COORDINATES = new ConfigOption("check-exact-coordinates");
        this.WARM_UPS = new PerCommandOption("per-command-warm-ups", "warm-up-timer-duration");
        this.CUSTOM_WARM_UPS = new ConfigOption("custom-warm-ups");
        this.BLINDNESS_ON_WARMUP = new ConfigOption("blindness-on-warmup");
        this.COOLDOWN_TIMER_DURATION = new ConfigOption("cooldown-duration");
        this.ADD_COOLDOWN_DURATION_TO_WARM_UP = new ConfigOption("add-cooldown-duration-to-warm-up");
        this.APPLY_COOLDOWN_TO_ALL_COMMANDS = new ConfigOption("apply-cooldown-to-all-commands");
        this.CUSTOM_COOLDOWNS = new ConfigOption("custom-cooldowns");
        this.APPLY_COOLDOWN_AFTER = new ConfigOption("apply-cooldown-after");
        switch (this.APPLY_COOLDOWN_AFTER.get().toLowerCase()) {
            case "accept": 
            case "request": 
            case "teleport": {
                break;
            }
            default: {
                CoreClass.getInstance().getLogger().warning("Bad input for apply-cooldown-after option! Using \"request\" as the default option...");
                this.set("apply-cooldown-after", "request");
            }
        }
        this.COOLDOWNS = new PerCommandOption("per-command-cooldowns", "cooldown-duration");
        this.COST_AMOUNT = new ConfigOption("cost-amount");
        this.COSTS = new PerCommandOption("per-command-cost", "cost-amount");
        this.CUSTOM_COSTS = new ConfigOption("custom-costs");
        this.INVULNERABILITY_DURATION = new ConfigOption("invulnerability-duration");
        this.INVULNERABILITY_DAMAGE_BLACKLIST = new ConfigOption("damage-blacklist");
        this.COMMAND_INVULNERABILITY_DURATIONS = new PerCommandOption("per-command-invulnerability", "invulnerability-duration");
        this.CUSTOM_INVULNERABILITY_DURATIONS = new ConfigOption("custom-invulnerability-periods");
        this.USE_PARTICLES = new ConfigOption("use-particles");
        this.WAITING_PARTICLES = new PerCommandOption("waiting-particles", "default-waiting-particles");
        this.TELEPORT_PARTICLES = new PerCommandOption("teleporting-particles", "default-teleporting-particles");
        this.POST_TELEPORT_PARTICLES = new PerCommandOption("post-teleport-particles", "default-post-teleport-particles");
        this.USE_MYSQL = new ConfigOption("use-mysql");
        this.MYSQL_HOST = new ConfigOption("mysql-host");
        this.MYSQL_PORT = new ConfigOption("mysql-port");
        this.MYSQL_DATABASE = new ConfigOption("mysql-database");
        this.USERNAME = new ConfigOption("mysql-username");
        this.PASSWORD = new ConfigOption("mysql-password");
        this.TABLE_PREFIX = new ConfigOption("mysql-table-prefix");
        this.USE_SSL = new ConfigOption("use-ssl");
        this.AUTO_RECONNECT = new ConfigOption("auto-reconnect");
        this.ALLOW_PUBLIC_KEY_RETRIEVAL = new ConfigOption("allow-public-key-retrieval");
        this.ENABLE_DISTANCE_LIMITATIONS = new ConfigOption("enable-distance-limitations");
        this.MAXIMUM_TELEPORT_DISTANCE = new ConfigOption("maximum-teleport-distance");
        this.MONITOR_ALL_TELEPORTS = new ConfigOption("monitor-all-teleports-distance");
        this.DISTANCE_LIMITS = new PerCommandOption("per-command-distance-limitations", "maximum-teleport-distance");
        this.CUSTOM_DISTANCE_LIMITS = new ConfigOption("custom-distance-limitations");
        this.ENABLE_TELEPORT_LIMITATIONS = new ConfigOption("enable-teleport-limitations");
        this.MONITOR_ALL_TELEPORTS_LIMITS = new ConfigOption("monitor-all-teleports-limitations");
        this.WORLD_RULES = new ConfigOption("world-rules");
        this.COMMAND_RULES = new PerCommandOption("command-rules", "");
        this.X = new ConfigOption("x");
        this.Z = new ConfigOption("z");
        this.RAPID_RESPONSE = new ConfigOption("use-rapid-response");
        this.USE_VANILLA_BORDER = new ConfigOption("use-vanilla-border");
        this.USE_PLUGIN_BORDERS = new ConfigOption("use-plugin-borders");
        this.PROTECT_CLAIM_LOCATIONS = new ConfigOption("protect-claim-locations");
        this.PREPARED_LOCATIONS_LIMIT = new ConfigOption("prepared-locations-limit");
        this.IGNORE_WORLD_GENS = new ConfigOption("ignore-world-generators");
        this.AVOID_BLOCKS = new ConfigOption("avoid-blocks");
        this.AVOID_BIOMES = new ConfigOption("avoid-biomes");
        this.WHITELIST_WORLD = new ConfigOption("whitelist-worlds");
        this.REDIRECT_TO_WORLD = new ConfigOption("redirect-to-whitelisted-worlds");
        this.ALLOWED_WORLDS = new ConfigOption("allowed-worlds");
        this.DEFAULT_HOMES_LIMIT = new ConfigOption("default-homes-limit");
        this.ADD_BED_TO_HOMES = new ConfigOption("add-bed-to-homes");
        this.DENY_HOMES_IF_OVER_LIMIT = new ConfigOption("deny-homes-if-over-limit");
        this.HIDE_HOMES_IF_DENIED = new ConfigOption("hide-homes-if-denied");
        this.OVERWRITE_SETHOME = new ConfigOption("overwrite-sethome");
        this.SHOW_HOMES_WITH_NO_INPUT = new ConfigOption("show-homes-with-no-input");
        this.PRIORITISE_MAIN_HOME = new ConfigOption("prioritise-main-home");
        this.TPA_REQUEST_RECEIVED = new ConfigOption("tpa-request-received");
        this.TPA_REQUEST_SENT = new ConfigOption("tpa-request-sent");
        this.TPAHERE_REQUEST_RECEIVED = new ConfigOption("tpahere-request-received");
        this.TPAHERE_REQUEST_SENT = new ConfigOption("tpahere-request-sent");
        this.BACK_TELEPORT_CAUSES = new ConfigOption("used-teleport-causes");
        this.BACK_SEARCH_RADIUS = new ConfigOption("back-search-radius");
        this.MAP_HOMES = new MapOptions("homes");
        this.MAP_SPAWNS = new MapOptions("spawns");
        this.MAP_WARPS = new MapOptions("warps");
        this.TELEPORT_TO_SPAWN_FIRST = new ConfigOption("teleport-to-spawn-on-first-join");
        this.FIRST_SPAWN_POINT = new ConfigOption("first-spawn-point");
        this.USE_RANDOM_LOCATION_FIRST_SPAWN_POINT = new ConfigOption("use-random-location-for-first-spawn-point");
        this.FIRST_RANDOM_LOCATION_WORLD_NAME = new ConfigOption("first-random-teleportation-world-name");
        this.SET_RANDOM_FIRST_LOCATION_HOME = new ConfigOption("set-first-random-location-as-home");
        this.TELEPORT_TO_SPAWN_EVERY = new ConfigOption("teleport-to-spawn-on-every-join");
        this.TELEPORT_TO_NEAREST_SPAWN = new ConfigOption("teleport-to-nearest-spawnpoint");
        this.USE_OVERWORLD = new ConfigOption("use-overworld");
        this.DEATH_MANAGEMENT = new ConfigOption("death-management");
        this.DEFAULT_PERMISSIONS = new ConfigOption("default-permissions");
        this.ALLOW_ADMIN_PERMS = new ConfigOption("allow-admin-permissions-as-default-perms");
        this.CHECK_FOR_UPDATES = new ConfigOption("check-for-updates");
        this.NOTIFY_ADMINS = new ConfigOption("notify-admins-on-update");
        this.DEBUG = new ConfigOption("debug");
        this.USE_FLOODGATE_FORMS = new ConfigOption("use-floodgate-forms");
        this.SEND_ACTIONBAR_TO_CONSOLE = new ConfigOption("send-actionbar-to-console");
        this.RETAIN_PASSENGERS = new ConfigOption("retain-passengers");
        this.RETAIN_VEHICLES = new ConfigOption("retain-vehicle");
        this.RETAIN_LIVING_ONLY = new ConfigOption("retain-living-vehicles-only");
        this.TELEPORT_ON_SIGN_SIDE = new ConfigOption("teleport-on-sign-side");
        new PaymentManager();
        LimitationsManager.init();
        List<Object> list = permissions = this.DEFAULT_PERMISSIONS.get() == null ? new ArrayList() : this.DEFAULT_PERMISSIONS.get();
        if (defaults == null) {
            defaults = new ArrayList<String>();
        } else {
            for (String permission : defaults) {
                Permission permission2 = Bukkit.getPluginManager().getPermission(permission);
                if (permission2 == null) continue;
                permission2.setDefault(PermissionDefault.OP);
            }
        }
        boolean warned = false;
        for (String string : permissions) {
            Permission permObject;
            if (!string.startsWith("at")) continue;
            if (string.startsWith("at.admin")) {
                if (!warned) {
                    CoreClass.getInstance().getLogger().warning("WARNING: You've given an admin permission by default to all users.");
                    if (!this.ALLOW_ADMIN_PERMS.get().booleanValue() || CoreClass.getPerms() != null) {
                        CoreClass.getInstance().getLogger().warning("This can potentially be destructive, so we're not adding it right now.");
                        CoreClass.getInstance().getLogger().warning("To allow people to use admin permissions such as the ones specified, please disable the check in the configuration.");
                        CoreClass.getInstance().getLogger().warning("If you have a permissions plugin hooked into Vault too, you cannot make admin permissions default permissions.");
                    } else {
                        CoreClass.getInstance().getLogger().warning("This can potentially be destructive, so if this is not your doing, please check your configuration.");
                        CoreClass.getInstance().getLogger().warning("To stop people to use admin permissions such as the ones specified, please enable the check in the configuration.");
                    }
                    warned = true;
                }
                if (this.ALLOW_ADMIN_PERMS.get().booleanValue() && CoreClass.getPerms() == null) {
                    CoreClass.getInstance().getLogger().info("Allowed default access to " + string);
                } else {
                    CoreClass.getInstance().getLogger().info("Denied default access to " + string);
                    continue;
                }
            }
            if ((permObject = Bukkit.getPluginManager().getPermission(string)) == null) {
                permObject = new Permission(string);
                Bukkit.getPluginManager().addPermission(permObject);
            }
            permObject.setDefault(PermissionDefault.TRUE);
            defaults.add(string);
        }
    }

    public static class ConfigOption<T> {
        private final String path;
        private String defaultPath;

        public ConfigOption(String path) {
            this.path = path;
        }

        public ConfigOption(String path, String defaultPath) {
            this.path = path;
            this.defaultPath = defaultPath;
        }

        public T get() {
            if (this.defaultPath != null && !this.defaultPath.isEmpty()) {
                if (instance.get(this.path).equals("default")) {
                    return (T)instance.get(this.defaultPath);
                }
                return (T)instance.get(this.path);
            }
            return (T)instance.get(this.path);
        }
    }

    public static class PerCommandOption<T> {
        public final ConfigOption<T> TPA;
        public final ConfigOption<T> TPAHERE;
        public final ConfigOption<T> TPR;
        public final ConfigOption<T> WARP;
        public final ConfigOption<T> SPAWN;
        public final ConfigOption<T> HOME;
        public final ConfigOption<T> BACK;

        public PerCommandOption(String path, String defaultPath) {
            this.TPA = new ConfigOption(path + ".tpa", defaultPath);
            this.TPAHERE = new ConfigOption(path + ".tpahere", defaultPath);
            this.TPR = new ConfigOption(path + ".tpr", defaultPath);
            this.WARP = new ConfigOption(path + ".warp", defaultPath);
            this.SPAWN = new ConfigOption(path + ".spawn", defaultPath);
            this.HOME = new ConfigOption(path + ".home", defaultPath);
            this.BACK = new ConfigOption(path + ".back", defaultPath);
        }

        public ConfigOption<T> valueOf(String command) {
            return switch (command) {
                case "tpa" -> this.TPA;
                case "tpahere" -> this.TPAHERE;
                case "tpr" -> this.TPR;
                case "warp" -> this.WARP;
                case "spawn" -> this.SPAWN;
                case "home" -> this.HOME;
                case "back" -> this.BACK;
                default -> null;
            };
        }

        public ConfigOption<T>[] values() {
            return new ConfigOption[]{this.TPA, this.TPAHERE, this.TPR, this.WARP, this.SPAWN, this.HOME, this.BACK};
        }
    }

    public static class MapOptions {
        private final String section;
        private final boolean enabled;
        private final String defaultIcon;
        private final boolean shownByDefault;
        private final String hoverTooltip;
        private final String clickTooltip;
        private final int iconSize;
        private final String layerName;

        public MapOptions(String section) {
            this.section = section;
            this.enabled = MainConfig.get().getBoolean(section + ".enabled");
            this.defaultIcon = MainConfig.get().getString(section + ".default-icon");
            this.shownByDefault = MainConfig.get().getBoolean(section + ".shown-by-default");
            this.hoverTooltip = MainConfig.get().getString(section + ".hover-tooltip");
            this.clickTooltip = MainConfig.get().getString(section + ".click-tooltip");
            this.iconSize = MainConfig.get().getInteger(section + ".icon-size");
            this.layerName = MainConfig.get().getString(section + ".layer-name");
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isShownByDefault() {
            return this.shownByDefault;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public String getClickTooltip() {
            return this.clickTooltip;
        }

        public String getDefaultIcon() {
            return this.defaultIcon;
        }

        public String getHoverTooltip() {
            return this.hoverTooltip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String getSection() {
            return this.section;
        }
    }
}

