/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.NamedLocation;
import io.github.niestrat99.advancedteleport.api.data.ATException;
import io.github.niestrat99.advancedteleport.config.ATConfig;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.impl.CMConfigSection;
import io.github.niestrat99.advancedteleport.libs.paperlib.PaperLib;
import io.github.niestrat99.advancedteleport.managers.PluginHookManager;
import io.github.niestrat99.advancedteleport.utilities.PagedLists;
import io.github.niestrat99.advancedteleport.utilities.PermissionUtil;
import io.github.niestrat99.advancedteleport.utilities.minimessage.PartialComponent;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.SortedSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.geysermc.floodgate.api.FloodgateApi;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomMessages
extends ATConfig {
    public static CustomMessages config;
    private static HashMap<CommandSender, BukkitRunnable> titleManager;
    private static HashMap<CommandSender, BukkitRunnable> actionBarManager;
    private static HashMap<CommandSender, BukkitRunnable> soundManager;
    @NotNull
    private static ImmutableMap<String, PartialComponent> messageCache;
    @NotNull
    private static ImmutableSortedSet<String> prefixes;
    @Nullable
    private static BukkitAudiences audience;

    public CustomMessages() throws Exception {
        super("custom-messages.yml");
        config = this;
        titleManager = new HashMap();
        actionBarManager = new HashMap();
        soundManager = new HashMap();
        this.populate();
        audience = BukkitAudiences.create((Plugin)CoreClass.getInstance());
    }

    public void reload() throws Exception {
        super.reload();
        this.populate();
    }

    public void addDefaults() {
        this.addComment("This messages file uses MiniMessage formatting, a new form of message formatting for newer versions of MC.\nMore information about this formatting can be found here: https://docs.advntr.dev/minimessage/format.html# \nIf you prefer to use the Legacy Code format (i.e. &a, &b, etc.) then you can still use that format.\n\nIt is important to note though that this format may be subject to removal in a future version of AT, however nothing is set in stone yet.");
        this.makeSectionLenient("Common");
        this.addDefault("Common.prefixes", List.of("<aqua>\u2191</aqua> <dark_gray>\u00bb</dark_gray>"), "The prefixes for messages, the first element of this list will be usable as <prefix>,\nwith each element after that being usable as <prefix:index> with index being the items index in the list.\n".trim());
        this.addDefault("Common.timeFormat.full", "<days><hours><minutes><seconds>");
        this.addDefault("Common.timeFormat.days.singular", "<days> day, ");
        this.addDefault("Common.timeFormat.days.plural", "<days> days, ");
        this.addDefault("Common.timeFormat.hours.singular", "<hours> hour, ");
        this.addDefault("Common.timeFormat.hours.plural", "<hours> hours, ");
        this.addDefault("Common.timeFormat.minutes.singular", "<minutes> minute, ");
        this.addDefault("Common.timeFormat.minutes.plural", "<minutes> minutes, ");
        this.addDefault("Common.timeFormat.seconds.singular", "<seconds> second");
        this.addDefault("Common.timeFormat.seconds.plural", "<seconds> seconds");
        this.makeSectionLenient("Teleport");
        this.addDefault("Teleport.eventBeforeTP", "<prefix> <gray>Teleporting in <aqua><countdown-formatted></aqua>, please do not move!");
        this.addComment("Teleport.eventBeforeTP_title", "This is an example use for titles and subtitles in the plugin.\nThis feature is supported only if you're on version 1.8.8 or newer.");
        this.addExample("Teleport.eventBeforeTP_title.length", 80, "How many seconds (in ticks) the header should last. This is not including fading.");
        this.addExample("Teleport.eventBeforeTP_title.fade-in", 0, "How many seconds (in ticks) the header should take to fade in.");
        this.addExample("Teleport.eventBeforeTP_title.fade-out", 10, "How many seconds (in ticks) the header should take to fade out.");
        this.addExample("Teleport.eventBeforeTP_title.0", "<gray><b>Teleporting...");
        this.addExample("Teleport.eventBeforeTP_title.20", "<aqua>></aqua> <gray><b>Teleporting...</b></gray> <aqua><");
        this.addExample("Teleport.eventBeforeTP_title.40", "<aqua>>></aqua> <gray><b>Teleporting...</b></gray> <aqua><<");
        this.addExample("Teleport.eventBeforeTP_title.60", "<aqua>>>> <b><yellow>Teleported!</yellow></b> <aqua><<<");
        this.addExample("Teleport.eventBeforeTP_subtitle.0", "<aqua>Please do not move!");
        this.addExample("Teleport.eventBeforeTP_subtitle.60", "");
        this.addDefault("Teleport.eventBeforeTPMovementAllowed", "<prefix> <gray>Teleporting in <aqua><countdown-formatted></aqua>!");
        this.addDefault("Teleport.eventTeleport", "<prefix> <gray>Teleporting...");
        this.addDefault("Teleport.eventMovement", "<prefix> <gray>Teleport has been cancelled due to movement.");
        this.addDefault("Teleport.eventDamage", "<prefix> <gray>Teleport has been cancelled due to damage being taken.");
        this.addDefault("Teleport.eventMovement_title.length", 60);
        this.addDefault("Teleport.eventMovement_title.fade-in", 0);
        this.addDefault("Teleport.eventMovement_title.fade-out", 10);
        this.addDefault("Teleport.eventMovement_title.0", "<yellow><b>! <red>Cancelled</red> !");
        this.addDefault("Teleport.teleportingToSpawn", "<prefix> <gray>Teleporting you to spawn!");
        this.addDefault("Teleport.teleporting", "<prefix> <gray>Teleporting to <aqua><player></aqua>!");
        this.addDefault("Teleport.teleportingToHome", "<prefix> <gray>Teleporting to <aqua><home></aqua>!");
        this.addDefault("Teleport.teleportingToHomeOther", "<prefix> <gray>Teleporting to <aqua><player></aqua>'s home, <aqua><home></aqua>!");
        this.addDefault("Teleport.teleportingToWarp", "<prefix> <gray>Teleporting you to <aqua><warp></aqua>!");
        this.addDefault("Teleport.teleportingPlayerToSelf", "<prefix> <gray>Teleporting <aqua><player></aqua> to you!");
        this.addDefault("Teleport.teleportingSelfToPlayer", "<prefix> <gray>Teleporting you to <aqua><player></aqua>!");
        this.addDefault("Teleport.teleportingToRandomPlace", "<prefix> <gray>Teleporting you to a random place!");
        this.addDefault("Teleport.teleportingToLastLoc", "<prefix> <gray>Teleporting to your last location!");
        this.addDefault("Teleport.teleportedToOfflinePlayer", "<prefix> <gray>Teleported to offline player <aqua><player></aqua>!");
        this.addDefault("Teleport.teleportedOfflinePlayerHere", "<prefix> <gray>Teleported offline player <aqua><player></aqua> to your location!");
        this.makeSectionLenient("Error");
        this.addDefault("Error.noPermission", "<prefix> <gray>You do not have permission to use this command!");
        this.addDefault("Error.noPermissionSign", "<prefix> <gray>You do not have permission to make this sign!");
        this.addDefault("Error.featureDisabled", "<prefix> <gray>This feature has been disabled!");
        this.addDefault("Error.noRequests", "<prefix> <gray>You do not have any pending requests!");
        this.addDefault("Error.tpOff", "<prefix> <aqua><player> <gray>has their teleportation disabled!");
        this.addDefault("Error.tpBlock", "<prefix> <aqua><player> <gray>has blocked you from sending requests to them!");
        this.addDefault("Error.alreadyOn", "<prefix> <gray>Your teleport requests are already enabled!");
        this.addDefault("Error.alreadyOff", "<prefix> <gray>Your teleport requests are already disabled!");
        this.addDefault("Error.alreadyBlocked", "<prefix> <gray>This player is already blocked!");
        this.addDefault("Error.neverBlocked", "<prefix> <gray>This player was never blocked!");
        this.addDefault("Error.onCooldown", "<prefix> <gray>Please wait another <aqua><time-formatted></aqua> to use this command!");
        this.addDefault("Error.requestSentToSelf", "<prefix> <gray>You can't send a request to yourself!");
        this.addDefault("Error.noSuchPlayer", "<prefix> <gray>The player is either currently offline or doesn't exist!");
        this.addDefault("Error.alreadySentRequest", "<prefix> <gray>You've already sent a request to <aqua><player></aqua>!");
        this.addDefault("Error.notEnoughGeneral", "    <prefix> <gray>You cannot afford to teleport there!\n    <prefix> <gray>You need <aqua><cost></aqua>!\n");
        this.addDefault("Error.notEnoughEXP", "    <prefix> <gray>You do not have enough EXP Levels to teleport there!\n    <prefix> <gray>You need at least <aqua><levels></aqua> EXP levels!\n".trim());
        this.addDefault("Error.notEnoughEXPPoints", "    <prefix> <gray>You do not have enough EXP Points to teleport there!\n    <prefix> <gray>You need at least <aqua><points></aqua> EXP points!\n".trim());
        this.addDefault("Error.notEnoughMoney", "    <prefix> <gray>You do not have enough money to teleport there!\n    <prefix> <gray>You need at least <aqua><amount></aqua>!\n".trim());
        this.addDefault("Error.requestExpired", "<prefix> <gray>Your teleport request to <aqua><player></aqua> has expired!");
        this.addDefault("Error.noPlayerInput", "<prefix> <gray>You must include a player name!");
        this.addDefault("Error.blockSelf", "<prefix> <gray>You can't block yourself!");
        this.addDefault("Error.noRequestsFromPlayer", "<prefix> <gray>You don't have any pending requests from <aqua><player></aqua>!");
        this.addDefault("Error.noRequests", "<prefix> <gray>You don't have any pending requests!");
        this.addDefault("Error.invalidPageNo", "<prefix> <gray>You've inserted an invalid page number!");
        this.addDefault("Error.noHomeInput", "<prefix> <gray>You have to include a home name!");
        this.addDefault("Error.noSuchHome", "<prefix> <gray>This home doesn't exist!");
        this.addDefault("Error.noBedHome", "<prefix> <gray>You don't have any bed spawn set!");
        this.addDefault("Error.noBedHomeOther", "<prefix> <aqua><player></aqua> <gray>doesn't have a bed spawn set!");
        this.addDefault("Error.reachedHomeLimit", "<prefix> <gray>You can't set any more homes!");
        this.addDefault("Error.homeAlreadySet", "<prefix> <gray>You already have a home called <aqua><home></aqua>!");
        this.addDefault("Error.noWarpInput", "<prefix> <gray>You have to include the warp's name!");
        this.addDefault("Error.noSuchWarp", "<prefix> <gray>That warp doesn't exist!");
        this.addDefault("Error.warpAlreadySet", "<prefix> <gray>There is already a warp called <aqua><warp></aqua>!");
        this.addDefault("Error.noSuchWorld", "<prefix> <gray>That world doesn't exist!");
        this.addDefault("Error.worldUnloaded", "<prefix> <gray>Sorry, the destination world either doesn't exist or isn't loaded. Please tell a server admin!");
        this.addDefault("Error.noLocation", "<prefix> <gray>You don't have any location to teleport back to!");
        this.addDefault("Error.notAPlayer", "<prefix> <gray>You must be a player to run this command!");
        this.addDefault("Error.noHomes", "<prefix> <gray>You haven't got any homes!");
        this.addDefault("Error.noHomesOther", "<prefix> <aqua><player></aqua> <gray>hasn't got any homes!");
        this.addDefault("Error.tooFarAway", "<prefix> <gray>The teleport destination is too far away so you can not teleport there!");
        this.addDefault("Error.noRequestsSent", "<prefix> <gray>Couldn't send a request to anyone :(");
        this.addDefault("Error.onCountdown", "<prefix> <gray>You can't use this command whilst waiting to teleport!");
        this.addDefault("Error.noPermissionWarp", "<prefix> <gray>You can't warp to <aqua><warp></aqua>!");
        this.addDefault("Error.cantTPToWorld", "<prefix> <gray>You can't randomly teleport in that world!");
        this.addDefault("Error.cantTPToWorldLim", "<prefix> <gray>You can't teleport to <aqua><world></aqua>!");
        this.addDefault("Error.tooFewArguments", "<prefix> <gray>Too few arguments!");
        this.addDefault("Error.invalidArgs", "<prefix> <gray>Invalid arguments!");
        this.addDefault("Error.noOthersToTP", "<prefix> <gray>There are no players for you to teleport!");
        this.addDefault("Error.cantTPToPlayer", "<prefix> <gray>You can't request a teleportation to <aqua><player></aqua>!");
        this.addDefault("Error.noWarps", "<prefix> <gray>There are no warps as of currently!");
        this.addDefault("Error.noAccessHome", "<prefix> <gray>You cannot access <aqua><home></aqua> as of currently!");
        this.addDefault("Error.moveHomeFail", "<prefix> <gray>The home has been moved but the data has not been stored successfully. The plugin will try to fix this itself.");
        this.addDefault("Error.setMainHomeFail", "<prefix> <gray>The main home has been set but the data has not been stored successfully. The plugin will try to fix this itself.");
        this.addDefault("Error.deleteHomeFail", "<prefix> <gray>The home has been deleted but the data has not been stored successfully. The plugin will try to fix this itself.");
        this.addDefault("Error.setHomeFail", "<prefix> <gray>The home has been set but the data has not been stored successfully. The plugin will try to fix this itself.");
        this.addDefault("Error.deleteWarpFail", "<prefix> <gray>The warp has been set but the data has not been stored successfully. The plugin will try to fix this itself.");
        this.addDefault("Error.purgeWarpsFail", "<prefix> <gray>Could not purge warps. Please check the console for more information.");
        this.addDefault("Error.purgeHomesFail", "<prefix> <gray>Could not purge homes. Please check the console for more information.");
        this.addDefault("Error.homesNotLoaded", "<prefix> <gray>Homes for this player haven't loaded yet, please wait a little bit (even just a second) before trying this again!");
        this.addDefault("Error.noOfflineLocation", "<prefix> <gray>No offline location was found for <aqua><player></aqua>!");
        this.addDefault("Error.failedOfflineTeleport", "<prefix> <gray>Failed to teleport to offline player <aqua><player></aqua>!");
        this.addDefault("Error.failedOfflineTeleportHere", "<prefix> <gray>Failed to teleport offline player <aqua><player></aqua> to your location!");
        this.addDefault("Error.alreadySearching", "<prefix> <gray>Already searching for a location to teleport to!");
        this.addDefault("Error.mirrorSpawnNoArguments", "<prefix> <gray>No worlds/spawn points have been specified!");
        this.addDefault("Error.mirrorSpawnLackOfArguments", "<prefix> <gray>You must be a player to only specify one world - please specify a world and a spawnpoint to mirror players to!");
        this.addDefault("Error.noSuchSpawn", "<prefix> <gray>There is no such spawn called <aqua><spawn></aqua>!");
        this.addDefault("Error.cannotSetMainSpawn", "<prefix> <gray>You can only make existing spawnpoints into the main spawnpoint rather than create new ones!");
        this.addDefault("Error.cannotSetMainSpawnConsole", "<prefix> <gray>You can only make existing spawnpoints into the main spawnpoint rather than create new ones since you are not a player!");
        this.addDefault("Error.nonAlphanumericSpawn", "<prefix> <gray>Spawnpoints need to be alphanumeric!");
        this.addDefault("Error.removeSpawnNoArgs", "<prefix> <gray>You have to specify a spawnpoint to remove!");
        this.addDefault("Error.noSuchPlugin", "<prefix> <gray>This plugin is not supported for importing/exporting yet!");
        this.addDefault("Error.cantImport", "<prefix> <gray>Can't import plugin data from <aqua><plugin></aqua> (make sure it's enabled and by the correct authors)!");
        this.addDefault("Error.cantExport", "<prefix> <gray>Can't export plugin data from <aqua><plugin></aqua> (make sure it's enabled and by the correct authors)!");
        this.addDefault("Error.noPluginSpecified", "<prefix> <gray>You need to specify a plugin to import/export from!");
        this.addDefault("Error.invalidOption", "<prefix> <gray>That is not a valid option to import/export!");
        this.addDefault("Error.notEnoughItems", "    <prefix> <gray>You do not have enough items to teleport there!\n    <prefix> <gray>You need at least <aqua><amount></aqua> <type>(s)!\n".trim());
        this.addDefault("Error.mirrorSpawnFail", "<prefix> <gray>Failed to mirror <aqua><from></aqua>'s spawnpoint to <aqua><spawn></aqua>!");
        this.addDefault("Error.removeSpawnFail", "<prefix> <gray>Failed to remove the spawnpoint <aqua><spawn></aqua>!");
        this.addDefault("Error.setMainSpawnFail", "<prefix> <gray>Failed to set the main spawnpoint <aqua><spawn></aqua>!");
        this.addDefault("Error.blockFail", "<prefix> <gray>Failed to save the block against <aqua><player></aqua>!");
        this.addDefault("Error.unblockFail", "<prefix> <gray>Failed to save the block removal against <aqua><player></aqua>!");
        this.addDefault("Error.noParticlePlugins", "<prefix> <gray>There are no particle plugins on this server! You need at least one (PlayerParticles) to use this command.");
        this.addDefault("Error.notEnoughArgs", "<prefix> <gray>You haven't specified enough arguments to run this command!");
        this.addDefault("Error.failedMapIconUpdate", "<prefix> <gray>Failed to update the map icon! Please check the console for more information.");
        this.addDefault("Error.setWarpFail", "<prefix> <gray>Failed to set the warp <warp>!");
        this.addDefault("Error.teleportFailed", "<prefix> <gray>Sorry, we couldn't teleport you :(");
        this.addDefault("Error.randomLocFailed", "<prefix> <gray>Sorry, we couldn't find a location to teleport you to :(");
        this.addDefault("Error.commandUse", "<aqua>Usage: <gray><usage>");
        this.addDefault("Error.rtpManagerNotUsed", "<prefix> <gray>The RTP-Cache is not being used on the server.");
        this.makeSectionLenient("Info");
        this.addDefault("Info.tpOff", "<prefix> <gray>Successfully disabled teleport requests!");
        this.addDefault("Info.tpOn", "<prefix> <gray>Successfully enabled teleport requests!");
        this.addDefault("Info.tpAdminOff", "<prefix> <gray>Successfully disabled teleport requests for <aqua><player></aqua>!");
        this.addDefault("Info.tpAdminOn", "<prefix> <gray>Successfully enabled teleport requests for <aqua><player></aqua>!");
        this.addDefault("Info.requestSent", "    <prefix> <gray>Successfully sent request to <aqua><player></aqua>!\n    <prefix> <gray>They've got <aqua><lifetime></aqua> to respond!\n    <prefix> <gray>To cancel the request use <aqua>/tpcancel</aqua> to cancel it.\n\n                        <click:run_command:'/tpcancel <player>'><hover:show_text:'<red>Click here to cancel the request.'><gray><bold>[CANCEL]</hover></click>\n".stripIndent());
        this.addDefault("Info.tpaRequestReceived", "    <prefix> <gray>The player <aqua><player></aqua> wants to teleport to you!\n    <prefix> <gray>If you want to accept it, use <aqua>/tpayes</aqua>, but if not, use <aqua>/tpano</aqua>.\n    <prefix> <gray>You've got <aqua><lifetime></aqua> to respond to it!\n\n                        <click:run_command:'/tpayes <player>'><hover:show_text:'<green>Click here to accept the request.'><green><bold>[ACCEPT]</hover></click>             <click:run_command:'/tpano <player>'><hover:show_text:'<red>Click here to deny the request.'><red><bold>[DENY]</red></bold></hover></click>\n".stripIndent());
        this.addDefault("Info.tpaRequestHere", "    <prefix> <gray>The player <aqua><player></aqua> wants to teleport you to them!\n    <prefix> <gray>If you want to accept it, use <aqua>/tpayes</aqua>, but if not, use <aqua>/tpano</aqua>.\n    <prefix> <gray>You've got <aqua><lifetime-formatted></aqua> to respond to it!\n\n                      <click:run_command:'/tpayes <player>'><hover:show_text:'<green>Click here to accept the request.'><green><bold>[ACCEPT]</bold></hover></click>             <click:run_command:'/tpano <player>'><hover:show_text:'<red>Click here to deny the request.'><red><bold>[DENY]</red></bold></hover></click>\n".stripIndent());
        this.addDefault("Info.blockPlayer", "<prefix> <aqua><player> <gray>has been blocked.");
        this.addDefault("Info.tpCancel", "<prefix> <gray>You have cancelled your teleport request.");
        this.addDefault("Info.tpCancelResponder", "<prefix> <aqua><player> <gray>has cancelled their teleport request.");
        this.addDefault("Info.multipleRequestsCancel", "<prefix> <gray>You have multiple teleport requests pending! Click one of the following to cancel:");
        this.addDefault("Info.multipleRequestsIndex", "<prefix> <click:run_command:<command> <player>><player></click>");
        this.addDefault("Info.multipleRequestsList", "<prefix> <gray>Do /tpalist <Page Number> To check other requests.");
        this.addDefault("Info.multipleRequestAccept", "<prefix> <gray>You have multiple teleport requests pending! Click one of the following to accept:");
        this.addDefault("Info.multipleRequestDeny", "<prefix> <gray>You have multiple teleport requests pending! Click one of the following to deny:");
        this.addDefault("Info.requestDeclined", "<prefix> <gray>You've declined the teleport request!");
        this.addDefault("Info.requestDeclinedResponder", "<prefix> <gray><aqua><player></aqua> has declined your teleport request!");
        this.addDefault("Info.requestDisplaced", "<prefix> <gray>Your request has been cancelled because <aqua><player></aqua> got another request!");
        this.addDefault("Info.deletedHome", "<prefix> <gray>Successfully deleted the home <aqua><home></aqua>!");
        this.addDefault("Info.deletedHomeOther", "<prefix> <gray>Successfully deleted the home <aqua><home></aqua> for <aqua><player></aqua>!");
        this.addDefault("Info.setHome", "<prefix> <gray>Successfully set the home <aqua><home></aqua>!");
        this.addDefault("Info.setHomeOther", "<prefix> <gray>Successfully set the home <aqua><home></aqua> for <aqua><player></aqua>!");
        this.addDefault("Info.setSpawn", "<prefix> <gray>Successfully set the spawnpoint!");
        this.addDefault("Info.setWarp", "<prefix> <gray>Successfully set the warp <aqua><warp></aqua>!");
        this.addDefault("Info.deletedWarp", "<prefix> <gray>Successfully deleted the warp <aqua><warp></aqua>!");
        this.addDefault("Info.purgeWarpsWorld", "<prefix> <gray>Successfully purged warps in <aqua><world></aqua>!");
        this.addDefault("Info.purgeWarpsCreator", "<prefix> <gray>Successfully purged warps created by <aqua><player></aqua>!");
        this.addDefault("Info.purgeHomesWorld", "<prefix> <gray>Successfully purged homes in <aqua><world></aqua>!");
        this.addDefault("Info.purgeHomesCreator", "<prefix> <gray>Successfully purged homes created for <aqua><player></aqua>!");
        this.addDefault("Info.searching", "<prefix> <gray>Searching for a location...");
        this.addDefault("Info.unblockPlayer", "<prefix> <gray>Successfully unblocked <aqua><player></aqua>!");
        this.addDefault("Info.reloadingConfig", "<prefix> <gray>Reloading <aqua>AdvancedTeleport</aqua>'s config...");
        this.addDefault("Info.reloadedConfig", "<prefix> <gray>Finished reloading the config!");
        this.addDefault("Info.warps", "<aqua><bold>Warps <dark_gray>\u00bb <reset>");
        this.addDefault("Info.homes", "<aqua><bold>Homes <dark_gray>\u00bb <reset>");
        this.addDefault("Info.homesOther", "<aqua><bold><player>'s homes <dark_gray>\u00bb <reset>");
        this.addDefault("Info.requestAccepted", "<prefix> <gray>You've accepted the teleport request!");
        this.addDefault("Info.requestAcceptedResponder", "<prefix> <gray><aqua><player></aqua> has accepted the teleport request!");
        this.addDefault("Info.paymentVault", "<prefix> <gray>You have paid <aqua><amount></aqua> and now have <aqua><balance></aqua>!");
        this.addDefault("Info.paymentEXP", "<prefix> <gray>You have paid <aqua><amount> EXP Levels</aqua> and now have <aqua><levels></aqua> levels!");
        this.addDefault("Info.paymentPoints", "<prefix> <gray>You have paid <aqua><amount> EXP Points</aqua> and now have <aqua><points></aqua> points!");
        this.addDefault("Info.createdWarpSign", "<prefix> <gray>Successfully created the warp sign!");
        this.addDefault("Info.createdRTPSign", "<prefix> <gray>Successfully created the RandomTP sign!");
        this.addDefault("Info.createdSpawnSign", "<prefix> <gray>Successfully created the spawn sign!");
        this.addDefault("Info.tpallRequestSent", "<prefix> <gray>Successfully sent a teleport request to <aqua><amount></aqua> player(s)!");
        this.addDefault("Info.teleportedToLoc", "<prefix> <gray>Successfully teleported you to <aqua><x></aqua>, <aqua><y></aqua>, <aqua><z></aqua>! (Yaw: <aqua><yaw></aqua>, Pitch: <aqua><pitch></aqua>, World: <aqua><world></aqua>)");
        this.addDefault("Info.teleportedToLocOther", "<prefix> <gray>Successfully teleported <aqua><player></aqua> to <aqua><x></aqua>, <aqua><y></aqua>, <aqua><z></aqua>! (Yaw: <aqua><yaw></aqua>, Pitch: <aqua><pitch></aqua>, World: <aqua><world></aqua>)");
        this.addDefault("Info.movedWarp", "<prefix> <gray>Moved <aqua><warp></aqua> to your current location!");
        this.addDefault("Info.movedHome", "<prefix> <gray>Moved home <aqua><home></aqua> to your current location!");
        this.addDefault("Info.movedHomeOther", "<prefix> <gray>Moved <aqua><player>'s </aqua> home <aqua><home></aqua> to your location!");
        this.addDefault("Info.setMainHome", "<prefix> <gray>Made <aqua><home></aqua> your main home!");
        this.addDefault("Info.setAndMadeMainHome", "<prefix> <gray>Set <aqua><home></aqua> at your current location and made it your main home!");
        this.addDefault("Info.setMainHomeOther", "<prefix> <gray>Made <aqua><home> <player></aqua>'s main home!");
        this.addDefault("Info.setAndMadeMainHomeOther", "<prefix> <gray>Set <aqua><home></aqua> for <aqua><player></aqua> at your current location and made it their main home!");
        this.addDefault("Info.mirroredSpawn", "<prefix> <gray>Mirrored <aqua><from></aqua>'s spawnpoint to <aqua><spawn></aqua>!");
        this.addDefault("Info.setMainSpawn", "<prefix> <gray>Set the main spawnpoint to <aqua><spawn></aqua>! All players will teleport there if there are no overriding spawns/permissions.");
        this.addDefault("Info.removedSpawn", "<prefix> <gray>Removed the spawnpoint <aqua><spawn></aqua>!");
        this.addDefault("Info.setSpawnSpecial", "<prefix> <gray>Set spawnpoint <aqua><spawn></aqua>!");
        this.addDefault("Info.importStarted", "<prefix> <gray>Starting import from <aqua><plugin></aqua>...");
        this.addDefault("Info.importFinished", "<prefix> <gray>Finished import from <aqua><plugin></aqua>!");
        this.addDefault("Info.exportStarted", "<prefix> <gray>Starting export to <aqua><plugin></aqua>...");
        this.addDefault("Info.exportFinished", "<prefix> <gray>Finished export to <aqua><plugin></aqua>!");
        this.addDefault("Info.paymentItems", "<prefix> <gray>You have paid <aqua><amount> <type>(s)</aqua> for that teleport!");
        this.addDefault("Info.updateInfo", "<prefix> <hover:show_text:'<aqua>Current Version <dark_gray>\u00bb <gray><version>\n<aqua>New Version <dark_gray>\u00bb <gray><new-version>\n<aqua>Title <dark_gray>\u00bb <gray><title>'><click:open_url:'https://www.spigotmc.org/resources/advancedteleport.64139/'><gray>AdvancedTeleport has an update available! Click/hover over this text for more information.</click></hover>".trim());
        this.addDefault("Info.defaultParticlesUpdated", "<prefix> <gray>The default waiting particles have been set to your current particle setup!");
        this.addDefault("Info.specificParticlesUpdated", "<prefix> <gray>The waiting particles settings for <aqua><type></aqua> have been set to your current particle setup!");
        this.addDefault("Info.mapIconUpdateClickTooltip", "<prefix> <gray>Updated click tooltip for <type> <aqua><name></aqua>! The map should update shortly.");
        this.addDefault("Info.mapIconUpdateHoverTooltip", "<prefix> <gray>Updated hover tooltip for <type> <aqua><name></aqua>! The map should update shortly.");
        this.addDefault("Info.mapIconUpdateIcon", "<prefix> <gray>Updated the icon for <type> <aqua><name></aqua>! The map should update shortly.");
        this.addDefault("Info.mapIconUpdateSize", "<prefix> <gray>Updated the icon size for <type> <aqua><name></aqua>! The map should update shortly.");
        this.addDefault("Info.mapIconUpdateVisibility", "<prefix> <gray>Updated the icon visibility for <type> <aqua><name></aqua>! The map should update shortly.");
        this.addDefault("Info.mirrorSpawnSame", "<prefix> <gray>The spawns for <aqua><from></aqua> and <aqua><spawn></aqua> already to go the same place! Don't worry :)");
        this.addDefault("Info.clearEverything", "<prefix> <gray>The RTP-Cache has been cleared.");
        this.addDefault("Info.clearWorld", "<prefix> <gray>Cache for world <aqua><world></aqua> has been cleared.");
        this.addDefault("Tooltip.homes", "<prefix> <gray>Teleports you to your home: <aqua><home>");
        this.addDefault("Tooltip.warps", "<prefix> <gray>Teleports you to warp: <aqua><warp>");
        this.addDefault("Tooltip.location", "\n<aqua>X <dark_gray>\u00bb <gray><x>\n<aqua>Y <dark_gray>\u00bb <gray><y>\n<aqua>Z <dark_gray>\u00bb <gray><z>\n<aqua>World <dark_gray>\u00bb <gray><world>");
        this.addDefault("Menu.Help.header", "<aqua>\u30fb\uff0e<gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray> <dark_gray>\u2770</dark_gray> <bold>Advanced Teleport</bold> <gray><current_page>/<total_pages> <dark_gray>\u2771</dark_gray> <gray>\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501</gray>\uff0e\u30fb");
        this.addDefault("Menu.Help.option", "<dark_gray>\u00bb <aqua><usage></aqua> ~ <gray><description>");
        this.addDefault("Descriptions.Subcommands.help", "Sends the help menu, providing a full list of commands.");
        this.addDefault("Descriptions.Subcommands.info", "Sends information regarding the plugin.");
        this.addDefault("Descriptions.Subcommands.import", "Imports data from another plugin so that it can be used within AT.");
        this.addDefault("Descriptions.Subcommands.export", "Exports data within AT to another plugin.");
        this.addDefault("Descriptions.Subcommands.reload", "Reloads the plugin's configuration.");
        this.addDefault("Descriptions.Subcommands.clearcache", "Clears the RTP cache.");
        this.addDefault("Descriptions.Subcommands.map.setclicktooltip", "Sets the tooltip of an AT icon in a map plugin when it is clicked (excluding Dynmap).");
        this.addDefault("Descriptions.Subcommands.map.sethovertooltip", "Sets the tooltip of an AT icon in a map plugin when it is hovered over.");
        this.addDefault("Descriptions.Subcommands.map.seticon", "Sets the image of an AT icon in a map plugin.");
        this.addDefault("Descriptions.Subcommands.map.setsize", "Sets the size of an AT icon in a map plugin (excluding Dynmap).");
        this.addDefault("Descriptions.Subcommands.map.setvisible", "Sets the visibility of an AT icon in a map plugin when it is clicked.");
        this.addDefault("Descriptions.at", "The core command for AT.");
        this.addDefault("Descriptions.tpa", "Sends a request to teleport to the player.");
        this.addDefault("Descriptions.tpahere", "Sends a request to the player to teleport to you.");
        this.addDefault("Descriptions.tpyes", "Accepts a player's teleport request.");
        this.addDefault("Descriptions.tpno", "Declines a player's teleport request.");
        this.addDefault("Descriptions.tpcancel", "Cancels your teleport request to a player.");
        this.addDefault("Descriptions.toggletp", "Either stops or allows players to send teleport requests to you.");
        this.addDefault("Descriptions.tpon", "Allows players to send teleport requests to you.");
        this.addDefault("Descriptions.tpoff", "Stops players from sending teleport requests to you.");
        this.addDefault("Descriptions.tpblock", "Stops a specific player from sending teleport requests to you.");
        this.addDefault("Descriptions.tpunblock", "Allows a blocked player to send you teleport requests again.");
        this.addDefault("Descriptions.back", "Teleports you to your previous location.");
        this.addDefault("Descriptions.tpalist", "Lists all of your current teleport requests.");
        this.addDefault("Descriptions.tpo", "Instantly teleports you to a player.");
        this.addDefault("Descriptions.tpohere", "Instantly teleports a player to you.");
        this.addDefault("Descriptions.tpall", "Sends a teleport request to everyone in the server to you.");
        this.addDefault("Descriptions.tploc", "Teleports you to a specific location.");
        this.addDefault("Descriptions.tpoffline", "Teleports you to an offline player.");
        this.addDefault("Descriptions.tpofflinehere", "Teleports an offline player to you.");
        this.addDefault("Descriptions.tpr", "Teleports you to a random location.");
        this.addDefault("Descriptions.warp", "Teleports you to a given warp point.");
        this.addDefault("Descriptions.warps", "Gives you a list of warps you can teleport to.");
        this.addDefault("Descriptions.setwarp", "Sets a warp at your location.");
        this.addDefault("Descriptions.delwarp", "Deletes a warp.");
        this.addDefault("Descriptions.movewarp", "Moves a warp to a new location.");
        this.addDefault("Descriptions.spawn", "Teleports you to the spawnpoint.");
        this.addDefault("Descriptions.setspawn", "Sets a spawn with a name when specified.");
        this.addDefault("Descriptions.mirrorspawn", "Redirects people using /spawn in one world to another spawn point.");
        this.addDefault("Descriptions.setmainspawn", "Sets a specified spawnpoint to become the main spawnpoint. If it does not exist, it will be created if you have /setspawn permissions.");
        this.addDefault("Descriptions.removespawn", "Removes a specified spawnpoint. If none is specified, the one in your current world is removed.");
        this.addDefault("Descriptions.home", "Teleports you to your home.");
        this.addDefault("Descriptions.homes", "Gives you a list of homes you've set.");
        this.addDefault("Descriptions.sethome", "Sets a home at your current location.");
        this.addDefault("Descriptions.delhome", "Deletes a home.");
        this.addDefault("Descriptions.movehome", "Moves a home to a new location.");
        this.addDefault("Descriptions.setmainhome", "Sets a home at your location or makes an existing one your main home.");
        this.addDefault("Descriptions.purge", "Removes all warps or homes for the specified player or world.");
        this.addDefault("Descriptions.particles", "Ports your current particle selection to the default waiting particles configuration, or a command one.");
        this.addDefault("Usages.Subcommands.help", "/at help [Category|Page]");
        this.addDefault("Usages.Subcommands.info", "/at info");
        this.addDefault("Usages.Subcommands.import", "/at import <Plugin> [All|Homes|LastLocs|Warps|Spawns|Players]");
        this.addDefault("Usages.Subcommands.export", "/at export <Plugin> [All|Homes|LastLocs|Warps|Spawns|Players]");
        this.addDefault("Usages.Subcommands.purge", "/at purge <Homes|Warps> <Player|World> <Player Name|World Name>");
        this.addDefault("Usages.Subcommands.reload", "/at reload");
        this.addDefault("Usages.Subcommands.clearcache", "/at clearcache [World]");
        this.addDefault("Usages.Subcommands.particles", "/at particles [Tpa|Tpahere|Home|Tpr|Warp|Spawn|Back]");
        this.addDefault("Usages.Subcommands.map.setclicktooltip", "/at map setclicktooltip <Home|Warp|Spawn> [Home Owner] <Tooltip>");
        this.addDefault("Usages.Subcommands.map.sethovertooltip", "/at map sethovertooltip <Home|Warp|Spawn> [Home Owner] <Tooltip>");
        this.addDefault("Usages.Subcommands.map.seticon", "/at map seticon <Home|Warp|Spawn> [Home Owner] <Image Name>");
        this.addDefault("Usages.Subcommands.map.setsize", "/at map setsize <Home|Warp|Spawn> [Home Owner] <Image Size>");
        this.addDefault("Usages.Subcommands.map.setvisible", "/at map setvisible <Home|Warp|Spawn> [Home Owner] <true|false>");
        this.addDefault("Usages.at", "/at <Command>");
        this.addDefault("Usages.tpa", "/tpa <Player>");
        this.addDefault("Usages.tpahere", "/tpahere <Player>");
        this.addDefault("Usages.tpyes", "/tpyes [Player]");
        this.addDefault("Usages.tpno", "/tpno [Player]");
        this.addDefault("Usages.tpcancel", "/tpcancel [Player]");
        this.addDefault("Usages.toggletp", "/toggletp");
        this.addDefault("Usages.tpon", "/tpon");
        this.addDefault("Usages.tpoff", "/tpoff");
        this.addDefault("Usages.tpblock", "/tpblock <Player> [Reason]");
        this.addDefault("Usages.tpunblock", "/tpunblock <Player>");
        this.addDefault("Usages.back", "/back");
        this.addDefault("Usages.tpalist", "/tpalist");
        this.addDefault("Usages.tpo", "/tpo <Player>");
        this.addDefault("Usages.tpohere", "/tpohere <Player>");
        this.addDefault("Usages.tpall", "/tpall");
        this.addDefault("Usages.tploc", "/tploc <x|~> <y|~> <z|~> [Yaw|~] [Pitch|~] [World|~] [Player] [precise|noflight]");
        this.addDefault("Usages.tpoffline", "/tpoffline <Player>");
        this.addDefault("Usages.tpofflinehere", "/tpofflinehere <Player>");
        this.addDefault("Usages.tpr", "/tpr [World]");
        this.addDefault("Usages.warp", "/warp <Warp>");
        this.addDefault("Usages.warps", "/warps");
        this.addDefault("Usages.setwarp", "/setwarp <Name>");
        this.addDefault("Usages.delwarp", "/delwarp <Name>");
        this.addDefault("Usages.movewarp", "/movewarp <Name>");
        this.addDefault("Usages.spawn", "/spawn");
        this.addDefault("Usages.setspawn", "/setspawn [ID]");
        this.addDefault("Usages.mirrorspawn", "/mirrorspawn <To Point>|[From World] [To Point]");
        this.addDefault("Usages.setmainspawn", "/setmainspawn [Point]");
        this.addDefault("Usages.removespawn", "/removespawn [Point]");
        this.addDefault("Usages.home", "/home [Home]");
        this.addDefault("Usages.homes", "/homes");
        this.addDefault("Usages.sethome", "/sethome <Name>");
        this.addDefault("Usages.delhome", "/delhome <Home>");
        this.addDefault("Usages.movehome", "/movehome <Home>");
        this.addDefault("Usages.setmainhome", "/setmainhome <Home>");
        this.addDefault("Usages-Admin.tpr", "/tpr [World] [Player]");
        this.addDefault("Usages-Admin.home", "/home [Home]|<Player> <Home>");
        this.addDefault("Usages-Admin.homes", "/homes [Player]");
        this.addDefault("Usages-Admin.delhome", "/delhome <Home>|<Player> <Home>");
        this.addDefault("Usages-Admin.sethome", "/sethome <Name>|<Player> <Name>");
        this.addDefault("Usages-Admin.movehome", "/movehome <Home>|<Player> <Home>");
        this.addDefault("Usages-Admin.setmainhome", "/setmainhome <Home>|<Player> <Home>");
        this.addDefault("Usages-Admin.spawn", "/spawn <ID>");
        this.addDefault("Signs.bed", "<blue><bold>[Bed]</bold></blue>");
        this.addDefault("Signs.home", "<blue><bold>[Home]</bold></blue>");
        this.addDefault("Signs.homes", "<blue><bold>[Homes]</bold></blue>");
        this.addDefault("Signs.randomtp", "<blue><bold>[RandomTP]</bold></blue>");
        this.addDefault("Signs.spawn", "<blue><bold>[Spawn]</bold></blue>");
        this.addDefault("Signs.warp", "<blue><bold>[Warp]</bold></blue>");
        this.addDefault("Signs.warps", "<blue><bold>[Warps]</bold></blue>");
        this.addFormsDefault("tpahere", "TPAHere Request", "Select a player to send a TPAHere request to.");
        this.addFormsDefault("tpa", "TPA Request", "Select a player to send a TPA request to.");
        this.addFormsDefault("tpa-received", "TPA Request", "The player <player> wants to teleport to you!");
        this.addDefault("Forms.tpa-received-accept", "Accept");
        this.addDefault("Forms.tpa-received-deny", "Deny");
        this.addFormsDefault("tpahere-received", "TPAHere Request", "The player <player> wants you to teleport to them!");
        this.addDefault("Forms.tpahere-received-accept", "Accept");
        this.addDefault("Forms.tpahere-received-deny", "Deny");
        this.addFormsDefault("home", "Homes", "Select a home to teleport to.");
        this.addFormsDefault("sethome", "Set Home", "Enter a home name.");
        this.addFormsDefault("delhome", "Delete Home", "Select the home to delete.");
        this.addFormsDefault("setmainhome", "Set Main Home", "Enter an existing home name or a new one.");
        this.addFormsDefault("movehome", "Move Home", "Choose the home to be moved.");
        this.addFormsDefault("warp", "Warps", "Select a warp to teleport to.");
        this.addFormsDefault("delwarp", "Delete Warp", "Select a warp to delete.");
        this.addFormsDefault("setwarp", "Set Warp", "Enter a warp name.");
        this.addFormsDefault("movewarp", "Move Warp", "Select a warp to move.");
        this.addFormsDefault("tpblock", "Block Player", "Select a player to block.");
        this.addFormsDefault("tpunblock", "Unblock Player", "Select a player to unblock.");
        this.addFormsDefault("tpcancel", "Cancel TP Request", "Select a request to cancel.");
        this.addFormsDefault("tpo", "Teleport", "Select a player to teleport to.");
        this.addFormsDefault("tpohere", "Teleport Here", "Select a player to teleport to your location.");
    }

    public void moveToNew() {
        this.moveTo("Error.noHomesOtherPlayer", "Error.noHomesOther");
    }

    @NotNull
    public static Component get(@NotNull String path, TagResolver ... placeholders) throws IllegalArgumentException {
        if (config == null) {
            throw new IllegalStateException("Config not initialized");
        }
        PartialComponent partial = (PartialComponent)messageCache.get((Object)path);
        if (partial == null) {
            return Component.empty();
        }
        if (placeholders == null || placeholders.length == 0) {
            return partial.get(new TagResolver[0]);
        }
        return partial.get(placeholders);
    }

    @NotNull
    public static Component getComponent(@NotNull String path, TagResolver ... placeholders) {
        return CustomMessages.get(path, placeholders);
    }

    @NotNull
    public static Component translate(@NotNull String text, TagResolver ... placeholders) {
        return MiniMessage.miniMessage().deserialize(CustomMessages.translateLegacy(text), placeholders);
    }

    @NotNull
    public static String asString(@NotNull String path, TagResolver ... placeholders) {
        return PlainTextComponentSerializer.plainText().serialize(CustomMessages.get(path, placeholders));
    }

    @NotNull
    public static String asString(@NotNull String path) {
        return CustomMessages.asString(path, null);
    }

    public static void sendMessage(@NotNull CommandSender sender, @NotNull String path, @NotNull Function<String, String> preProcess, final TagResolver ... placeholders) {
        if (config == null) {
            return;
        }
        if (sender instanceof Player) {
            final Player player = (Player)sender;
            String mainPath = path;
            CustomMessages.handleSpecialMessage(player, (String)path + "_actionbar", content -> CustomMessages.asAudience((CommandSender)player).sendActionBar(CustomMessages.translate(content, placeholders)), actionBarManager);
            CustomMessages.handleSpecialMessage(player, (String)path + "_sound", sound -> CustomMessages.sendSound(player, sound, mainPath), soundManager);
            final @Nullable ConfigSection titles = config.getConfigSection((String)path + "_title");
            final @Nullable ConfigSection subtitles = config.getConfigSection((String)path + "_subtitle");
            if (titles != null || subtitles != null) {
                CoreClass.debug("Found special message format - titles: " + String.valueOf(titles) + ", subtitles: " + String.valueOf(subtitles));
                final int[] titleInfo = new int[]{0, 0, 0};
                if (titles != null) {
                    titleInfo[0] = titles.getInteger("fade-in");
                    titleInfo[1] = titles.getInteger("length");
                    titleInfo[2] = titles.getInteger("fade-out");
                }
                BukkitRunnable titleRunnable = new BukkitRunnable(){
                    private int current = 0;
                    @Nullable
                    private Component previousTitle = null;
                    @Nullable
                    private Component previousSubtitle = null;

                    public void run() {
                        Object object;
                        Object object2;
                        if (this.current == titleInfo[1] || titleManager.get(player) != this) {
                            this.cancel();
                            return;
                        }
                        String title = null;
                        String subtitle = null;
                        if (titles != null) {
                            title = titles.getString(String.valueOf(this.current));
                        }
                        if (subtitles != null) {
                            subtitle = subtitles.getString(String.valueOf(this.current));
                        }
                        Audience audience = CustomMessages.asAudience((CommandSender)player);
                        if (title == null) {
                            object2 = this.previousTitle == null ? Component.empty() : this.previousTitle;
                        } else {
                            this.previousTitle = CustomMessages.translate(title, placeholders);
                            object2 = this.previousTitle;
                        }
                        if (subtitle == null) {
                            object = this.previousSubtitle == null ? Component.empty() : this.previousSubtitle;
                        } else {
                            this.previousSubtitle = CustomMessages.translate(subtitle, placeholders);
                            object = this.previousSubtitle;
                        }
                        audience.showTitle(Title.title((Component)object2, (Component)object, (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)titleInfo[0] * 50L), (Duration)Duration.ofMillis((long)(titleInfo[1] - this.current) * 50L), (Duration)Duration.ofMillis((long)titleInfo[2] * 50L))));
                        ++this.current;
                    }
                };
                titleManager.put((CommandSender)player, titleRunnable);
                titleRunnable.runTaskTimer((Plugin)CoreClass.getInstance(), 1L, 1L);
            }
        } else {
            String raw = config.getString((String)path);
            if (MainConfig.get().SEND_ACTIONBAR_TO_CONSOLE.get().booleanValue() && (raw == null || raw.isEmpty())) {
                path = (String)path + "_actionbar";
            }
        }
        TextComponent.Builder component = Component.text();
        if (config.get((String)path) instanceof List) {
            config.getStringList((String)path).forEach(line -> component.append(CustomMessages.translate((String)preProcess.apply((String)line), placeholders)));
        } else if (config.getString((String)path) != null && !config.getString((String)path).isEmpty()) {
            component.append(CustomMessages.get((String)path, placeholders));
        }
        if (component.content().isEmpty() && component.children().isEmpty()) {
            return;
        }
        CustomMessages.sendMessage(sender, component.asComponent());
    }

    @Contract(pure=true)
    public static void sendMessage(@NotNull CommandSender sender, @NotNull Component component) {
        if (PaperLib.isPaper()) {
            CustomMessages.asAudience(sender).sendMessage(component);
        } else {
            BungeeComponentSerializer serializer = BungeeComponentSerializer.get();
            sender.spigot().sendMessage(serializer.serialize(component));
        }
    }

    @Contract(pure=true)
    private static void appendNonEmpty(@NotNull TextComponent.Builder base, @NotNull Function<String, String> preProcess, @NotNull String line, TagResolver ... placeholders) {
        if (line.isEmpty()) {
            return;
        }
        Component component = CustomMessages.translate(preProcess.apply(line), placeholders);
        base.append(component);
        TextComponent.Builder component2 = Component.text();
        component2.append(component);
    }

    public static void sendMessage(@NotNull CommandSender sender, @NotNull String path, TagResolver ... placeholders) {
        CustomMessages.sendMessage(sender, path, Function.identity(), placeholders);
    }

    @Contract(pure=true)
    @NotNull
    public static String contextualPath(@NotNull CommandSender sender, @NotNull UUID target, @NotNull String path) {
        OfflinePlayer player;
        return sender instanceof OfflinePlayer && (player = (OfflinePlayer)sender).getUniqueId() == target ? path : path + "Other";
    }

    @Contract(pure=true)
    @NotNull
    public static String contextualPath(@NotNull CommandSender sender, @NotNull OfflinePlayer target, @NotNull String path) {
        return CustomMessages.contextualPath(sender, target.getUniqueId(), path);
    }

    @Contract(pure=true)
    public static void failableContextualPath(@NotNull CommandSender sender, @NotNull UUID target, @NotNull String path, @NotNull String errorPath, @Nullable Throwable error, TagResolver ... placeholders) {
        String truePath = error != null ? errorPath : CustomMessages.contextualPath(sender, target, path);
        CustomMessages.sendMessage(sender, truePath, placeholders);
        if (error != null && !(error instanceof ATException)) {
            error.printStackTrace();
        }
    }

    @Contract(pure=true)
    public static void failableContextualPath(@NotNull CommandSender sender, @NotNull OfflinePlayer target, @NotNull String path, @NotNull String errorPath, @Nullable Throwable error, TagResolver ... placeholders) {
        CustomMessages.failableContextualPath(sender, target.getUniqueId(), path, errorPath, error, placeholders);
    }

    @Contract(pure=true)
    public static void failableContextualPath(@NotNull CommandSender sender, @NotNull ATPlayer target, @NotNull String path, @NotNull String errorPath, @Nullable Throwable error, TagResolver ... placeholders) {
        CustomMessages.failableContextualPath(sender, target.uuid(), path, errorPath, error, placeholders);
    }

    @Contract(pure=true)
    public static void failable(@NotNull CommandSender sender, @NotNull String path, @NotNull String errorPath, @Nullable Throwable error, TagResolver ... placeholders) {
        String truePath = error != null ? errorPath : path;
        CustomMessages.sendMessage(sender, truePath, placeholders);
        if (error != null && !(error instanceof ATException)) {
            error.printStackTrace();
        }
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    public static Audience asAudience(@NotNull CommandSender sender) {
        if (!PaperLib.isPaper()) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return audience.player(player);
            }
            return audience.sender(sender);
        }
        return sender;
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    public static HoverEventSource<Component> locationBasedTooltip(@NotNull CommandSender sender, @NotNull NamedLocation location, @NotNull String path) {
        TextComponent.Builder tooltipBuilder = (TextComponent.Builder)Component.text().append(CustomMessages.get("Tooltip." + path, new TagResolver[]{Placeholder.unparsed((String)"home", (String)location.getName()), Placeholder.unparsed((String)"warp", (String)location.getName())}));
        if (PermissionUtil.hasPermissionOrStar((Permissible)sender, "at.member." + path + ".location")) {
            tooltipBuilder.append(CustomMessages.get("Tooltip.location", new TagResolver[]{Placeholder.unparsed((String)"x", (String)String.valueOf(location.getLocation().getBlockX())), Placeholder.unparsed((String)"y", (String)String.valueOf(location.getLocation().getBlockY())), Placeholder.unparsed((String)"z", (String)String.valueOf(location.getLocation().getBlockZ())), Placeholder.unparsed((String)"world", (String)location.getLocation().getWorld().getName())}));
        }
        return ((TextComponent)tooltipBuilder.build()).asHoverEvent();
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    public static <T> Component getPagesComponent(int page, @NotNull PagedLists<T> pages, @NotNull Function<T, Component> componentSupplier) {
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), pages.getContentsInPage(page).stream().map(componentSupplier).toList());
    }

    private void addFormsDefault(String command, String title, String description) {
        this.addDefault("Forms." + command + "-title", title);
        this.addDefault("Forms." + command + "-description", description);
    }

    @Contract(pure=true)
    private static boolean isFloodgate(@NotNull CommandSender sender) {
        if (!PluginHookManager.get().floodgateEnabled()) {
            return false;
        }
        try {
            FloodgateApi instance = FloodgateApi.getInstance();
            if (instance.isFloodgateId(((Player)sender).getUniqueId())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Contract(pure=true)
    private void populate() {
        prefixes = ImmutableSortedSet.copyOf((Collection)this.getStringList("Common.prefixes"));
        ImmutableMap.Builder cacheBuilder = ImmutableMap.builder();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayDeque queue = new ArrayDeque(this.getKeys(false));
        while (queue.peek() != null) {
            String rootKey = (String)queue.pop();
            ConfigSection configSection = this.getConfigSection(rootKey);
            if (configSection instanceof CMConfigSection) {
                CMConfigSection configSection2 = (CMConfigSection)configSection;
                configSection2.getKeys(false).stream().map(key -> rootKey + "." + key).forEach(queue::addFirst);
                continue;
            }
            keys.add(rootKey);
        }
        keys.forEach(key -> {
            Object rawValue = this.get((String)key, this.defaults.get(key));
            PartialComponent component = PartialComponent.of(CustomMessages.translateLegacy(rawValue.toString()));
            component.formatRaw((SortedSet<String>)prefixes);
            cacheBuilder.put(key, (Object)component);
        });
        messageCache = cacheBuilder.build();
    }

    @Contract(pure=true)
    private static void handleSpecialMessage(final @NotNull Player player, @NotNull String id, final @NotNull Consumer<String> consumer, final @NotNull HashMap<CommandSender, BukkitRunnable> runnableTracker) {
        if (!config.contains(id)) {
            return;
        }
        if (config.get(id) instanceof String) {
            consumer.accept(config.getString(id));
            return;
        }
        if (config.getConfigSection(id) == null) {
            return;
        }
        final ConfigSection section = config.getConfigSection(id);
        BukkitRunnable runnable = new BukkitRunnable(){
            private final Queue<String> times;
            private int current;
            {
                this.times = new ArrayDeque<String>(section.getKeys(false));
                this.current = 0;
            }

            public void run() {
                if (this.times.isEmpty() || runnableTracker.get(player) != this) {
                    this.cancel();
                    return;
                }
                if (!String.valueOf(this.current++).equals(this.times.peek())) {
                    return;
                }
                String content = section.getString(this.times.poll());
                if (content == null) {
                    return;
                }
                consumer.accept(content);
            }
        };
        runnableTracker.put((CommandSender)player, runnable);
        runnable.runTaskTimer((Plugin)CoreClass.getInstance(), 1L, 1L);
    }

    @Contract(pure=true)
    private static void sendSound(@NotNull Player player, @NotNull String sound, @NotNull String id) {
        float volume = 1.0f;
        float pitch = 1.0f;
        String[] rawSound = sound.split(";");
        if (rawSound.length == 0) {
            return;
        }
        if (rawSound.length == 2) {
            volume = Float.parseFloat(rawSound[1]);
        }
        if (rawSound.length >= 3) {
            pitch = Float.parseFloat(rawSound[2]);
        }
        if (rawSound[0].matches("([a-z0-9_\\-.]+:)?[a-z0-9_\\-./]+")) {
            try {
                player.playSound(net.kyori.adventure.sound.Sound.sound((Key)Key.key((String)rawSound[0]), (Sound.Source)Sound.Source.NEUTRAL, (float)volume, (float)pitch));
            }
            catch (NoClassDefFoundError | NoSuchMethodError ignored) {
                CoreClass.getInstance().getLogger().warning("Sound for " + id + " (" + rawSound[0] + ") could not be played: namespaces are not supported on your platform.");
            }
        } else {
            try {
                player.playSound((Entity)player, Sound.valueOf((String)rawSound[0]), volume, pitch);
            }
            catch (IllegalArgumentException ex) {
                CoreClass.getInstance().getLogger().warning("Sound for " + id + " (" + rawSound[0] + ") could not be played: sound does not exist.");
            }
        }
    }

    @NotNull
    public static Component toTime(int seconds) {
        int days = seconds / 86400;
        int totalHours = seconds % 86400;
        int hours = totalHours / 3600;
        int totalMinutes = totalHours % 3600;
        int minutes = totalMinutes / 60;
        int secondsRemain = seconds % 60;
        Component daysPart = CustomMessages.getTimePart(days, "days");
        Component hoursPart = CustomMessages.getTimePart(hours, "hours");
        Component minutesPart = CustomMessages.getTimePart(minutes, "minutes");
        Component secondsPart = CustomMessages.getTimePart(secondsRemain, "seconds");
        return CustomMessages.getComponent("Common.timeFormat.full", new TagResolver[]{Placeholder.component((String)"days", (ComponentLike)daysPart), Placeholder.component((String)"hours", (ComponentLike)hoursPart), Placeholder.component((String)"minutes", (ComponentLike)minutesPart), Placeholder.component((String)"seconds", (ComponentLike)secondsPart)});
    }

    @ApiStatus.Internal
    @NotNull
    private static Component getTimePart(int value, @NotNull String type) {
        TagResolver.Single placeholder = Placeholder.parsed((String)type, (String)String.valueOf(value));
        return value < 1 ? Component.empty() : (value == 1 ? CustomMessages.getComponent("Common.timeFormat." + type + ".singular", new TagResolver[]{placeholder}) : CustomMessages.getComponent("Common.timeFormat." + type + ".plural", new TagResolver[]{placeholder}));
    }

    @ApiStatus.Internal
    @NotNull
    public static String translateLegacy(String format) {
        format = format.replace('{', '<').replace('}', '>');
        LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();
        format = (String)MiniMessage.miniMessage().serialize((Component)serializer.deserialize(format));
        format = format.replace("\\<", "<");
        format = CustomMessages.translateMarkdown(format);
        return format;
    }

    @ApiStatus.Internal
    @NotNull
    private static String translateMarkdown(String format) {
        int startTextPointer = -1;
        int endTextPointer = -1;
        int startCommandPointer = -1;
        boolean lastMarkdownPointer = false;
        boolean building = false;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < format.length(); ++i) {
            if (!(building || format.charAt(i) != '[' || i != 0 && format.charAt(i - 1) == '\\')) {
                startTextPointer = i + 1;
                building = true;
                continue;
            }
            if (building && format.charAt(i) == ']' && format.charAt(i - 1) != '\\') {
                endTextPointer = i;
                continue;
            }
            if (building && format.charAt(i) == '(') {
                if (format.charAt(i - 1) == ']') {
                    startCommandPointer = i + 1;
                    continue;
                }
                if (startCommandPointer != -1) continue;
                building = false;
                startTextPointer = -1;
                endTextPointer = -1;
                continue;
            }
            if (!building) {
                result.append(format.charAt(i));
                continue;
            }
            if (format.charAt(i) != ')' || format.charAt(i - 1) == '\\' || startCommandPointer == -1) continue;
            int endCommandPointer = i;
            String text = format.substring(startTextPointer, endTextPointer);
            String[] commands = format.substring(startCommandPointer, endCommandPointer).split("\\|");
            String command = null;
            String url = null;
            ArrayList<String> hoverText = new ArrayList<String>();
            for (String cmd : commands) {
                if (cmd.startsWith("/")) {
                    command = cmd;
                    continue;
                }
                if (cmd.startsWith("http")) {
                    url = cmd;
                    continue;
                }
                hoverText.add(CustomMessages.stripEndingTags(cmd));
            }
            Object component = CustomMessages.stripEndingTags(text);
            if (command != null) {
                component = "<click:run_command:'" + command + "'>" + (String)component + "</click>";
            }
            if (url != null) {
                component = "<click:open_url:'" + url + "'>" + (String)component + "</click>";
            }
            if (!hoverText.isEmpty()) {
                component = "<hover:show_text:'" + String.join((CharSequence)"\n", hoverText) + "'>" + (String)component + "</hover>";
            }
            result.append((String)component);
            building = false;
            startTextPointer = -1;
            endTextPointer = -1;
            startCommandPointer = -1;
        }
        if (building) {
            result.append(format.substring(startTextPointer - 1));
        }
        return result.toString();
    }

    @ApiStatus.Internal
    private static String stripEndingTags(String input) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("^(</[a-zA-Z_-]+>)");
        while ((matcher = pattern.matcher(input)).find()) {
            String tag = matcher.group(1);
            input = input.replaceFirst(tag, "");
        }
        return input;
    }

    static {
        messageCache = ImmutableMap.of();
        prefixes = ImmutableSortedSet.of();
    }
}

