/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.warp;

import io.github.niestrat99.advancedteleport.CoreClass;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.commands.ATCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.GUIConfig;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import io.github.niestrat99.advancedteleport.libs.configurationmaster.api.ConfigSection;
import io.github.niestrat99.advancedteleport.utilities.IconMenu;
import io.github.niestrat99.advancedteleport.utilities.PermissionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public final class WarpsCommand
extends ATCommand {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        WarpsCommand.sendWarps(sender);
        return true;
    }

    public static void sendWarps(CommandSender sender) {
        if (GUIConfig.isUsingWarpsGUIMenu()) {
            ConfigSection warps = GUIConfig.getWarpsMenu();
            int minPage = 999;
            int maxPage = 0;
            for (String warp2 : warps.getKeys(false)) {
                int page = warps.getInteger(warp2 + ".page");
                if (page < minPage) {
                    minPage = page;
                }
                if (page <= maxPage) continue;
                maxPage = page;
            }
            int pages = maxPage - minPage + 1;
            IconMenu menu = new IconMenu(CustomMessages.asString("Info.warps"), GUIConfig.getWarpsMenuSlots(), pages, CoreClass.getInstance());
            for (String warpName : warps.getKeys(false)) {
                ConfigSection warp3 = warps.getConfigSection(warpName);
                if (!sender.hasPermission("at.member.warp.*") && !sender.hasPermission("at.member.warp." + warpName) && warp3.getBoolean("hideIfNoPermission")) continue;
                menu.setIcon(warp3.getInteger("page"), warp3.getInteger("slot"), new IconMenu.Icon(new ItemStack(Material.valueOf((String)warp3.getString("item")), 1, (short)((byte)warp3.getInteger("data-value")))).withNameAndLore(warp3.getString("name"), warp3.getStringList("tooltip")).withCommands("warp " + warpName).withTexture("texture"));
            }
            for (int i = 0; i < pages; ++i) {
                if (i != 0) {
                    ConfigSection lastPage = GUIConfig.getLastPageIcon();
                    menu.setIcon(i, lastPage.getInteger("slot"), new IconMenu.Icon(new ItemStack(Material.valueOf((String)lastPage.getString("item")), 1, (short)((byte)lastPage.getInteger("data-value")))).withTexture(lastPage.getString("texture")).withNameAndLore(lastPage.getString("name"), lastPage.getStringList("tooltip")).withHandler(handler -> {
                        handler.setWillClose(false);
                        handler.setWillDestroy(false);
                        menu.openPreviousPage();
                    }));
                }
                if (i == pages - 1) continue;
                ConfigSection nextPage = GUIConfig.getNextPageIcon();
                menu.setIcon(i, nextPage.getInteger("slot"), new IconMenu.Icon(new ItemStack(Material.valueOf((String)nextPage.getString("item")), 1, (short)((byte)nextPage.getInteger("data-value")))).withTexture(nextPage.getString("texture")).withNameAndLore(nextPage.getString("name"), nextPage.getStringList("tooltip")).withHandler(handler -> {
                    handler.setWillClose(false);
                    handler.setWillDestroy(false);
                    menu.openNextPage();
                }));
            }
            menu.open((Player)sender);
        } else {
            TextComponent body = (TextComponent)Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), AdvancedTeleportAPI.getWarps().values().stream().filter(warp -> PermissionUtil.hasPermissionOrStar((Permissible)sender, "at.member.warp." + warp.getName().toLowerCase())).map(warp -> (TextComponent)((TextComponent)Component.text((String)warp.getName()).clickEvent(ClickEvent.runCommand((String)("/advancedteleport:warp " + warp.getName())))).hoverEvent(CustomMessages.locationBasedTooltip(sender, warp, "warps"))).toList());
            if (!body.content().isEmpty() || !body.children().isEmpty()) {
                String text = CustomMessages.config.getString("Info.warps") + "<warps>";
                CustomMessages.sendMessage(sender, CustomMessages.translate(text, new TagResolver[]{Placeholder.component((String)"warps", (ComponentLike)body)}));
            } else {
                CustomMessages.sendMessage(sender, "Error.noWarps", new TagResolver[0]);
            }
        }
    }

    @Override
    public boolean getRequiredFeature() {
        return MainConfig.get().USE_WARPS.get();
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.warps";
    }
}

