/*
 * Decompiled with CFR 0.152.
 */
package io.github.niestrat99.advancedteleport.commands.warp;

import io.github.niestrat99.advancedteleport.api.ATFloodgatePlayer;
import io.github.niestrat99.advancedteleport.api.ATPlayer;
import io.github.niestrat99.advancedteleport.api.AdvancedTeleportAPI;
import io.github.niestrat99.advancedteleport.api.Warp;
import io.github.niestrat99.advancedteleport.api.events.ATTeleportEvent;
import io.github.niestrat99.advancedteleport.commands.TimedATCommand;
import io.github.niestrat99.advancedteleport.commands.warp.AbstractWarpCommand;
import io.github.niestrat99.advancedteleport.config.CustomMessages;
import io.github.niestrat99.advancedteleport.config.MainConfig;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public final class WarpCommand
extends AbstractWarpCommand
implements TimedATCommand {
    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (!this.canProceed(sender)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            ATPlayer atPlayer = ATPlayer.getPlayer(player);
            if (atPlayer instanceof ATFloodgatePlayer) {
                ATFloodgatePlayer atFloodgatePlayer = (ATFloodgatePlayer)atPlayer;
                if (MainConfig.get().USE_FLOODGATE_FORMS.get().booleanValue()) {
                    if (!AdvancedTeleportAPI.getWarps().isEmpty()) {
                        atFloodgatePlayer.sendWarpForm();
                        return true;
                    }
                    CustomMessages.sendMessage(sender, "Error.noWarps", new TagResolver[0]);
                    return true;
                }
            }
            CustomMessages.sendMessage(sender, "Error.noWarpInput", new TagResolver[0]);
            return false;
        }
        Warp warp = (Warp)AdvancedTeleportAPI.getWarps().get((Object)args[0]);
        if (warp != null) {
            WarpCommand.warp(warp, player, false);
            return true;
        }
        CustomMessages.sendMessage(sender, "Error.noSuchWarp", new TagResolver[0]);
        return true;
    }

    public static void warp(Warp warp, Player player, boolean useSign) {
        String warpPrefix = "at.member.warp." + (useSign ? "sign." : "");
        boolean found = player.hasPermission(warpPrefix + "*");
        if (player.isPermissionSet(warpPrefix + warp.getName().toLowerCase())) {
            found = player.hasPermission(warpPrefix + warp.getName().toLowerCase());
        }
        if (!found) {
            CustomMessages.sendMessage((CommandSender)player, "Error.noPermissionWarp", new TagResolver[]{Placeholder.unparsed((String)"warp", (String)warp.getName())});
            return;
        }
        ATTeleportEvent event = new ATTeleportEvent(player, warp.getLocation(), player.getLocation(), warp.getName(), ATTeleportEvent.TeleportType.WARP);
        Bukkit.getPluginManager().callEvent((Event)event);
        ATPlayer.getPlayer(player).teleport(event, "warp", "Teleport.teleportingToWarp");
    }

    @Override
    @NotNull
    public String getPermission() {
        return "at.member.warp";
    }

    @Override
    @NotNull
    public String getSection() {
        return "warp";
    }
}

